/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.classloader.plugins.filter.PatternClassFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageClassFilter
extends PatternClassFilter {
    private String[] packageNames;

    private static String[] convertPackageNamesToClassPatterns(String[] packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("Null package names");
        }
        String[] patterns = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            if (packageNames[i] == null) {
                throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
            }
            patterns[i] = packageNames[i].length() == 0 ? "[^.]*" : packageNames[i].replace(".", "\\.") + "\\.[^.]+";
        }
        return patterns;
    }

    private static String[] convertPackageNamesToResourcePatterns(String[] packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("Null package names");
        }
        String[] patterns = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            if (packageNames[i] == null) {
                throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
            }
            patterns[i] = packageNames[i].length() == 0 ? "[^/]*" : packageNames[i].replace(".", "/") + "/[^/]+";
        }
        return patterns;
    }

    public static PackageClassFilter createPackageClassFilterFromString(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        ArrayList<String> packages = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            packages.add(tokenizer.nextToken());
        }
        return PackageClassFilter.createPackageClassFilter(packages);
    }

    public static PackageClassFilter createPackageClassFilter(String ... packageNames) {
        return new PackageClassFilter(packageNames);
    }

    public static PackageClassFilter createPackageClassFilter(List<String> packageNames) {
        String[] packages = packageNames == null ? new String[]{} : packageNames.toArray(new String[packageNames.size()]);
        return new PackageClassFilter(packages);
    }

    public PackageClassFilter(String[] packageNames) {
        super(PackageClassFilter.convertPackageNamesToClassPatterns(packageNames), PackageClassFilter.convertPackageNamesToResourcePatterns(packageNames), packageNames);
        this.packageNames = packageNames;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Arrays.asList(this.packageNames));
        if (this.isIncludeJava()) {
            builder.append(" <INCLUDE_JAVA>");
        }
        return builder.toString();
    }
}

