/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.PackageInformation;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.spi.jdk.JDKChecker;
import org.jboss.classloader.spi.jdk.JDKCheckerFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoaderPolicy
extends BaseClassLoaderPolicy {
    private static final Logger log = Logger.getLogger(ClassLoaderPolicy.class);

    @Override
    public DelegateLoader getExported() {
        String[] packageNames = this.getPackageNames();
        if (packageNames == null) {
            return null;
        }
        return new FilteredDelegateLoader(this, (ClassFilter)PackageClassFilter.createPackageClassFilter(packageNames));
    }

    @Override
    public String[] getPackageNames() {
        return null;
    }

    @Override
    protected List<? extends DelegateLoader> getDelegates() {
        return Collections.emptyList();
    }

    @Override
    protected boolean isImportAll() {
        return false;
    }

    @Override
    protected boolean isCacheable() {
        return true;
    }

    @Override
    protected boolean isBlackListable() {
        return true;
    }

    public abstract URL getResource(String var1);

    public InputStream getResourceAsStream(String path) {
        URL url = this.getResource(path);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                log.debug((Object)("Unable to open URL: " + url + " for path " + path + " from " + this.toLongString()));
            }
        }
        return null;
    }

    public abstract void getResources(String var1, Set<URL> var2) throws IOException;

    @Override
    protected ProtectionDomain getProtectionDomain(String className, String path) {
        return null;
    }

    public PackageInformation getPackageInformation(String packageName) {
        return null;
    }

    @Override
    protected ClassLoader isJDKRequest(String name) {
        JDKChecker checker = JDKCheckerFactory.getChecker();
        if (checker.isJDKRequest(name)) {
            return this.getSystemClassLoader();
        }
        return null;
    }

    @Override
    public ObjectName getObjectName() {
        try {
            String name = this.getName();
            if (name != null && name.trim().length() > 0) {
                return ObjectName.getInstance("jboss.classloader", "id", "\"" + name + "\"");
            }
            return ObjectName.getInstance("jboss.classloader", "id", "" + System.identityHashCode(this));
        }
        catch (MalformedObjectNameException e) {
            throw new Error("Error creating object name", e);
        }
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        boolean importAll;
        builder.append(" delegates=").append(this.getDelegates());
        String[] packageNames = this.getPackageNames();
        if (packageNames != null) {
            builder.append(" exported=").append(Arrays.asList(packageNames));
        }
        if (importAll = this.isImportAll()) {
            builder.append(" <IMPORT-ALL>");
        }
    }

    private ClassLoader getSystemClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(GetSystemClassLoader.INSTANCE, this.getAccessControlContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSystemClassLoader
    implements PrivilegedAction<ClassLoader> {
        private static GetSystemClassLoader INSTANCE = new GetSystemClassLoader();

        private GetSystemClassLoader() {
        }

        @Override
        public ClassLoader run() {
            return ClassLoader.getSystemClassLoader();
        }
    }
}

