/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxr.juddi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.registry.ConnectionFactory;
import org.apache.ws.scout.registry.ConnectionFactoryImpl;
import org.jboss.jaxr.juddi.JUDDIServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public class JUDDIService
extends ServiceMBeanSupport
implements JUDDIServiceMBean {
    protected boolean dropOnStart = false;
    protected boolean createOnStart = false;
    protected boolean dropOnStop = false;
    protected boolean loadNAICS = false;
    protected boolean loadUNSPSC = false;
    protected DataSource datasource = null;
    protected String datasourceurl = null;
    protected String registryOperator = null;
    protected String bindJaxr = null;
    protected boolean shouldBindJaxr = true;
    protected boolean dropDB = false;
    private boolean jndiAlreadyBound = false;

    protected Connection getConnection() throws SQLException, NamingException {
        try {
            if (this.datasource == null) {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup(this.datasourceurl);
                this.log.debug((Object)obj.getClass().getName());
                this.datasource = (DataSource)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)e);
        }
        return this.datasource.getConnection();
    }

    protected void runDrop() throws SQLException, IOException {
        this.log.debug((Object)"JUDDIService: Inside runDrop");
        this.locateAndRunScript("juddi_drop_db.ddl");
        this.log.debug((Object)"JUDDIService: Exit runDrop");
    }

    protected void runCreate() throws SQLException, IOException {
        this.log.debug((Object)"JUDDIService: Inside runCreate");
        this.locateAndRunScript("juddi_create_db.ddl");
        this.locateAndRunScript("juddi_data.ddl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateAndRunScript(String name) throws SQLException, IOException {
        this.log.debug((Object)"JUDDIService: Inside locateScript");
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("META-INF/ddl/" + name);
        if (input != null) {
            try {
                this.runScript(input);
            }
            finally {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runScript(InputStream stream) throws SQLException, IOException {
        boolean firstError = true;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Connection connection = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                this.log.debug((Object)"Obtained the Connection");
            }
            Statement statement = connection.createStatement();
            try {
                String nextLine;
                String nextStatement = "";
                while ((nextLine = reader.readLine()) != null) {
                    this.log.debug((Object)("Statement Obtained=" + nextLine));
                    if ((nextLine = nextLine.trim()).indexOf("--") != -1) continue;
                    int semicolon = nextLine.indexOf(";");
                    if (semicolon != -1) {
                        block18: {
                            nextStatement = nextStatement + nextLine.substring(0, semicolon);
                            try {
                                this.log.debug((Object)("Statement to execute:" + nextStatement));
                                statement.execute(nextStatement);
                            }
                            catch (SQLException e) {
                                String err = "Could not execute a statement of juddi script::";
                                if (!firstError) break block18;
                                this.log.debug((Object)(err + e.getLocalizedMessage() + " " + nextStatement));
                                this.log.debug((Object)("Your settings are:dropOnStart =" + this.dropOnStart + ";createOnStart =" + this.createOnStart));
                                this.log.debug((Object)("dropOnStop = " + this.dropOnStop));
                                firstError = false;
                            }
                        }
                        nextStatement = nextLine.substring(semicolon + 1);
                        continue;
                    }
                    nextStatement = nextStatement + nextLine;
                }
                if (!nextStatement.equals("")) {
                    try {
                        this.log.debug((Object)("Statement to execute:" + nextStatement));
                        statement.execute(nextStatement);
                    }
                    catch (SQLException e) {
                        this.log.debug((Object)("Could not execute last statement of a juddi init script: " + e.getLocalizedMessage()));
                        this.log.debug((Object)("Your settings are:dropOnStart =" + this.dropOnStart + ";createOnStart =" + this.createOnStart));
                        this.log.debug((Object)("dropOnStop = " + this.dropOnStop));
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (NamingException nm) {
            this.log.error((Object)"Looks like DataSource was tried with the wrong JNDI name");
            this.log.error((Object)nm);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void startService() throws Exception {
        this.log.debug((Object)("JUDDIService: Inside startService with dropOnStart=" + this.dropOnStart + " createOnStart=" + this.createOnStart));
        if (this.shouldBindJaxr && !this.jndiAlreadyBound) {
            this.bindJAXRConnectionFactory();
        }
        if (this.dropOnStart) {
            this.runDrop();
        }
        if (this.createOnStart) {
            this.runCreate();
        }
    }

    public void stopService() throws Exception {
        this.log.debug((Object)("JUDDIService: Inside stopService with dropOnStop=" + this.dropOnStop));
        if (this.dropOnStop) {
            this.runDrop();
        }
        this.unBindJAXRConnectionFactory();
    }

    public boolean isDropOnStart() {
        return this.dropOnStart;
    }

    public void setDropOnStart(boolean dropOnStart) {
        this.dropOnStart = dropOnStart;
    }

    public boolean isDropOnStop() {
        return this.dropOnStop;
    }

    public void setDropOnStop(boolean dropOnStop) {
        this.dropOnStop = dropOnStop;
    }

    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    public void setCreateOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
    }

    public String getDataSource() {
        return this.datasourceurl;
    }

    public void setDataSourceUrl(String ds) {
        this.datasourceurl = ds;
    }

    public String getRegistryOperator() {
        return this.registryOperator;
    }

    public void setRegistryOperator(String ro) {
        this.registryOperator = ro;
    }

    public String getBindJaxr() {
        return this.bindJaxr;
    }

    public void setBindJaxr(String str) {
        this.bindJaxr = str;
        if (this.shouldBindJaxr) {
            this.bindJAXRConnectionFactory();
        }
    }

    public boolean getShouldBindJaxr() {
        return this.shouldBindJaxr;
    }

    public void setShouldBindJaxr(boolean str) {
        this.shouldBindJaxr = str;
        if (this.shouldBindJaxr) {
            this.bindJAXRConnectionFactory();
        }
    }

    public boolean getDropDB() {
        return this.dropDB;
    }

    public void setDropDB(boolean b) {
        this.dropDB = b;
        try {
            if (this.datasource != null) {
                this.runDrop();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.toString());
        }
    }

    private void bindJAXRConnectionFactory() {
        if (this.bindJaxr == null || this.jndiAlreadyBound) {
            return;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            this.log.error((Object)"JNDI InitialContext Failed");
            e.printStackTrace();
        }
        ConnectionFactory factory = ConnectionFactoryImpl.newInstance();
        try {
            ctx.rebind(this.bindJaxr, (Object)factory);
            this.jndiAlreadyBound = true;
        }
        catch (NamingException e) {
            this.log.error((Object)("JNDI Bind Failed:" + this.bindJaxr));
            e.printStackTrace();
        }
    }

    private void unBindJAXRConnectionFactory() {
        if (this.bindJaxr == null || this.jndiAlreadyBound) {
            return;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            this.log.error((Object)"JNDI InitialContext Failed");
            e.printStackTrace();
        }
        try {
            ctx.unbind(this.bindJaxr);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

