/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.javaee.JavaEEComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASDepdencyPolicy
extends JBoss5DependencyPolicy
implements DependencyPolicy {
    private JavaEEComponent component;
    private Set<DependencyMetaData> dependencies = new HashSet<DependencyMetaData>();
    private Set<DemandMetaData> demands = new HashSet<DemandMetaData>();
    private Set<SupplyMetaData> supplies = new HashSet<SupplyMetaData>();

    public JBossASDepdencyPolicy(JavaEEComponent component) {
        super(component);
        this.component = component;
    }

    public void addDependency(String dependency) {
        this.addDependency((DemandMetaData)new AbstractDemandMetaData((Object)dependency));
    }

    public void addDependency(DemandMetaData dependency) {
        this.demands.add(dependency);
    }

    public void addDependency(DependencyMetaData dependency) {
        this.dependencies.add(dependency);
    }

    public void addDependency(Class<?> businessInterface) {
        this.addDependency("Class:" + businessInterface.getName());
    }

    public void addDependency(String ejbLink, Class<?> businessInterface) {
        assert (ejbLink != null) : "ejbLink is null";
        int hashIndex = ejbLink.indexOf(35);
        if (hashIndex != -1) {
            String unitName = ejbLink.substring(0, hashIndex);
            String ejbName = ejbLink.substring(hashIndex + 1);
            String ejb3Name = this.component.createObjectName(unitName, ejbName);
            String ejb2Name = "TODO...";
            Object demand = null;
            AbstractDemandMetaData admd = new AbstractDemandMetaData(demand);
            admd.setTransformer("");
        }
    }

    public void addJNDIName(String name) {
        assert (name != null) : "name is null";
        assert (name.length() > 0) : "name is empty";
        this.addDependency("jndi:" + name);
    }

    public Set<DependencyMetaData> getDependencies() {
        return this.dependencies;
    }

    public Set<DemandMetaData> getDemands() {
        return this.demands;
    }

    public void addSupply(Class<?> businessInterface) {
        this.supplies.add((SupplyMetaData)new AbstractSupplyMetaData((Object)("Class:" + businessInterface.getName())));
    }

    public Set<SupplyMetaData> getSupplies() {
        return this.supplies;
    }

    public void addDatasource(String jndiName) {
        String ds = jndiName;
        if (ds.startsWith("java:/")) {
            ds = ds.substring(6);
        } else if (ds.startsWith("java:")) {
            ds = ds.substring(5);
        }
        String onStr = "jboss.jca:name=" + ds + ",service=DataSourceBinding";
        this.addDependency(onStr);
    }
}

