/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.repository.MutableRepository;
import org.jboss.profileservice.spi.repository.Repository;
import org.jboss.profileservice.spi.repository.RepositoryAdmin;
import org.jboss.profileservice.spi.repository.Resource;
import org.jboss.system.server.profileservice.repository.AttachmentsResource;
import org.jboss.system.server.profileservice.repository.VFSDeploymentResource;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryAdminAdaptor
implements DeploymentRepository {
    private static Logger log = Logger.getLogger(RepositoryAdminAdaptor.class);
    private RepositoryAdmin delegate;
    private File root;
    private File bootstrapDir;
    private File libDir;
    private File deployersDir;
    private File[] applicationDirs;
    private File adminEditsRoot;
    private ProfileKey key;
    private long lastModified;

    @Override
    public void addDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception {
        MutableRepository mrepo = this.getRepository(d.getRoot().toURI());
        VFSDeploymentResource dres = new VFSDeploymentResource(d, phase, mrepo);
        mrepo.addResource(dres);
    }

    @Override
    public String addDeploymentContent(String name, InputStream contentIS, ManagedDeployment.DeploymentPhase phase) throws IOException {
        throw new IOException("Not yet implemented");
    }

    @Override
    public String[] getRepositoryNames(String[] names, ManagedDeployment.DeploymentPhase phase) throws IOException {
        return null;
    }

    @Override
    public VirtualFile getDeploymentContent(String vfsPath, ManagedDeployment.DeploymentPhase phase) throws IOException {
        return null;
    }

    @Override
    public void lockDeploymentContent(String vfsPath, ManagedDeployment.DeploymentPhase phase) {
    }

    @Override
    public void acquireDeploymentContentLock() {
    }

    @Override
    public void releaseDeploymentContentLock() {
    }

    @Override
    public void unlockDeploymentContent(String vfsPath, ManagedDeployment.DeploymentPhase phase) {
    }

    @Override
    public void addManagedObject(String vfsPath, Attachments edits) throws Exception {
        MutableRepository repo = this.getRepository(this.adminEditsRoot.toURI());
        AttachmentsResource attachments = new AttachmentsResource(vfsPath, edits, repo);
        repo.addResource(attachments);
        this.lastModified = System.currentTimeMillis();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void create() throws Exception {
        File profileRoot = new File(this.root, this.key.getName());
        if (profileRoot.exists()) {
            throw new IOException("Profile root already exists: " + profileRoot);
        }
        if (!profileRoot.mkdirs()) {
            throw new IOException("Failed to create profile root: " + profileRoot);
        }
        this.bootstrapDir = new File(profileRoot, "bootstrap");
        if (!this.bootstrapDir.mkdirs()) {
            throw new IOException("Failed to create profile bootstrap dir: " + this.bootstrapDir);
        }
        this.delegate.addRepository(this.bootstrapDir.toURI());
        this.deployersDir = new File(profileRoot, "deployers");
        if (!this.deployersDir.mkdirs()) {
            throw new IOException("Failed to create profile deployers dir: " + this.deployersDir);
        }
        this.delegate.addRepository(this.deployersDir.toURI());
        for (File applicationDir : this.applicationDirs) {
            if (!applicationDir.mkdirs()) {
                throw new IOException("Failed to create profile deploy dir: " + applicationDir);
            }
            this.delegate.addRepository(applicationDir.toURI());
        }
        this.libDir = new File(profileRoot, "lib");
        if (!this.libDir.mkdirs()) {
            throw new IOException("Failed to create profile lib dir: " + this.libDir);
        }
        this.delegate.addRepository(this.libDir.toURI());
        this.adminEditsRoot = new File(profileRoot, "profile/edits");
        if (!this.adminEditsRoot.mkdirs()) {
            throw new IOException("Failed to create profile adminEdits dir: " + this.adminEditsRoot);
        }
        this.delegate.addRepository(this.adminEditsRoot.toURI());
        this.lastModified = System.currentTimeMillis();
    }

    @Override
    public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception, NoSuchDeploymentException {
        VFSDeployment ctx = null;
        if (phase == null) {
            try {
                ctx = this.getBootstrap(name);
            }
            catch (NoSuchDeploymentException ignore) {
                // empty catch block
            }
            try {
                if (ctx == null) {
                    ctx = this.getDeployer(name);
                }
            }
            catch (NoSuchDeploymentException ignore) {
                // empty catch block
            }
            try {
                if (ctx == null) {
                    ctx = this.getApplication(name);
                }
            }
            catch (NoSuchDeploymentException ignore) {}
        } else {
            switch (phase) {
                case BOOTSTRAP: {
                    ctx = this.getBootstrap(name);
                    break;
                }
                case DEPLOYER: {
                    ctx = this.getDeployer(name);
                    break;
                }
                case APPLICATION: {
                    ctx = this.getApplication(name);
                }
            }
        }
        if (ctx == null) {
            throw new NoSuchDeploymentException("name=" + name + ", phase=" + phase);
        }
        return ctx;
    }

    @Override
    public Set<String> getDeploymentNames() {
        Repository[] repositories;
        HashSet<String> names = new HashSet<String>();
        for (Repository repo : repositories = this.delegate.listRepositories()) {
            Resource[] resources;
            for (Resource res : resources = repo.getResources()) {
                if (!(res instanceof VFSDeploymentResource)) continue;
                VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
                names.add(vfsres.getSymbolicName());
            }
        }
        return names;
    }

    @Override
    public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase) {
        HashSet<String> names = new HashSet<String>();
        URI uri = this.getDeploymentURI(phase);
        try {
            Resource[] resources;
            Repository repo = this.delegate.getRepository(uri);
            for (Resource res : resources = repo.getResources()) {
                if (!(res instanceof VFSDeploymentResource)) continue;
                VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
                names.add(vfsres.getSymbolicName());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return names;
    }

    public Set<String> getDeploymentNamesForType(String type) {
        return null;
    }

    @Override
    public Collection<VFSDeployment> getDeployments() throws Exception {
        Repository[] repositories;
        HashSet<VFSDeployment> deployments = new HashSet<VFSDeployment>();
        for (Repository repo : repositories = this.delegate.listRepositories()) {
            Resource[] resources;
            for (Resource res : resources = repo.getResources()) {
                VFSDeploymentResource vfsres;
                VFSDeployment deployment;
                if (!(res instanceof VFSDeploymentResource) || (deployment = (VFSDeployment)(vfsres = (VFSDeploymentResource)res).getProperties().get("deployment")) == null) continue;
                deployments.add(deployment);
            }
        }
        return deployments;
    }

    @Override
    public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase) throws Exception {
        URI uri = this.getDeploymentURI(phase);
        Repository repo = this.delegate.getRepository(uri);
        Resource[] resources = repo.getResources();
        HashSet<VFSDeployment> deployments = new HashSet<VFSDeployment>();
        for (Resource res : resources) {
            VFSDeploymentResource vfsres;
            VFSDeployment deployment;
            if (!(res instanceof VFSDeploymentResource) || (deployment = (VFSDeployment)(vfsres = (VFSDeploymentResource)res).getProperties().get("deployment")) == null) continue;
            deployments.add(deployment);
        }
        return deployments;
    }

    @Override
    public URI getDeploymentURI(ManagedDeployment.DeploymentPhase phase) {
        URI uri = null;
        switch (phase) {
            case BOOTSTRAP: {
                uri = this.getBootstrapURI();
                break;
            }
            case DEPLOYER: {
                uri = this.getDeployersURI();
                break;
            }
            case APPLICATION: {
                uri = this.getApplicationURI();
            }
        }
        return uri;
    }

    @Override
    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        ArrayList<ModificationInfo> modified = new ArrayList<ModificationInfo>();
        URI appURI = this.getApplicationURI();
        MutableRepository repo = this.getRepository(appURI);
        Collection<Resource> resources = repo.getModifiedResources();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Checking applications for modifications");
        }
        if (resources != null) {
            for (Resource res : resources) {
                ModificationInfo info;
                VFSDeployment ctx = (VFSDeployment)res.getProperties().get("deployment");
                if (ctx == null) continue;
                MutableRepository.ModifyStatus status = (MutableRepository.ModifyStatus)((Object)res.getProperties().get("modifyStatus"));
                Long lastModified = (Long)res.getProperties().get("lastModified");
                VirtualFile root = ctx.getRoot();
                String name = root.getPathName();
                if (status == MutableRepository.ModifyStatus.REMOVED) {
                    info = new ModificationInfo(ctx, lastModified, ModificationInfo.ModifyStatus.REMOVED);
                    modified.add(info);
                    if (!trace) continue;
                    log.trace((Object)(name + " was removed"));
                    continue;
                }
                if (status == MutableRepository.ModifyStatus.MODIFIED) {
                    if (trace) {
                        log.trace((Object)(name + " was modified: " + lastModified));
                    }
                    info = new ModificationInfo(ctx, lastModified, ModificationInfo.ModifyStatus.MODIFIED);
                    modified.add(info);
                    continue;
                }
                if (status != MutableRepository.ModifyStatus.ADDED) continue;
                if (trace) {
                    log.trace((Object)(name + " was added: " + lastModified));
                }
                info = new ModificationInfo(ctx, lastModified, ModificationInfo.ModifyStatus.ADDED);
                modified.add(info);
            }
        }
        if (modified.size() > 0) {
            this.lastModified = System.currentTimeMillis();
        }
        return modified;
    }

    @Override
    public void load() throws Exception {
    }

    @Override
    public void remove() throws Exception {
        Repository[] repositories;
        for (Repository repo : repositories = this.delegate.listRepositories()) {
            this.delegate.removeRepository(repo.getURI());
        }
    }

    @Override
    public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception {
        URI uri = null;
        switch (phase) {
            case BOOTSTRAP: {
                uri = this.getBootstrapURI();
                break;
            }
            case DEPLOYER: {
                uri = this.getDeployersURI();
                break;
            }
            case APPLICATION: {
                uri = this.getApplicationURI();
            }
        }
        VFSDeployment ctx = this.removeDeployment(name, uri);
        return ctx;
    }

    @Override
    public void setDeploymentURI(URI uri, ManagedDeployment.DeploymentPhase phase) {
        switch (phase) {
            case BOOTSTRAP: {
                this.setBootstrapURI(uri);
                break;
            }
            case DEPLOYER: {
                this.setDeployersURI(uri);
                break;
            }
            case APPLICATION: {
                this.setApplicationURIs(new URI[]{uri});
            }
        }
    }

    @Override
    public void updateDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception {
    }

    protected MutableRepository getRepository(URI uri) throws Exception {
        Repository repo = this.delegate.getRepository(uri);
        if (!(repo instanceof MutableRepository)) {
            throw new IllegalStateException("Repository does not support MutableRepository");
        }
        MutableRepository mrepo = (MutableRepository)repo;
        return mrepo;
    }

    protected VFSDeployment getBootstrap(String vfsPath) throws Exception {
        Resource res = this.delegate.getResource(vfsPath);
        if (res == null || !(res instanceof VFSDeploymentResource)) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
        VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
        return deployment;
    }

    protected VFSDeployment getDeployer(String vfsPath) throws Exception {
        Resource res = this.delegate.getResource(vfsPath);
        if (res == null || !(res instanceof VFSDeploymentResource)) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
        VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
        return deployment;
    }

    protected VFSDeployment getApplication(String vfsPath) throws Exception {
        Resource res = this.delegate.getResource(vfsPath);
        if (res == null || !(res instanceof VFSDeploymentResource)) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
        VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
        return deployment;
    }

    protected URI getBootstrapURI() {
        return this.bootstrapDir.toURI();
    }

    protected URI getDeployersURI() {
        return this.deployersDir.toURI();
    }

    protected URI getApplicationURI() {
        File applicationDir = this.applicationDirs[0];
        return applicationDir.toURI();
    }

    protected void setBootstrapURI(URI uri) {
        this.bootstrapDir = new File(uri);
    }

    protected void setDeployersURI(URI uri) {
        this.deployersDir = new File(uri);
    }

    public void setApplicationURIs(URI[] uris) {
        this.applicationDirs = new File[uris.length];
        for (int n = 0; n < uris.length; ++n) {
            URI uri = uris[n];
            this.applicationDirs[n] = new File(uri);
        }
    }

    protected VFSDeployment removeDeployment(String name, URI uri) throws Exception {
        MutableRepository mrepo = this.getRepository(uri);
        Resource res = mrepo.removeResource(name);
        VFSDeploymentResource vfsres = (VFSDeploymentResource)res;
        VFSDeployment deployment = (VFSDeployment)vfsres.getProperties().get("deployment");
        return deployment;
    }
}

