/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.jboss.cache.marshall.io.ReusableObjectInputStream;

public class ReusableObjectOutputStream
extends ObjectOutputStream {
    ResettableByteArrayOutputStream baos;
    boolean initialised = false;
    private static int defaultBufferSize = 128;

    public ReusableObjectOutputStream() throws IOException, SecurityException {
        this(new ResettableByteArrayOutputStream());
    }

    protected ReusableObjectOutputStream(ResettableByteArrayOutputStream baos) throws IOException, SecurityException {
        super(baos);
        this.baos = baos;
    }

    public void init() {
        this.baos.init();
        this.initialised = true;
        this.baos.write(121);
    }

    public void reset() throws IOException {
        if (this.initialised) {
            super.reset();
            super.flush();
            this.baos.reset();
            super.flush();
            this.baos.trim();
            this.initialised = false;
        }
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        return this.baos.toByteArray();
    }

    static class ResettableByteArrayOutputStream
    extends ByteArrayOutputStream {
        ResettableByteArrayOutputStream() {
            super(defaultBufferSize);
        }

        int getBufSize() {
            return this.buf.length;
        }

        public void trim() {
            if (this.buf.length > defaultBufferSize) {
                this.buf = null;
            }
        }

        public void init() {
            if (this.buf == null) {
                this.buf = new byte[defaultBufferSize];
            }
            System.arraycopy(ReusableObjectInputStream.INIT_BYTES, 0, this.buf, 0, 4);
            this.count = 4;
        }
    }
}

