/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.jboss.cache.CacheException;
import org.jboss.cache.marshall.MarshalledValue;

@Immutable
public class MarshalledValueMap
implements Map,
Externalizable {
    Map delegate;
    Map<Object, Object> unmarshalled;

    public MarshalledValueMap() {
    }

    public MarshalledValueMap(Map delegate) {
        this.delegate = delegate;
    }

    protected synchronized Map getUnmarshalledMap() {
        if (this.unmarshalled == null) {
            this.unmarshalled = this.unmarshalledMap(this.delegate.entrySet());
        }
        return this.unmarshalled;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.getUnmarshalledMap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getUnmarshalledMap().containsValue(value);
    }

    public Object get(Object key) {
        return this.getUnmarshalledMap().get(key);
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("This is an immutable map!");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("This is an immutable map!");
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("This is an immutable map!");
    }

    public void clear() {
        throw new UnsupportedOperationException("This is an immutable map!");
    }

    public Set keySet() {
        return this.getUnmarshalledMap().keySet();
    }

    public Collection values() {
        return this.getUnmarshalledMap().values();
    }

    public Set entrySet() {
        return this.getUnmarshalledMap().entrySet();
    }

    protected Map unmarshalledMap(Set entries) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(entries.size());
        for (Object e : entries) {
            Map.Entry entry = (Map.Entry)e;
            map.put(this.getUnmarshalledValue(entry.getKey()), this.getUnmarshalledValue(entry.getValue()));
        }
        return map;
    }

    private Object getUnmarshalledValue(Object o) {
        try {
            return o instanceof MarshalledValue ? ((MarshalledValue)o).get() : o;
        }
        catch (Exception e) {
            throw new CacheException("Unable to unmarshall value", e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Map) {
            return ((Object)this.getUnmarshalledMap()).equals(other);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.getUnmarshalledMap()).hashCode();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (Map)in.readObject();
    }
}

