/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.RegionalizedMethodCall;
import org.jboss.cache.marshall.RegionalizedReturnValue;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RpcDispatcher;

public class InactiveRegionAwareRpcDispatcher
extends RpcDispatcher {
    Marshaller requestMarshaller;

    public InactiveRegionAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2, server_obj);
    }

    public void setRequestMarshaller(RpcDispatcher.Marshaller m) {
        super.setRequestMarshaller(m);
        this.requestMarshaller = (Marshaller)m;
    }

    public Object handle(Message req) {
        MethodCall method_call;
        RegionalizedMethodCall rmc;
        if (this.server_obj == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"no method handler is registered. Discarding request.");
            }
            return null;
        }
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message or message buffer is null");
            }
            return null;
        }
        try {
            rmc = this.requestMarshaller.regionalizedMethodCallFromByteBuffer(req.getBuffer());
            method_call = rmc.call;
        }
        catch (Throwable e) {
            if (e instanceof InactiveRegionException) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Exception from marshaller: " + e.getMessage()));
                }
                return null;
            }
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"exception unmarshalling object", e);
            }
            return e;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[sender=" + req.getSrc() + "], method_call: " + (Object)((Object)method_call)));
            }
            Object retVal = method_call.invoke(this.server_obj);
            return new RegionalizedReturnValue(retVal, rmc);
        }
        catch (Throwable x) {
            return x;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Outgoing marshaller: " + this.req_marshaller + "; incoming marshaller: " + this.rsp_marshaller + "]";
    }
}

