/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocation;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.Version;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.invocation.AbstractInvocationDelegate;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheInvocationDelegate<K, V>
extends AbstractInvocationDelegate
implements CacheSPI<K, V> {
    private StateTransferManager stateTransferManager;
    private CacheLoaderManager cacheLoaderManager;
    private Notifier notifier;
    private TransactionManager transactionManager;
    private BuddyManager buddyManager;
    private TransactionTable transactionTable;
    private RPCManager rpcManager;
    private RegionManager regionManager;
    private Marshaller marshaller;

    public CacheInvocationDelegate() {
        this.log = LogFactory.getLog(CacheInvocationDelegate.class);
    }

    @Inject
    private void injectDependencies(StateTransferManager stateTransferManager, CacheLoaderManager cacheLoaderManager, Notifier notifier, TransactionManager transactionManager, BuddyManager buddyManager, TransactionTable transactionTable, RPCManager rpcManager, RegionManager regionManager, Marshaller marshaller) {
        this.stateTransferManager = stateTransferManager;
        this.cacheLoaderManager = cacheLoaderManager;
        this.notifier = notifier;
        this.transactionManager = transactionManager;
        this.buddyManager = buddyManager;
        this.transactionTable = transactionTable;
        this.rpcManager = rpcManager;
        this.regionManager = regionManager;
        this.marshaller = marshaller;
    }

    private void reset() {
        this.stateTransferManager = null;
        this.cacheLoaderManager = null;
        this.transactionManager = null;
        this.buddyManager = null;
        this.transactionTable = null;
        this.rpcManager = null;
        this.marshaller = null;
    }

    public String toString() {
        return this.cache == null ? super.toString() : this.cache.toString();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public NodeSPI<K, V> getRoot() {
        return this.cache.getRoot();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public List<Interceptor> getInterceptorChain() {
        List<Interceptor> interceptors = InterceptorChainFactory.asList(this.interceptorChain);
        return interceptors == null ? Collections.emptyList() : Collections.unmodifiableList(interceptors);
    }

    @Override
    public void addInterceptor(Interceptor i, int position) {
        this.cache.addInterceptor(i, position);
    }

    @Override
    public void addInterceptor(Interceptor i, Class<? extends Interceptor> afterInterceptor) {
        this.cache.addInterceptor(i, afterInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.cache.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends Interceptor> interceptorType) {
        this.cache.removeInterceptor(interceptorType);
    }

    @Override
    public CacheLoaderManager getCacheLoaderManager() {
        return this.cacheLoaderManager;
    }

    @Override
    public BuddyManager getBuddyManager() {
        return this.buddyManager;
    }

    @Override
    public TransactionTable getTransactionTable() {
        return this.transactionTable;
    }

    @Override
    public RPCManager getRPCManager() {
        return this.rpcManager;
    }

    @Override
    public StateTransferManager getStateTransferManager() {
        return this.stateTransferManager;
    }

    @Override
    public String getClusterName() {
        return this.cache.getClusterName();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.cache.getNumberOfAttributes();
    }

    @Override
    public int getNumberOfNodes() {
        return this.cache.getNumberOfNodes();
    }

    @Override
    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    @Override
    public GlobalTransaction getCurrentTransaction(Transaction tx, boolean createIfNotExists) {
        return this.cache.getCurrentTransaction(tx, createIfNotExists);
    }

    @Override
    public GlobalTransaction getCurrentTransaction() {
        return this.cache.getCurrentTransaction();
    }

    @Override
    public Set<Fqn> getInternalFqns() {
        return this.cache.getInternalFqns();
    }

    @Override
    public int getNumberOfLocksHeld() {
        return this.cache.getNumberOfLocksHeld();
    }

    @Override
    public boolean exists(String fqn) {
        return this.exists(Fqn.fromString(fqn));
    }

    @Override
    public boolean exists(Fqn<?> fqn) {
        return this.peek((Fqn)fqn, false, false) != null;
    }

    @Override
    public Notifier getNotifier() {
        return this.notifier;
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public GravitateResult gravitateData(Fqn fqn, boolean searchBuddyBackupSubtrees) {
        return this.cache.gravitateData(fqn, searchBuddyBackupSubtrees);
    }

    @Override
    public NodeSPI<K, V> peek(Fqn fqn, boolean includeDeletedNodes, boolean includeInvalidNodes) {
        return this.cache.peek(fqn, includeDeletedNodes, includeInvalidNodes);
    }

    @Override
    public NodeSPI<K, V> peek(Fqn fqn, boolean includeDeletedNodes) {
        return this.cache.peek(fqn, includeDeletedNodes);
    }

    @Override
    public void addCacheListener(Object listener) {
        this.notifier.addCacheListener(listener);
    }

    @Override
    public void removeCacheListener(Object listener) {
        this.notifier.removeCacheListener(listener);
    }

    @Override
    public Set<Object> getCacheListeners() {
        return this.notifier.getCacheListeners();
    }

    @Override
    public void create() throws CacheException {
        this.cache.create();
    }

    @Override
    public void start() throws CacheException {
        this.cache.start();
    }

    @Override
    public void stop() {
        this.cache.stop();
    }

    @Override
    public void destroy() {
        this.reset();
        this.cache.destroy();
    }

    @Override
    public CacheStatus getCacheStatus() {
        return this.cache == null ? null : this.cache.getCacheStatus();
    }

    @Override
    public InvocationContext getInvocationContext() {
        this.assertIsConstructed();
        return (InvocationContext)this.invocationContextContainer.get();
    }

    @Override
    public void setInvocationContext(InvocationContext ctx) {
        this.assertIsConstructed();
        if (ctx == null) {
            this.invocationContextContainer.remove();
        } else {
            this.invocationContextContainer.set(ctx);
        }
    }

    @Override
    public Address getLocalAddress() {
        if (this.rpcManager == null) {
            return null;
        }
        return this.rpcManager.getLocalAddress();
    }

    @Override
    public List<Address> getMembers() {
        if (this.rpcManager == null) {
            return null;
        }
        return this.rpcManager.getMembers();
    }

    @Override
    public String getVersion() {
        return Version.printVersion();
    }

    @Override
    public void move(Fqn<?> nodeToMove, Fqn<?> newParent) throws NodeNotExistsException {
        MethodCall m = MethodCallFactory.create(36, nodeToMove, newParent);
        this.invoke(m);
    }

    @Override
    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.move(Fqn.fromString(nodeToMove), Fqn.fromString(newParent));
    }

    @Override
    public boolean removeRegion(Fqn fqn) {
        return this.regionManager.removeRegion(fqn);
    }

    @Override
    public Region getRegion(Fqn fqn, boolean createIfAbsent) {
        return this.regionManager.getRegion(fqn, createIfAbsent);
    }

    @Override
    public void evict(Fqn<?> fqn, boolean recursive) {
        if (!this.getCacheStatus().allowInvocations()) {
            throw new IllegalStateException("Cache is not in STARTED state");
        }
        NodeSPI<K, V> node = this.peek((Fqn)fqn, false);
        if (node != null && node.isResident()) {
            return;
        }
        if (recursive) {
            if (node != null) {
                this.evictChildren(node);
            }
        } else {
            this.evict(fqn);
        }
    }

    private void evictChildren(NodeSPI<K, V> n) {
        for (NodeSPI<K, V> child : n.getChildrenDirect()) {
            this.evictChildren(child);
        }
        this.evict(n.getFqn());
    }

    @Override
    public void evict(Fqn<?> fqn) {
        NodeSPI<K, V> node = this.peek((Fqn)fqn, false);
        if (node != null && node.isResident()) {
            return;
        }
        if (fqn.isRoot()) {
            InvocationContext ctx = this.getInvocationContext();
            Option o = ctx.getOptionOverrides();
            for (Object childName : this.cache.peek(fqn, false, false).getChildrenNames()) {
                ctx.setOptionOverrides(o);
                this.evict(new Fqn<Object>(new Object[]{fqn, childName}));
            }
        } else {
            MethodCall m = MethodCallFactory.create(8, fqn);
            this.invoke(m);
        }
    }

    @Override
    public V get(Fqn<?> fqn, K key) {
        MethodCall m = MethodCallFactory.create(26, fqn, key, true);
        return (V)this.invoke(m);
    }

    @Override
    public V get(String fqn, K key) {
        return this.get(Fqn.fromString(fqn), key);
    }

    @Override
    public boolean removeNode(Fqn<?> fqn) {
        GlobalTransaction tx = this.cache.getCurrentTransaction();
        if (fqn.isRoot()) {
            boolean result = true;
            InvocationContext ctx = this.getInvocationContext();
            Option o = ctx.getOptionOverrides();
            Set<Fqn> internalFqns = this.getInternalFqns();
            for (Object childName : this.peek((Fqn)fqn, false, false).getChildrenNames()) {
                if (internalFqns.contains(new Fqn<Object>(childName))) continue;
                ctx.setOptionOverrides(o);
                result = this.removeNode(new Fqn<Object>(fqn, childName)) && result;
            }
            return result;
        }
        MethodCall m = MethodCallFactory.create(5, tx, fqn, true, false);
        Object retval = this.invoke(m);
        return retval != null && (Boolean)retval != false;
    }

    @Override
    public boolean removeNode(String fqn) {
        return this.removeNode(Fqn.fromString(fqn));
    }

    @Override
    public NodeSPI<K, V> getNode(Fqn<?> fqn) {
        MethodCall m = MethodCallFactory.create(31, fqn);
        return (NodeSPI)this.invoke(m);
    }

    @Override
    public NodeSPI<K, V> getNode(String fqn) {
        return this.getNode((Fqn)Fqn.fromString(fqn));
    }

    @Override
    public V remove(Fqn<?> fqn, K key) throws CacheException {
        GlobalTransaction tx = this.cache.getCurrentTransaction();
        MethodCall m = MethodCallFactory.create(6, tx, fqn, key, true);
        return (V)this.invoke(m);
    }

    @Override
    public V remove(String fqn, K key) {
        return this.remove(Fqn.fromString(fqn), key);
    }

    @Override
    public void put(Fqn<?> fqn, Map<K, V> data) {
        GlobalTransaction tx = this.cache.getCurrentTransaction();
        MethodCall m = MethodCallFactory.create(1, tx, fqn, data, true);
        this.invoke(m);
    }

    @Override
    public void put(String fqn, Map<K, V> data) {
        this.put(Fqn.fromString(fqn), data);
    }

    @Override
    public void putForExternalRead(Fqn<?> fqn, K key, V value) {
        if (this.peek((Fqn)fqn, false, false) == null) {
            this.getInvocationContext().getOptionOverrides().setFailSilently(true);
            this.getInvocationContext().getOptionOverrides().setForceAsynchronous(true);
            MethodCall m = MethodCallFactory.create(45, null, fqn, key, value);
            this.invoke(m);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putForExternalRead() called with Fqn " + fqn + " and this node already exists.  This method is hence a no op."));
        }
    }

    @Override
    public V put(Fqn<?> fqn, K key, V value) {
        GlobalTransaction tx = this.cache.getCurrentTransaction();
        MethodCall m = MethodCallFactory.create(3, tx, fqn, key, value, true);
        return (V)this.invoke(m);
    }

    @Override
    public V put(String fqn, K key, V value) {
        return this.put(Fqn.fromString(fqn), key, value);
    }

    @Override
    public Set<Object> getCacheListeners(Fqn region) {
        throw new UnsupportedOperationException("Not implemented in this release");
    }

    @Override
    public void removeCacheListener(Fqn region, Object listener) {
        throw new UnsupportedOperationException("Not implemented in this release");
    }

    @Override
    public void addCacheListener(Fqn region, Object listener) {
        throw new UnsupportedOperationException("Not implemented in this release");
    }

    @Override
    public Map<K, V> getData(Fqn<?> fqn) {
        MethodCall m = MethodCallFactory.create(24, fqn);
        return (Map)this.invoke(m);
    }

    @Override
    public Set getKeys(String fqn) {
        return this.getKeys(Fqn.fromString(fqn));
    }

    @Override
    public Set<K> getKeys(Fqn<?> fqn) {
        MethodCall m = MethodCallFactory.create(25, fqn);
        return (Set)this.invoke(m);
    }

    @Override
    public void clearData(String fqn) throws CacheException {
        this.clearData((Fqn)Fqn.fromString(fqn));
    }

    @Override
    public void clearData(Fqn fqn) {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = MethodCallFactory.create(7, tx, fqn, true);
        this.invoke(m);
    }

    @Override
    public <E> Set<E> getChildrenNames(Fqn<E> fqn) {
        MethodCall m = MethodCallFactory.create(23, fqn);
        Set retval = null;
        retval = (Set)this.invoke(m);
        retval = retval != null ? Collections.unmodifiableSet(new HashSet(retval)) : Collections.emptySet();
        return retval;
    }

    @Override
    public Set getChildrenNames(String fqn) {
        return this.getChildrenNames(Fqn.fromString(fqn));
    }

    public CacheImpl getDelegationTarget() {
        return this.cache;
    }
}

