/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.MethodDispacherInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptorMBean;
import org.jboss.cache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassivationInterceptor
extends MethodDispacherInterceptor
implements PassivationInterceptorMBean {
    protected CacheLoader loader = null;
    private AtomicLong m_passivations = new AtomicLong(0L);

    public PassivationInterceptor() {
        this.initLogger();
    }

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoaderManager().getCacheLoader();
    }

    @Override
    protected Object handleEvictMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        block3: {
            try {
                Map attributes = this.getNodeAttributes(ctx, fqn);
                this.cache.getNotifier().notifyNodePassivated(fqn, true, attributes, ctx);
                this.loader.put(fqn, attributes);
                this.cache.getNotifier().notifyNodePassivated(fqn, false, Collections.emptyMap(), ctx);
                if (this.getStatisticsEnabled() && this.configuration.getExposeManagementStatistics()) {
                    this.m_passivations.getAndIncrement();
                }
            }
            catch (NodeNotLoadedException e) {
                if (!this.trace) break block3;
                this.log.trace((Object)("Node " + fqn + " not loaded in memory; passivation skipped"));
            }
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    public long getPassivations() {
        return this.m_passivations.get();
    }

    @Override
    public void resetStatistics() {
        this.m_passivations.set(0L);
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Passivations", this.m_passivations.get());
        return retval;
    }

    private Map getNodeAttributes(InvocationContext ctx, Fqn fqn) throws NodeNotLoadedException {
        if (fqn == null) {
            throw new NodeNotLoadedException();
        }
        NodeSPI n = this.peekNode(ctx, fqn, false, true, false);
        if (n != null) {
            return n.getDataDirect();
        }
        throw new NodeNotLoadedException();
    }

    private static class NodeNotLoadedException
    extends Exception {
        private static final long serialVersionUID = -4078972305344328905L;

        private NodeNotLoadedException() {
        }
    }
}

