/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

public class OptimisticCreateIfNotExistsInterceptor
extends OptimisticInterceptor {
    private NodeFactory nodeFactory;
    private long lockAcquisitionTimeout;

    public OptimisticCreateIfNotExistsInterceptor() {
        this.initLogger();
    }

    @Inject
    private void injectDependencies(NodeFactory nodeFactory, Configuration cfg) {
        this.nodeFactory = nodeFactory;
        this.lockAcquisitionTimeout = cfg.getLockAcquisitionTimeout();
    }

    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutDataEraseVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Map data, boolean createUndoOps, boolean eraseContent, DataVersion dv) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutDataVersionedMethod(InvocationContext ctx, GlobalTransaction globalTransaction, Fqn fqn, Map map, Boolean createUndoOps, DataVersion dataVersion) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutKeyValueVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps, DataVersion dv) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutForExternalReadVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, DataVersion dv) throws Throwable {
        this.createNode(ctx, fqn, false);
        return this.nextInterceptor(ctx);
    }

    protected Object handleMoveMethod(InvocationContext ctx, Fqn from, Fqn to) throws Throwable {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(to);
        NodeSPI node = this.peekNode(ctx, from, false, true, true);
        this.greedyGetFqns(fqns, node, to);
        if (this.trace) {
            this.log.trace((Object)("Adding Fqns " + fqns + " for a move() operation."));
        }
        for (Fqn f : fqns) {
            this.createNode(ctx, f, true);
        }
        return this.nextInterceptor(ctx);
    }

    private void createNode(InvocationContext ctx, Fqn targetFqn, boolean suppressNotification) throws CacheException {
        if (this.peekNode(ctx, targetFqn, false, false, false) != null) {
            return;
        }
        if (targetFqn == null) {
            return;
        }
        boolean debug = this.log.isDebugEnabled();
        GlobalTransaction gtx = this.getGlobalTransaction(ctx);
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        ArrayList<Fqn> nodesCreated = new ArrayList<Fqn>();
        DataVersion version = null;
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
            version = ctx.getOptionOverrides().getDataVersion();
            workspace.setVersioningImplicit(false);
        }
        WorkspaceNode workspaceNode = workspace.getNode(Fqn.ROOT);
        if (debug) {
            this.log.debug((Object)("GlobalTransaction: " + gtx + "; Root: " + workspaceNode));
        }
        if (workspaceNode == null) {
            NodeSPI node = this.cache.getRoot();
            workspaceNode = this.lockAndCreateWorkspaceNode(this.nodeFactory, node, workspace, gtx, this.lockAcquisitionTimeout);
            workspace.addNode(workspaceNode);
            this.log.debug((Object)"Created root node in workspace.");
        } else {
            this.log.debug((Object)"Found root node in workspace.");
        }
        int targetFqnSize = targetFqn.size();
        int currentDepth = 1;
        for (Object childName : targetFqn.peekElements()) {
            WorkspaceNode peekInWorkspace;
            NodeSPI currentNode;
            boolean isTargetFqn = currentDepth == targetFqnSize;
            ++currentDepth;
            if (debug) {
                this.log.debug((Object)("Attempting to get child " + childName));
            }
            if ((currentNode = workspaceNode.getNode().getChildDirect(childName)) == null && (peekInWorkspace = workspace.getNode(new Fqn<Object>(workspaceNode.getFqn(), childName))) != null && peekInWorkspace.isCreated()) {
                currentNode = peekInWorkspace.getNode();
                if (peekInWorkspace.isDeleted()) {
                    this.undeleteWorkspaceNode(peekInWorkspace, workspaceNode);
                }
            }
            if (currentNode == null) {
                if (this.trace) {
                    this.log.trace((Object)"Creating new child, since it doesn't exist in the cache.");
                }
                if (workspaceNode.isDeleted()) {
                    if (this.trace) {
                        this.log.trace((Object)"Parent node doesn't exist in workspace or has been deleted.  Adding to workspace.");
                    }
                    workspace.addNode(workspaceNode);
                    if (!(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
                        workspaceNode.setVersioningImplicit(false);
                    }
                } else if (this.trace) {
                    this.log.trace((Object)("Parent node exists: " + workspaceNode));
                }
                DataVersion versionToPassIn = null;
                if (isTargetFqn && !workspace.isVersioningImplicit()) {
                    versionToPassIn = version;
                }
                NodeSPI newUnderlyingChildNode = workspaceNode.createChild(childName, workspaceNode.getNode(), this.cache, versionToPassIn);
                workspaceNode = this.lockAndCreateWorkspaceNode(this.nodeFactory, newUnderlyingChildNode, workspace, gtx, this.lockAcquisitionTimeout);
                workspaceNode.setVersioningImplicit(versionToPassIn == null || !isTargetFqn);
                if (this.trace) {
                    this.log.trace((Object)("setting versioning of " + workspaceNode.getFqn() + " to be " + (workspaceNode.isVersioningImplicit() ? "implicit" : "explicit")));
                }
                workspace.addNode(workspaceNode);
                workspaceNode.markAsCreated();
                nodesCreated.add(workspaceNode.getFqn());
                continue;
            }
            workspaceNode = workspace.getNode(currentNode.getFqn());
            if (workspaceNode == null) {
                if (this.trace) {
                    this.log.trace((Object)("Child node " + currentNode.getFqn() + " doesn't exist in workspace or has been deleted.  Adding to workspace in gtx " + gtx));
                }
                workspaceNode = this.lockAndCreateWorkspaceNode(this.nodeFactory, currentNode, workspace, gtx, this.lockAcquisitionTimeout);
                if (!currentNode.isValid()) {
                    workspaceNode.markAsCreated();
                }
                if (isTargetFqn && !workspace.isVersioningImplicit()) {
                    workspaceNode.setVersion(version);
                    workspaceNode.setVersioningImplicit(false);
                } else {
                    workspaceNode.setVersioningImplicit(true);
                }
                if (this.trace) {
                    this.log.trace((Object)("setting versioning of " + workspaceNode.getFqn() + " to be " + (workspaceNode.isVersioningImplicit() ? "implicit" : "explicit")));
                }
                workspace.addNode(workspaceNode);
                continue;
            }
            if (workspaceNode.isDeleted()) {
                if (this.trace) {
                    this.log.trace((Object)"Found node but it is deleted in this workspace.  Needs resurrecting.");
                }
                this.undeleteWorkspaceNode(workspaceNode, workspace);
                continue;
            }
            if (!this.trace) continue;
            this.log.trace((Object)("Found child node in the workspace: " + currentNode));
        }
        if (!suppressNotification && nodesCreated.size() > 0) {
            Notifier n = this.cache.getNotifier();
            for (Fqn temp : nodesCreated) {
                n.notifyNodeCreated(temp, true, ctx);
                n.notifyNodeCreated(temp, false, ctx);
                if (!this.trace) continue;
                this.log.trace((Object)("Notifying cache of node created in workspace " + temp));
            }
        }
    }
}

