/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;

public class NotificationInterceptor
extends BaseTransactionalContextInterceptor {
    public NotificationInterceptor() {
        this.initLogger();
    }

    protected Object handleBlockChannelMethod(InvocationContext ctx) throws Throwable {
        this.cache.getNotifier().notifyCacheBlocked(this.cache, true);
        Object retVal = this.nextInterceptor(ctx);
        this.cache.getNotifier().notifyCacheBlocked(this.cache, false);
        return retVal;
    }

    protected Object handleUnblockChannelMethod(InvocationContext ctx) throws Throwable {
        this.cache.getNotifier().notifyCacheUnblocked(this.cache, true);
        Object retval = this.nextInterceptor(ctx);
        this.cache.getNotifier().notifyCacheUnblocked(this.cache, false);
        return retval;
    }

    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        this.cache.getNotifier().notifyTransactionCompleted(ctx.getTransaction(), true, ctx);
        return retval;
    }

    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        this.cache.getNotifier().notifyTransactionCompleted(ctx.getTransaction(), false, ctx);
        return retval;
    }
}

