/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.util.BitEncodedIntegerSet;
import org.jgroups.Address;

public abstract class MethodDispacherInterceptor
extends Interceptor {
    private BitEncodedIntegerSet overriddenMethods = new BitEncodedIntegerSet();

    protected MethodDispacherInterceptor() {
        this.findOverriddenMethods();
    }

    public Object invoke(InvocationContext ctx) throws Throwable {
        Object result;
        MethodCall m;
        if (this.trace) {
            this.log.trace((Object)("Invoked with method call " + (Object)((Object)ctx.getMethodCall())));
        }
        if (!this.overriddenMethods.contains((m = ctx.getMethodCall()).getMethodId()) || this.skipMethodCall(ctx)) {
            if (this.trace) {
                this.log.trace((Object)"Not registered for any handlers, or instructed to skip call.  Passing up the chain.");
            }
            return this.nextInterceptor(ctx);
        }
        Object[] args = m.getArgs();
        switch (m.getMethodId()) {
            case 2: {
                result = this.handlePutDataEraseMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Map)args[2], (Boolean)args[3], (Boolean)args[4]);
                break;
            }
            case 1: {
                result = this.handlePutDataMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Map)args[2], (Boolean)args[3]);
                break;
            }
            case 45: {
                result = this.handlePutForExternalReadMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], args[2], args[3]);
                break;
            }
            case 3: {
                result = this.handlePutKeyValueMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], args[2], args[3], (Boolean)args[4]);
                break;
            }
            case 36: {
                result = this.handleMoveMethod(ctx, (Fqn)args[0], (Fqn)args[1]);
                break;
            }
            case 15: {
                result = this.handleAddChildMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], args[2], (Node)args[3], (Boolean)args[4]);
                break;
            }
            case 26: {
                result = this.handleGetKeyValueMethod(ctx, (Fqn)args[0], args[1], (Boolean)args[2]);
                break;
            }
            case 31: {
                result = this.handleGetNodeMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 23: {
                result = this.handleGetChildrenNamesMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 17: {
                result = this.handleReleaseAllLocksMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 32: {
                result = this.handlePrintMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 25: {
                result = this.handleGetKeysMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 24: {
                result = this.handleGetDataMapMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 12: {
                result = this.handleRollbackMethod(ctx, (GlobalTransaction)args[0]);
                break;
            }
            case 5: {
                result = this.handleRemoveNodeMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Boolean)args[2]);
                break;
            }
            case 6: {
                result = this.handleRemoveKeyMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], args[2], (Boolean)args[3]);
                break;
            }
            case 7: {
                result = this.handleRemoveDataMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Boolean)args[2]);
                break;
            }
            case 11: {
                result = this.handleCommitMethod(ctx, (GlobalTransaction)args[0]);
                break;
            }
            case 18: {
                result = this.handleOptimisticPrepareMethod(ctx, (GlobalTransaction)args[0], (List)args[1], (Map)args[2], (Address)args[3], (Boolean)args[4]);
                break;
            }
            case 10: {
                result = this.handlePrepareMethod(ctx, (GlobalTransaction)args[0], (List)args[1], (Address)args[2], (Boolean)args[3]);
                break;
            }
            case 8: {
                result = this.handleEvictMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 9: {
                result = this.handleEvictVersionedNodeMethod(ctx, (Fqn)args[0], (DataVersion)args[1]);
                break;
            }
            case 16: {
                result = this.handleExistsMethod(ctx, (Fqn)args[0]);
                break;
            }
            case 38: {
                result = this.handlePutDataEraseVersionedMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Map)args[2], (Boolean)args[3], (Boolean)args[4], (DataVersion)args[5]);
                break;
            }
            case 37: {
                result = this.handlePutDataVersionedMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Map)args[2], (Boolean)args[3], (DataVersion)args[4]);
                break;
            }
            case 39: {
                result = this.handlePutKeyValueVersionedMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], args[2], args[3], (Boolean)args[4], (DataVersion)args[5]);
                break;
            }
            case 46: {
                result = this.handlePutForExternalReadVersionedMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], args[2], args[3], (DataVersion)args[5]);
                break;
            }
            case 34: {
                result = this.handleDataGravitationCleanupMethod(ctx, (Fqn)args[0], (Fqn)args[1]);
                break;
            }
            case 40: {
                result = this.handleRemoveNodeVersionedMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Boolean)args[2], (DataVersion)args[3]);
                break;
            }
            case 41: {
                result = this.handleRemoveKeyVersionedMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], args[2], (Boolean)args[3], (DataVersion)args[4]);
                break;
            }
            case 42: {
                result = this.handleRemoveDataVersionedMethod(ctx, (GlobalTransaction)args[0], (Fqn)args[1], (Boolean)args[2], (DataVersion)args[3]);
                break;
            }
            case 43: {
                result = this.handleBlockChannelMethod(ctx);
                break;
            }
            case 44: {
                result = this.handleUnblockChannelMethod(ctx);
                break;
            }
            case 33: {
                result = this.handleLockMethod(ctx, (Fqn)args[0], (NodeLock.LockType)((Object)args[1]), (Boolean)args[2]);
                break;
            }
            default: {
                return this.nextInterceptor(ctx);
            }
        }
        return result;
    }

    protected Object handleLockMethod(InvocationContext ctx, Fqn fqn, NodeLock.LockType lockType, boolean recursive) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleUnblockChannelMethod(InvocationContext ctx) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleBlockChannelMethod(InvocationContext ctx) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleRemoveDataVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleRemoveKeyVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleRemoveNodeVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleDataGravitationCleanupMethod(InvocationContext ctx, Fqn primary, Fqn backup) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutForExternalReadVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, DataVersion dv) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutKeyValueVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutDataVersionedMethod(InvocationContext ctx, GlobalTransaction globalTransaction, Fqn fqn, Map map, Boolean createUndoOps, DataVersion dataVersion) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutDataEraseVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Map data, boolean createUndoOps, boolean eraseContent, DataVersion dv) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleExistsMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected boolean skipMethodCall(InvocationContext ctx) {
        return false;
    }

    protected Object handleEvictVersionedNodeMethod(InvocationContext ctx, Fqn fqn, DataVersion dataVersion) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleEvictMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modification, Address coordinator, boolean onePhaseCommit) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleGetDataMapMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleGetKeysMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePrintMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleReleaseAllLocksMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleGetChildrenNamesMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleGetNodeMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleGetKeyValueMethod(InvocationContext ctx, Fqn fqn, Object key, boolean sendNodeEvent) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleAddChildMethod(InvocationContext ctx, GlobalTransaction tx, Fqn parentFqn, Object childName, Node cn, boolean createUndoOps) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handleMoveMethod(InvocationContext ctx, Fqn from, Fqn to) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        return this.defaultHandlersBehavior();
    }

    private Object defaultHandlersBehavior() {
        throw new IllegalStateException("this is either called from a derived class or not overridden and accidentally called. Either way, is not correct.");
    }

    private void findOverriddenMethods() {
        this.checkIfOverridden(2, "handlePutDataEraseMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, Boolean.TYPE);
        this.checkIfOverridden(1, "handlePutDataMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE);
        this.checkIfOverridden(45, "handlePutForExternalReadMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Object.class, Object.class);
        this.checkIfOverridden(3, "handlePutKeyValueMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Object.class, Object.class, Boolean.TYPE);
        this.checkIfOverridden(36, "handleMoveMethod", InvocationContext.class, Fqn.class, Fqn.class);
        this.checkIfOverridden(15, "handleAddChildMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Object.class, Node.class, Boolean.TYPE);
        this.checkIfOverridden(26, "handleGetKeyValueMethod", InvocationContext.class, Fqn.class, Object.class, Boolean.TYPE);
        this.checkIfOverridden(31, "handleGetNodeMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(23, "handleGetChildrenNamesMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(17, "handleReleaseAllLocksMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(32, "handlePrintMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(25, "handleGetKeysMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(24, "handleGetDataMapMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(12, "handleRollbackMethod", InvocationContext.class, GlobalTransaction.class);
        this.checkIfOverridden(5, "handleRemoveNodeMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Boolean.TYPE);
        this.checkIfOverridden(6, "handleRemoveKeyMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Object.class, Boolean.TYPE);
        this.checkIfOverridden(7, "handleRemoveDataMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Boolean.TYPE);
        this.checkIfOverridden(11, "handleCommitMethod", InvocationContext.class, GlobalTransaction.class);
        this.checkIfOverridden(18, "handleOptimisticPrepareMethod", InvocationContext.class, GlobalTransaction.class, List.class, Map.class, Address.class, Boolean.TYPE);
        this.checkIfOverridden(10, "handlePrepareMethod", InvocationContext.class, GlobalTransaction.class, List.class, Address.class, Boolean.TYPE);
        this.checkIfOverridden(8, "handleEvictMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(9, "handleEvictVersionedNodeMethod", InvocationContext.class, Fqn.class, DataVersion.class);
        this.checkIfOverridden(16, "handleExistsMethod", InvocationContext.class, Fqn.class);
        this.checkIfOverridden(38, "handlePutDataEraseVersionedMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, Boolean.TYPE, DataVersion.class);
        this.checkIfOverridden(37, "handlePutDataVersionedMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Map.class, Boolean.class, DataVersion.class);
        this.checkIfOverridden(39, "handlePutKeyValueVersionedMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Object.class, Object.class, Boolean.TYPE, DataVersion.class);
        this.checkIfOverridden(46, "handlePutForExternalReadVersionedMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Object.class, Object.class, DataVersion.class);
        this.checkIfOverridden(34, "handleDataGravitationCleanupMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Fqn.class);
        this.checkIfOverridden(40, "handleRemoveNodeVersionedMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Boolean.TYPE, DataVersion.class);
        this.checkIfOverridden(41, "handleRemoveKeyVersionedMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Object.class, Boolean.TYPE, DataVersion.class);
        this.checkIfOverridden(42, "handleRemoveDataVersionedMethod", InvocationContext.class, GlobalTransaction.class, Fqn.class, Boolean.TYPE, DataVersion.class);
        this.checkIfOverridden(43, "handleBlockChannelMethod", InvocationContext.class);
        this.checkIfOverridden(44, "handleUnblockChannelMethod", InvocationContext.class);
        this.checkIfOverridden(33, "handleLockMethod", InvocationContext.class, Fqn.class, NodeLock.LockType.class, Boolean.TYPE);
    }

    private void checkIfOverridden(int methodId, String methodName, Class ... args) {
        for (Class currentClass = this.getClass(); currentClass != MethodDispacherInterceptor.class; currentClass = (Class)currentClass.getGenericSuperclass()) {
            try {
                currentClass.getDeclaredMethod(methodName, args);
                this.overriddenMethods.add(methodId);
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }
}

