/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.InterceptorMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Interceptor
implements InterceptorMBean {
    protected Interceptor next = null;
    protected Interceptor last = null;
    protected CacheSPI<?, ?> cache;
    protected Log log = null;
    protected Configuration configuration;
    private boolean statsEnabled = false;
    protected boolean trace;

    public Interceptor() {
        this.initLogger();
    }

    protected void initLogger() {
        this.log = LogFactory.getLog(this.getClass());
        this.trace = this.log.isTraceEnabled();
    }

    public void setNext(Interceptor i) {
        this.next = i;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setCache(CacheSPI cache) {
    }

    @Start
    private void start() {
        this.setStatisticsEnabled(this.configuration.getExposeManagementStatistics());
        this.setCache(this.cache);
    }

    @Inject
    private void injectDependencies(CacheSPI cache, Configuration configuration) {
        this.configuration = configuration;
        this.cache = cache;
    }

    public Object invoke(InvocationContext ctx) throws Throwable {
        return this.next.invoke(ctx);
    }

    public Object nextInterceptor(InvocationContext ctx) throws Throwable {
        return this.next.invoke(ctx);
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    public Interceptor getLast() {
        return this.last;
    }

    public void setLast(Interceptor last) {
        this.last = last;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        return Collections.emptyMap();
    }

    @Override
    public void resetStatistics() {
    }

    protected boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 0;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    protected boolean isPreparing(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 7;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    protected boolean isValid(Transaction tx) {
        return this.isActive(tx) || this.isPreparing(tx);
    }

    protected void assertTransactionValid(InvocationContext ctx) {
        Transaction tx = ctx.getTransaction();
        if (!this.isValid(tx)) {
            try {
                throw new CacheException("Invalid transaction " + tx + ", status = " + (tx == null ? null : Integer.valueOf(tx.getStatus())));
            }
            catch (SystemException e) {
                throw new CacheException("Exception trying to analyse status of transaction " + tx, e);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "{next: " + (this.getNext() == null ? null : this.getNext().getClass()) + "; last: " + (this.getLast() == null ? null : this.getLast().getClass()) + "}";
    }

    public NodeSPI peekNode(InvocationContext ctx, Fqn f, boolean forceRefresh, boolean includeDeletedNodes, boolean includeInvalidNodes) {
        return this.cache.peek(f, includeDeletedNodes, includeInvalidNodes);
    }
}

