/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.MethodDispacherInterceptor;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class EvictionInterceptor
extends MethodDispacherInterceptor {
    protected RegionManager regionManager;

    @Inject
    void setRegionManager(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public EvictionInterceptor() {
        this.initLogger();
    }

    protected Object handleEvictVersionedNodeMethod(InvocationContext ctx, Fqn fqn, DataVersion dataVersion) throws Throwable {
        return this.handleEvictMethod(ctx, fqn);
    }

    protected Object handleEvictMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        boolean complete;
        Object retVal = this.nextInterceptor(ctx);
        boolean bl = complete = retVal != null && (Boolean)retVal != false;
        if (!complete && fqn != null && !this.canIgnoreEvent(fqn, NodeEventType.ADD_NODE_EVENT)) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, 0), ctx);
        }
        return retVal;
    }

    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        return this.handlePutForExternalReadMethod(ctx, gtx, fqn, key, value);
    }

    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        Object retVal = this.nextInterceptor(ctx);
        if (fqn != null && key != null && !this.canIgnoreEvent(fqn, NodeEventType.ADD_ELEMENT_EVENT)) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.ADD_ELEMENT_EVENT, 1), ctx);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        Object retVal = this.nextInterceptor(ctx);
        if (fqn != null && !this.canIgnoreEvent(fqn, NodeEventType.ADD_NODE_EVENT)) {
            if (newData == null) {
                if (this.trace) {
                    this.log.trace((Object)("Putting null data under fqn " + fqn + "."));
                }
            } else {
                int size;
                Map map = newData;
                synchronized (map) {
                    size = newData.size();
                }
                EvictedEventNode event = new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, size);
                event.setResetElementCount(eraseContents);
                this.registerEvictionEventToRegionManager(event, ctx);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        Object retVal = this.nextInterceptor(ctx);
        if (fqn != null && !this.canIgnoreEvent(fqn, NodeEventType.ADD_NODE_EVENT)) {
            if (data == null) {
                if (this.trace) {
                    this.log.trace((Object)("Putting null data under fqn " + fqn + "."));
                }
            } else {
                int size;
                Map map = data;
                synchronized (map) {
                    size = data.size();
                }
                this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, size), ctx);
            }
        }
        return retVal;
    }

    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        Object retVal = this.nextInterceptor(ctx);
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Element does not exist");
            }
        } else if (fqn != null && key != null && !this.canIgnoreEvent(fqn, NodeEventType.REMOVE_ELEMENT_EVENT)) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.REMOVE_ELEMENT_EVENT, 1), ctx);
        }
        return retVal;
    }

    protected Object handleGetNodeMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        Object retVal = this.nextInterceptor(ctx);
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Node does not exist");
            }
        } else if (fqn != null && !this.canIgnoreEvent(fqn, NodeEventType.VISIT_NODE_EVENT)) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT), ctx);
        }
        return retVal;
    }

    protected Object handleGetDataMapMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.handleGetNodeMethod(ctx, fqn);
    }

    protected Object handleGetKeyValueMethod(InvocationContext ctx, Fqn fqn, Object key, boolean sendNodeEvent) throws Throwable {
        Object retVal = this.nextInterceptor(ctx);
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Element does not exist");
            }
        } else if (fqn != null && key != null && !this.canIgnoreEvent(fqn, NodeEventType.VISIT_NODE_EVENT)) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT), ctx);
        }
        return retVal;
    }

    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        Object retVal = this.nextInterceptor(ctx);
        if (fqn != null && !this.canIgnoreEvent(fqn, NodeEventType.REMOVE_NODE_EVENT)) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.REMOVE_NODE_EVENT), ctx);
        }
        return retVal;
    }

    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        return this.handleRemoveNodeMethod(ctx, tx, fqn, createUndoOps);
    }

    private void registerEvictionEventToRegionManager(EvictedEventNode event, InvocationContext ctx) {
        if (event == null) {
            return;
        }
        NodeSPI nodeSPI = this.peekNode(ctx, event.getFqn(), false, false, false);
        if (nodeSPI != null && nodeSPI.isResident()) {
            return;
        }
        Region region = this.regionManager.getRegion(event.getFqn(), false);
        region.putNodeEvent(event);
        if (this.trace) {
            this.log.trace((Object)("Adding event " + event + " to region at " + region.getFqn()));
        }
        if (this.trace) {
            this.log.trace((Object)"Finished updating node");
        }
    }

    protected boolean canIgnoreEvent(Fqn fqn, NodeEventType type) {
        Region r = this.regionManager.getRegion(fqn, Region.Type.EVICTION, false);
        return r == null || r.getEvictionPolicy().canIgnoreEvent(fqn, type);
    }
}

