/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.interceptors.ActivationInterceptor;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.DataGravitatorInterceptor;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.MarshalledValueInterceptor;
import org.jboss.cache.interceptors.NotificationInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticReplicationInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.ReplicationInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={Interceptor.class})
public class InterceptorChainFactory
extends ComponentFactory {
    @Deprecated
    public static InterceptorChainFactory getInstance() {
        return new InterceptorChainFactory();
    }

    public static Interceptor setLastInterceptorPointer(Interceptor first, Interceptor last) {
        for (Interceptor i = first; i != null; i = i.getNext()) {
            i.setLast(last);
        }
        return first;
    }

    private Interceptor createInterceptor(Class<? extends Interceptor> clazz) throws IllegalAccessException, InstantiationException {
        Interceptor i = this.componentRegistry.getComponent(clazz.getName(), clazz);
        if (i == null) {
            i = clazz.newInstance();
            this.componentRegistry.registerComponent(clazz.getName(), i, clazz);
        } else {
            i.setLast(null);
            i.setNext(null);
        }
        return i;
    }

    private void addInterceptor(Interceptor first, Class<? extends Interceptor> clazz) throws IllegalAccessException, InstantiationException {
        if (first == null) {
            return;
        }
        while (first.getNext() != null) {
            first = first.getNext();
        }
        first.setNext(this.createInterceptor(clazz));
    }

    private void addInterceptor(Interceptor first, Interceptor i) {
        if (first == null) {
            return;
        }
        while (first.getNext() != null) {
            first = first.getNext();
        }
        first.setNext(i);
    }

    public Interceptor buildInterceptorChain() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        boolean optimistic = this.configuration.isNodeLockingOptimistic();
        Interceptor first = this.setFirstInterceptor(InvocationContextInterceptor.class);
        if (this.configuration.getExposeManagementStatistics()) {
            this.addInterceptor(first, CacheMgmtInterceptor.class);
        }
        this.addInterceptor(first, TxInterceptor.class);
        if (this.configuration.isUseLazyDeserialization()) {
            this.addInterceptor(first, MarshalledValueInterceptor.class);
        }
        this.addInterceptor(first, NotificationInterceptor.class);
        switch (this.configuration.getCacheMode()) {
            case REPL_SYNC: 
            case REPL_ASYNC: {
                this.addInterceptor(first, optimistic ? OptimisticReplicationInterceptor.class : ReplicationInterceptor.class);
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                this.addInterceptor(first, InvalidationInterceptor.class);
                break;
            }
        }
        if (!optimistic) {
            this.addInterceptor(first, PessimisticLockInterceptor.class);
        }
        if (this.isUsingCacheLoaders()) {
            if (this.configuration.getCacheLoaderConfig().isPassivation()) {
                this.addInterceptor(first, ActivationInterceptor.class);
                this.addInterceptor(first, PassivationInterceptor.class);
            } else {
                this.addInterceptor(first, CacheLoaderInterceptor.class);
                this.addInterceptor(first, CacheStoreInterceptor.class);
            }
        }
        if (this.isUsingBuddyReplication()) {
            this.addInterceptor(first, DataGravitatorInterceptor.class);
        }
        if (optimistic) {
            this.addInterceptor(first, OptimisticLockingInterceptor.class);
            this.addInterceptor(first, OptimisticValidatorInterceptor.class);
            this.addInterceptor(first, OptimisticCreateIfNotExistsInterceptor.class);
        }
        if (this.configuration.getEvictionConfig() != null && this.configuration.getEvictionConfig().isValidConfig()) {
            this.addInterceptor(first, EvictionInterceptor.class);
        }
        if (optimistic) {
            this.addInterceptor(first, OptimisticNodeInterceptor.class);
        }
        Interceptor callInterceptor = this.createInterceptor(CallInterceptor.class);
        this.addInterceptor(first, callInterceptor);
        return InterceptorChainFactory.setLastInterceptorPointer(first, callInterceptor);
    }

    private boolean isUsingCacheLoaders() {
        return this.configuration.getCacheLoaderConfig() != null && !this.configuration.getCacheLoaderConfig().getIndividualCacheLoaderConfigs().isEmpty();
    }

    private boolean isUsingBuddyReplication() {
        return this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled() && this.configuration.getCacheMode() != Configuration.CacheMode.LOCAL;
    }

    public Interceptor setFirstInterceptor(Class<? extends Interceptor> clazz) throws IllegalAccessException, InstantiationException {
        return this.setFirstInterceptor(this.createInterceptor(clazz));
    }

    public Interceptor setFirstInterceptor(Interceptor i) {
        this.componentRegistry.registerComponent(Interceptor.class.getName(), i, Interceptor.class);
        return i;
    }

    public static List<Interceptor> asList(Interceptor interceptor) {
        if (interceptor == null) {
            return null;
        }
        int num = 1;
        Interceptor tmp = interceptor;
        while ((tmp = tmp.getNext()) != null) {
            ++num;
        }
        ArrayList<Interceptor> retval = new ArrayList<Interceptor>(num);
        tmp = interceptor;
        num = 0;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return retval;
    }

    public Interceptor correctInterceptorChaining(Interceptor first) {
        return this.correctInterceptorChaining(InterceptorChainFactory.asList(first));
    }

    public Interceptor correctInterceptorChaining(List<Interceptor> interceptors) {
        Interceptor first = null;
        Interceptor last = null;
        for (Interceptor next : interceptors) {
            if (first == null) {
                first = last = next;
                continue;
            }
            last.setNext(next);
            last = next;
        }
        if (last != null) {
            last.setNext(null);
        }
        Interceptor i = InterceptorChainFactory.setLastInterceptorPointer(first, last);
        this.componentRegistry.registerComponent(Interceptor.class.getName(), i, Interceptor.class);
        return i;
    }

    @Override
    protected <T> T construct(String componentName, Class<T> componentType) {
        try {
            return (T)this.buildInterceptorChain();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build interceptor chain", e);
        }
    }

    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

