/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.BuddyManagerFactory;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.EmptyConstructorFactory;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.factories.ReplicationQueueFactory;
import org.jboss.cache.factories.RuntimeConfigAwareFactory;
import org.jboss.cache.factories.TransactionManagerFactory;
import org.jboss.cache.factories.annotations.CacheInjectionMethods;
import org.jboss.cache.factories.annotations.ComponentName;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.factories.annotations.Destroy;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.invocation.RemoteCacheInvocationDelegate;
import org.jboss.cache.util.BeanUtils;
import org.jboss.cache.util.reflect.CachedMethod;
import org.jboss.cache.util.reflect.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry {
    static final Object NULL_COMPONENT = new Object();
    State overallState = State.CONSTRUCTED;
    Map<String, Component> componentLookup = new HashMap<String, Component>();
    Map<Class, Class<? extends ComponentFactory>> defaultFactories = null;
    private static Log log = LogFactory.getLog(ComponentRegistry.class);
    private Bootstrap bootstrap;
    Map<Class, List<CachedMethod>> shortTermMethodCache = null;
    Map<Class, List<CachedMethod>> longTermMethodCache = null;

    public ComponentRegistry(Configuration configuration) {
        this.registerDefaultClassLoader(null);
        this.registerComponent(this, ComponentRegistry.class);
        this.registerComponent(configuration, Configuration.class);
    }

    public void registerDefaultClassLoader(ClassLoader loader) {
        this.registerComponent("deployerClassLoader", loader == null ? this.getClass().getClassLoader() : loader, ClassLoader.class);
    }

    public State getOverallState() {
        return this.overallState;
    }

    private Set<Class<? extends ComponentFactory>> getHardcodedFactories() {
        HashSet<Class<? extends ComponentFactory>> s = new HashSet<Class<? extends ComponentFactory>>();
        s.add(BuddyManagerFactory.class);
        s.add(EmptyConstructorFactory.class);
        s.add(InterceptorChainFactory.class);
        s.add(RuntimeConfigAwareFactory.class);
        s.add(TransactionManagerFactory.class);
        s.add(ReplicationQueueFactory.class);
        return s;
    }

    public void registerComponent(Object component, Class type) {
        this.registerComponent(type.getName(), component, type);
    }

    public void registerComponent(String name, Object component, Class type) {
        Component c = new Component(name, component, type);
        Component old = this.componentLookup.get(name);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registering component " + c + " under name " + name + " replacing old component " + old));
        }
        if (old != null) {
            if (old.instance.equals(component)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Attempting to register a component equal to one that already exists under the same name (" + name + ").  Not doing anything."));
                }
                return;
            }
            this.unregisterComponent(name);
            c.dependencyFor.addAll(old.dependencyFor);
        }
        this.componentLookup.put(name, c);
        this.addComponentDependencies(c, old == null);
        State stateToMoveTo = this.overallState == null ? State.CONSTRUCTED : this.overallState;
        c.changeState(stateToMoveTo);
        if (old != null) {
            for (Component comp : old.dependencyFor) {
                if (comp.state == stateToMoveTo) continue;
                comp.changeState(stateToMoveTo);
            }
        }
    }

    protected void addComponentDependencies(Component c, boolean firstTimeAdded) {
        for (Component d : c.dependencies) {
            this.getOrCreateComponent(d.name, d.type);
            Component dependencyComponent = this.componentLookup.get(d.name);
            if (dependencyComponent == null) continue;
            dependencyComponent.dependencyFor.add(c);
        }
        if (firstTimeAdded) {
            for (Component other : this.componentLookup.values()) {
                if (!other.dependencies.contains(c)) continue;
                c.dependencyFor.add(other);
            }
        }
    }

    public <T> T getComponent(Class<T> c) {
        return this.getComponent(c.getName(), c);
    }

    public <T> T getComponent(String name, Class<T> c) {
        Object component;
        Component wrapper = this.componentLookup.get(name);
        if (wrapper == null) {
            return null;
        }
        Object object = component = wrapper.instance == NULL_COMPONENT ? null : wrapper.instance;
        if (component == null || c.isAssignableFrom(component.getClass())) {
            return (T)component;
        }
        throw new ConfigurationException("Component registered under " + name + " is of type " + component.getClass() + " and cannot be assigned to " + c);
    }

    public <T> T getOrCreateComponent(Class<T> componentClass) {
        return this.getOrCreateComponent(null, componentClass);
    }

    public <T> T getOrCreateComponent(String componentName, Class<T> componentClass) {
        T component = this.getComponent(componentName == null ? componentClass.getName() : componentName, componentClass);
        if (component == null) {
            String componentNameToUse;
            component = this.getFromConfiguration(componentClass);
            boolean attemptedFactoryConstruction = false;
            if (component == null && this.isNonBootstrapClass(componentClass)) {
                ComponentFactory factory = this.getFactory(componentClass);
                component = factory.construct(componentName, componentClass);
                attemptedFactoryConstruction = true;
            }
            String string = componentNameToUse = componentName == null ? componentClass.getName() : componentName;
            if (component != null) {
                this.registerComponent(componentNameToUse, component, componentClass);
            } else if (attemptedFactoryConstruction) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Registering a null for component " + componentNameToUse));
                }
                this.registerNullComponent(componentNameToUse, componentClass);
            }
        }
        return component;
    }

    void registerNullComponent(String componentName, Class type) {
        this.registerComponent(componentName, NULL_COMPONENT, type);
    }

    private boolean isNonBootstrapClass(Class<?> componentClass) {
        return !componentClass.equals(CacheSPI.class) && !componentClass.equals(CacheImpl.class) && !componentClass.equals(Cache.class) && !componentClass.equals(ComponentRegistry.class) && !componentClass.equals(Configuration.class);
    }

    <T> T getFromConfiguration(Class<T> componentClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking in configuration for an instance of " + componentClass + " that may have been injected from an external source."));
        }
        Method getter = BeanUtils.getterMethod(Configuration.class, componentClass);
        Object returnValue = null;
        if (getter != null) {
            try {
                returnValue = getter.invoke((Object)this.getConfiguration(), new Object[0]);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to invoke getter " + getter + " on Configuration.class!"), (Throwable)e);
            }
        }
        if (returnValue == null && (getter = BeanUtils.getterMethod(RuntimeConfig.class, componentClass)) != null) {
            try {
                returnValue = getter.invoke((Object)this.getConfiguration().getRuntimeConfig(), new Object[0]);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to invoke getter " + getter + " on RuntimeConfig.class!"), (Throwable)e);
            }
        }
        return (T)returnValue;
    }

    Configuration getConfiguration() {
        return this.getComponent(Configuration.class);
    }

    public void updateDependencies() {
        State originalState = this.overallState;
        this.moveComponentsToState(this.overallState == State.STARTED ? State.STOPPED : State.CONSTRUCTED);
        this.moveComponentsToState(originalState);
        CacheImpl ci = this.getComponent(CacheImpl.class);
        CacheSPI rcid = this.getComponent("remoteDelegate", RemoteCacheInvocationDelegate.class);
        CacheSPI spi = this.getComponent(CacheSPI.class.getName(), CacheSPI.class);
        this.unregisterComponent(CacheImpl.class);
        this.unregisterComponent(CacheSPI.class.getName());
        this.unregisterComponent("remoteDelegate");
        this.overallState = State.CONSTRUCTED;
        this.registerComponent(CacheImpl.class.getName(), ci, CacheImpl.class);
        this.registerComponent(CacheSPI.class.getName(), spi, CacheSPI.class);
        this.registerComponent("remoteDelegate", rcid, RemoteCacheInvocationDelegate.class);
        this.overallState = originalState;
        this.moveComponentsToState(this.overallState);
    }

    public void unregisterComponent(Class<?> clazz) {
        this.unregisterComponent(clazz.getName());
    }

    public void unregisterComponent(String name) {
        Component c = this.componentLookup.remove(name);
        if (c != null) {
            c.changeState(c.state == State.STARTED ? State.STOPPED : State.CONSTRUCTED);
        }
    }

    public void wireDependencies(Object target) throws ConfigurationException {
        try {
            List<CachedMethod> methods = this.lookupInjectionMethods(target.getClass());
            for (CachedMethod method : methods) {
                this.performInjection(method, target);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure component (type: " + target.getClass() + ", instance " + target + ")", e);
        }
    }

    private List<CachedMethod> lookupInjectionMethods(Class type) {
        if (this.longTermMethodCache != null && this.longTermMethodCache.containsKey(type)) {
            return this.longTermMethodCache.get(type);
        }
        if (this.shortTermMethodCache != null && this.shortTermMethodCache.containsKey(type)) {
            return this.shortTermMethodCache.get(type);
        }
        List<CachedMethod> methods = ReflectionUtil.getAllCachedMethods(type, Inject.class);
        if (type.isAnnotationPresent(CacheInjectionMethods.class)) {
            if (this.longTermMethodCache == null) {
                this.longTermMethodCache = new HashMap<Class, List<CachedMethod>>();
            }
            this.longTermMethodCache.put(type, methods);
        } else {
            if (this.shortTermMethodCache == null) {
                this.shortTermMethodCache = new HashMap<Class, List<CachedMethod>>();
            }
            this.shortTermMethodCache.put(type, methods);
        }
        return methods;
    }

    private <T> void performInjection(CachedMethod method, T target) throws IllegalAccessException, InvocationTargetException {
        Class[] parameterTypes = method.getParameterTypes();
        List<Component> componentsToInject = this.getDeclaredDependencies(method);
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = this.getComponent(componentsToInject.get((int)i).name, parameterTypes[i]);
        }
        Method reflectMethod = method.getMethod();
        reflectMethod.setAccessible(true);
        reflectMethod.invoke(target, parameters);
    }

    private String extractComponentName(Annotation[] annotationsOnParameter) {
        for (Annotation a : annotationsOnParameter) {
            if (!(a instanceof ComponentName)) continue;
            ComponentName cn = (ComponentName)a;
            return cn.value();
        }
        return null;
    }

    private List<Component> getDeclaredDependencies(CachedMethod method) {
        LinkedList<Component> dependencies = new LinkedList<Component>();
        Class[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotationsOnParams = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            String componentName = this.extractComponentName(annotationsOnParams[i]);
            String componentNameToUse = componentName == null ? parameterTypes[i].getName() : componentName;
            Component d = this.componentLookup.containsKey(componentNameToUse) ? this.componentLookup.get(componentNameToUse) : new Component(componentNameToUse, parameterTypes[i]);
            dependencies.add(d);
        }
        return dependencies;
    }

    protected ComponentFactory getFactory(Class componentClass) {
        Class<? extends ComponentFactory> cfClass;
        if (this.defaultFactories == null) {
            this.scanDefaultFactories();
        }
        if ((cfClass = this.defaultFactories.get(componentClass)) == null) {
            throw new ConfigurationException("No registered default factory for component " + componentClass + " found!");
        }
        ComponentFactory cf = this.getComponent(cfClass);
        if (cf == null && (cf = this.instantiateFactory(cfClass)) != null) {
            this.registerComponent(cf, cfClass);
        }
        if (cf == null) {
            throw new ConfigurationException("Unable to locate component factory for component " + componentClass);
        }
        Component c = this.componentLookup.get(cfClass.getName());
        if (c.instance != cf) {
            throw new ConfigurationException("Component factory " + cfClass + " incorrectly registered!");
        }
        c.changeState(State.STARTED);
        return cf;
    }

    void scanDefaultFactories() {
        this.defaultFactories = new HashMap<Class, Class<? extends ComponentFactory>>();
        Set<Class<? extends ComponentFactory>> factories = this.getHardcodedFactories();
        for (Class<? extends ComponentFactory> factory : factories) {
            DefaultFactoryFor dFFAnnotation = factory.getAnnotation(DefaultFactoryFor.class);
            for (Class targetClass : dFFAnnotation.classes()) {
                this.defaultFactories.put(targetClass, factory);
            }
        }
    }

    ComponentFactory instantiateFactory(Class<? extends ComponentFactory> factory) {
        try {
            return factory.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate factory " + factory, e);
        }
    }

    public void reset() {
        Component deployerClassLoader = this.componentLookup.get("deployerClassLoader");
        Component spi = this.componentLookup.get(CacheSPI.class.getName());
        Component impl = this.componentLookup.get(CacheImpl.class.getName());
        Component conf = this.componentLookup.get(Configuration.class.getName());
        Component cr = this.componentLookup.get(ComponentRegistry.class.getName());
        for (Component c : this.componentLookup.values()) {
            c.changeState(State.DESTROYED);
        }
        this.componentLookup.clear();
        deployerClassLoader.changeState(State.CONSTRUCTED);
        spi.changeState(State.CONSTRUCTED);
        impl.changeState(State.CONSTRUCTED);
        conf.changeState(State.CONSTRUCTED);
        cr.changeState(State.CONSTRUCTED);
        this.bootstrap = new Bootstrap((ClassLoader)deployerClassLoader.instance, (CacheImpl)impl.instance, (CacheSPI)spi.instance, (ComponentRegistry)cr.instance, (Configuration)conf.instance);
        this.overallState = null;
    }

    public void start() {
        this.moveComponentsToState(State.STARTED);
        this.shortTermMethodCache = null;
    }

    public void stop() {
        this.moveComponentsToState(State.STOPPED);
    }

    public void wire() {
        this.moveComponentsToState(State.WIRED);
    }

    void moveComponentsToState(State state) {
        if (this.overallState == null && this.bootstrap != null && !this.bootstrap.isBootstrapped()) {
            this.bootstrap.bootstrap();
        }
        for (Component c : this.componentLookup.values()) {
            c.changeState(state);
        }
        this.overallState = state;
    }

    class Bootstrap {
        CacheImpl cacheImpl;
        CacheSPI cacheSPI;
        ComponentRegistry componentRegistry;
        Configuration configuration;
        private ClassLoader deployerClassLoader;

        Bootstrap(ClassLoader deployerClassLoader, CacheImpl cacheImpl, CacheSPI cacheSPI, ComponentRegistry componentRegistry2, Configuration configuration) {
            this.deployerClassLoader = deployerClassLoader;
            this.cacheImpl = cacheImpl;
            this.cacheSPI = cacheSPI;
            this.componentRegistry = componentRegistry2;
            this.configuration = configuration;
        }

        boolean isBootstrapped() {
            return ComponentRegistry.this.componentLookup.containsKey(Configuration.class.getName()) && ComponentRegistry.this.componentLookup.containsKey(CacheImpl.class.getName()) && ComponentRegistry.this.componentLookup.containsKey(CacheSPI.class.getName()) && ComponentRegistry.this.componentLookup.containsKey(ComponentRegistry.class.getName()) && ComponentRegistry.this.componentLookup.containsKey("deployerClassLoader");
        }

        void bootstrap() {
            ComponentRegistry.this.overallState = State.CONSTRUCTED;
            ComponentRegistry.this.registerComponent("deployerClassLoader", this.deployerClassLoader, ClassLoader.class);
            ComponentRegistry.this.registerComponent(Configuration.class.getName(), this.configuration, Configuration.class);
            ComponentRegistry.this.registerComponent(ComponentRegistry.class.getName(), this.componentRegistry, ComponentRegistry.class);
            ComponentRegistry.this.registerComponent(CacheImpl.class.getName(), this.cacheImpl, CacheImpl.class);
            ComponentRegistry.this.registerComponent(CacheSPI.class.getName(), this.cacheSPI, CacheSPI.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Component {
        Object instance;
        String name;
        Class type;
        State state = State.CONSTRUCTED;
        Set<Component> dependencies = new HashSet<Component>(3);
        Set<Component> dependencyFor = new HashSet<Component>(3);
        boolean deepRecursionDetector = false;

        public Component(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public Component(String name, Object instance, Class type) {
            this(name, type);
            this.instance = instance;
            List injectionMethods = componentRegistry.lookupInjectionMethods(instance.getClass());
            for (CachedMethod m : injectionMethods) {
                this.dependencies.addAll(componentRegistry.getDeclaredDependencies(m));
            }
        }

        void changeState(State newState) {
            if (this.state != newState && !this.deepRecursionDetector) {
                boolean increase = newState.isGreaterThan(this.state);
                int numSteps = newState.absoluteDifference(this.state);
                while (numSteps > 1) {
                    this.changeState(State.values()[this.state.ordinal() + (increase ? 1 : -1)]);
                    numSteps = newState.absoluteDifference(this.state);
                }
                HashSet<Component> dependentComponents = new HashSet<Component>();
                HashSet<Component> shallowCyclic = new HashSet<Component>();
                if (increase) {
                    dependentComponents.addAll(this.dependencies);
                } else {
                    dependentComponents.addAll(this.dependencyFor);
                }
                this.deepRecursionDetector = true;
                for (Component d : dependentComponents) {
                    if (d == null) continue;
                    if (d.instance == null) {
                        Component c = ComponentRegistry.this.componentLookup.get(d.name);
                        if (increase) {
                            this.dependencies.remove(d);
                            this.dependencies.add(c);
                        } else {
                            this.dependencyFor.remove(d);
                            this.dependencies.add(c);
                        }
                        d = c;
                    }
                    if (d == null) continue;
                    if (this.isShallowCyclic(d)) {
                        shallowCyclic.add(d);
                        continue;
                    }
                    if ((!increase || !newState.isGreaterThan(d.state)) && (increase || !newState.isLessThan(d.state))) continue;
                    d.changeState(newState);
                }
                switch (newState) {
                    case STOPPED: {
                        this.stop();
                        break;
                    }
                    case WIRED: {
                        if (!increase) break;
                        this.wire();
                        break;
                    }
                    case STARTED: {
                        this.start();
                        break;
                    }
                    case DESTROYED: {
                        this.destroy();
                        break;
                    }
                }
                this.state = newState;
                for (Component c : shallowCyclic) {
                    if ((!increase || !newState.isGreaterThan(c.state)) && (increase || !newState.isLessThan(c.state))) continue;
                    c.changeState(newState);
                }
                this.deepRecursionDetector = false;
            }
        }

        private boolean isShallowCyclic(Component c) {
            return this.dependencies.contains(c) && c.dependencies.contains(this);
        }

        void wire() {
            try {
                List methods = ComponentRegistry.this.lookupInjectionMethods(this.instance.getClass());
                for (CachedMethod method : methods) {
                    ComponentRegistry.this.performInjection(method, this.instance);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to configure component (type: " + this.instance.getClass() + ", instance " + this.instance + ")", e);
            }
        }

        void start() {
            this.invokeMethods(Start.class);
        }

        void stop() {
            this.invokeMethods(Stop.class);
        }

        void destroy() {
            this.invokeMethods(Destroy.class);
        }

        private void invokeMethods(Class<? extends Annotation> annotation) {
            List<Method> methods = ReflectionUtil.getAllMethods(this.instance.getClass(), annotation);
            for (Method m : methods) {
                try {
                    m.setAccessible(true);
                    m.invoke(this.instance, new Object[0]);
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to invoke annotated method " + m), (Throwable)e);
                }
            }
        }

        public String toString() {
            return "Component (name = " + this.name + ", state = " + (Object)((Object)this.state) + ")";
        }

        public int hashCode() {
            return 31 * this.name.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Component && this.name.equals(((Component)other).name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DESTROYED,
        STOPPED,
        CONSTRUCTED,
        WIRED,
        STARTED;


        boolean isGreaterThan(State other) {
            return this.ordinal() > other.ordinal();
        }

        boolean isLessThan(State other) {
            return this.ordinal() < other.ordinal();
        }

        int absoluteDifference(State other) {
            return Math.abs(this.ordinal() - other.ordinal());
        }
    }
}

