/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Region;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.eviction.MRUQueue;
import org.jboss.cache.eviction.NodeEntry;

public class MRUAlgorithm
extends BaseEvictionAlgorithm {
    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new MRUQueue();
    }

    protected boolean shouldEvictNode(NodeEntry ne) {
        if (this.isYoungerThanMinimumTimeToLive(ne)) {
            return false;
        }
        MRUConfiguration config = (MRUConfiguration)this.region.getEvictionPolicyConfig();
        return this.evictionQueue.getNumberOfNodes() > config.getMaxNodes();
    }

    protected void processVisitedNodes(EvictedEventNode evictedEventNode) throws EvictionException {
        super.processVisitedNodes(evictedEventNode);
        ((MRUQueue)this.evictionQueue).moveToTopOfStack(evictedEventNode.getFqn());
    }
}

