/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.EvictionPolicyConfigBase;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.lock.TimeoutException;

public abstract class BaseEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog(BaseEvictionAlgorithm.class);
    protected Region region;
    protected BlockingQueue<Fqn> recycleQueue = new LinkedBlockingQueue<Fqn>(500000);
    protected EvictionQueue evictionQueue;
    protected boolean allowTombstones = false;

    protected abstract EvictionQueue setupEvictionQueue(Region var1) throws EvictionException;

    protected abstract boolean shouldEvictNode(NodeEntry var1);

    protected BaseEvictionAlgorithm() {
    }

    protected void initialize(Region region) throws EvictionException {
        if (region == null) {
            throw new IllegalArgumentException("region");
        }
        this.region = region;
        this.evictionQueue = this.setupEvictionQueue(region);
        log.debug((Object)("initialized: " + this));
        Configuration c = region.getCacheConfiguration();
        Configuration.CacheMode cm = c != null ? c.getCacheMode() : Configuration.CacheMode.LOCAL;
        this.allowTombstones = c != null && c.isNodeLockingOptimistic() && (cm == Configuration.CacheMode.INVALIDATION_ASYNC || cm == Configuration.CacheMode.INVALIDATION_SYNC);
    }

    public void process(Region region) throws EvictionException {
        if (this.region == null) {
            this.initialize(region);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("process(): region: " + region.getFqn()));
        }
        this.processQueues(region);
        this.emptyRecycleQueue();
        this.prune();
    }

    public void resetEvictionQueue(Region region) {
    }

    public EvictionQueue getEvictionQueue() {
        return this.evictionQueue;
    }

    protected void processQueues(Region region) throws EvictionException {
        EvictedEventNode node;
        int count = 0;
        block9: while ((node = region.takeLastEventNode()) != null) {
            ++count;
            switch (node.getEventType()) {
                case ADD_NODE_EVENT: {
                    this.processAddedNodes(node);
                    continue block9;
                }
                case REMOVE_NODE_EVENT: {
                    this.processRemovedNodes(node);
                    continue block9;
                }
                case VISIT_NODE_EVENT: {
                    this.processVisitedNodes(node);
                    continue block9;
                }
                case ADD_ELEMENT_EVENT: {
                    this.processAddedElement(node);
                    continue block9;
                }
                case REMOVE_ELEMENT_EVENT: {
                    this.processRemovedElement(node);
                    continue block9;
                }
                case MARK_IN_USE_EVENT: {
                    this.processMarkInUseNodes(node.getFqn(), node.getInUseTimeout());
                    continue block9;
                }
                case UNMARK_USE_EVENT: {
                    this.processUnmarkInUseNodes(node.getFqn());
                    continue block9;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + (Object)((Object)node.getEventType()));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("processed " + count + " node events in region: " + region.getFqn()));
        }
    }

    protected void evict(NodeEntry ne) {
        if (ne != null) {
            this.evictionQueue.removeNodeEntry(ne);
            if (!this.evictCacheNode(ne.getFqn())) {
                try {
                    boolean result = this.recycleQueue.offer(ne.getFqn(), 5L, TimeUnit.SECONDS);
                    if (!result) {
                        log.warn((Object)("Unable to add Fqn[" + ne.getFqn() + "] to recycle " + "queue because it's full. This is often sign that " + "evictions are not occurring and nodes that should be " + "evicted are piling up waiting to be evicted."));
                    }
                }
                catch (InterruptedException e) {
                    log.debug((Object)"InterruptedException", (Throwable)e);
                }
            }
        }
    }

    protected boolean evictCacheNode(Fqn fqn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to evict cache node with fqn of " + fqn));
        }
        EvictionPolicy policy = this.region.getEvictionPolicy();
        try {
            policy.evict(fqn);
        }
        catch (TimeoutException e) {
            log.warn((Object)("Eviction of " + fqn + " timed out, retrying later"));
            log.debug((Object)e, (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Eviction of " + fqn + " failed"), (Throwable)e);
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Eviction of cache node with fqn of " + fqn + " successful"));
        }
        return true;
    }

    protected void processMarkInUseNodes(Fqn fqn, long inUseTimeout) throws EvictionException {
        NodeEntry ne;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Marking node " + fqn + " as in use with a usage timeout of " + inUseTimeout));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setCurrentlyInUse(true, inUseTimeout);
        }
    }

    protected void processUnmarkInUseNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unmarking node " + fqn + " as in use"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setCurrentlyInUse(false, 0L);
        }
    }

    protected void processAddedNodes(EvictedEventNode evictedEventNode) throws EvictionException {
        this.processAddedNodes(evictedEventNode, evictedEventNode.getElementDifference(), evictedEventNode.isResetElementCount());
    }

    protected void processAddedNodes(EvictedEventNode evictedEventNode, int numAddedElements, boolean resetElementCount) throws EvictionException {
        NodeEntry ne;
        Fqn fqn = evictedEventNode.getFqn();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding node " + fqn + " with " + numAddedElements + " elements to eviction queue"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setModifiedTimeStamp(evictedEventNode.getCreationTimestamp());
            ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
            if (resetElementCount) {
                ne.setNumberOfElements(numAddedElements);
            } else {
                ne.setNumberOfElements(ne.getNumberOfElements() + numAddedElements);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Queue already contains " + ne.getFqn() + " processing it as visited"));
            }
            this.processVisitedNodes(evictedEventNode);
            return;
        }
        ne = new NodeEntry(fqn);
        ne.setModifiedTimeStamp(evictedEventNode.getCreationTimestamp());
        ne.setNumberOfNodeVisits(1);
        ne.setNumberOfElements(numAddedElements);
        this.evictionQueue.addNodeEntry(ne);
        if (log.isTraceEnabled()) {
            log.trace((Object)(ne.getFqn() + " added successfully to eviction queue"));
        }
    }

    protected void processRemovedNodes(EvictedEventNode evictedEventNode) throws EvictionException {
        NodeEntry ne;
        Fqn fqn = evictedEventNode.getFqn();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing node " + fqn + " from eviction queue and attempting eviction"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            if (this.allowTombstones) {
                return;
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processRemoveNodes(): Can't find node associated with fqn: " + fqn + "Could have been evicted earlier. Will just continue."));
            }
            return;
        }
        this.evictionQueue.removeNodeEntry(ne);
        if (log.isTraceEnabled()) {
            log.trace((Object)(fqn + " removed from eviction queue"));
        }
    }

    protected void processVisitedNodes(EvictedEventNode evictedEventNode) throws EvictionException {
        Fqn fqn = evictedEventNode.getFqn();
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Visiting node that was not added to eviction queues. Assuming that it has 1 element.");
            }
            this.processAddedNodes(evictedEventNode, 1, false);
            return;
        }
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(System.currentTimeMillis());
    }

    protected void processRemovedElement(EvictedEventNode evictedEventNode) throws EvictionException {
        Fqn fqn = evictedEventNode.getFqn();
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing element from " + fqn + " but eviction queue does not contain this node. " + "Ignoring removeElement event."));
            }
            return;
        }
        ne.setNumberOfElements(ne.getNumberOfElements() - 1);
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(System.currentTimeMillis());
    }

    protected void processAddedElement(EvictedEventNode evictedEventNode) throws EvictionException {
        Fqn fqn = evictedEventNode.getFqn();
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Adding element " + fqn + " for a node that doesn't exist yet. Process as an add."));
            }
            this.processAddedNodes(evictedEventNode, 1, false);
            return;
        }
        ne.setNumberOfElements(ne.getNumberOfElements() + 1);
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(System.currentTimeMillis());
    }

    protected void emptyRecycleQueue() throws EvictionException {
        block6: {
            Fqn fqn;
            do {
                try {
                    fqn = this.recycleQueue.poll(0L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.debug((Object)e, (Throwable)e);
                    break block6;
                }
                if (fqn == null) {
                    if (!log.isTraceEnabled()) break block6;
                    log.trace((Object)"Recycle queue is empty");
                    break block6;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("emptying recycle bin. Evict node " + fqn));
            } while (this.evictCacheNode(fqn));
            try {
                this.recycleQueue.put(fqn);
            }
            catch (InterruptedException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected boolean isNodeInUseAndNotTimedOut(NodeEntry ne) {
        if (ne.isCurrentlyInUse()) {
            if (ne.getInUseTimeoutTimestamp() == 0L) {
                return true;
            }
            if (System.currentTimeMillis() < ne.getInUseTimeoutTimestamp()) {
                return true;
            }
        }
        return false;
    }

    protected void prune() throws EvictionException {
        NodeEntry entry;
        while ((entry = this.evictionQueue.getFirstNodeEntry()) != null && this.shouldEvictNode(entry)) {
            this.evict(entry);
        }
    }

    public String toString() {
        return super.toString() + " reqion=" + this.region.getFqn() + " recycle=" + this.recycleQueue.size() + " evict=" + this.evictionQueue.getNumberOfNodes();
    }

    protected boolean isYoungerThanMinimumTimeToLive(NodeEntry entry) {
        if (this.region.getEvictionPolicyConfig() instanceof EvictionPolicyConfigBase) {
            EvictionPolicyConfigBase cfg = (EvictionPolicyConfigBase)this.region.getEvictionPolicyConfig();
            int minTTL = cfg.getMinTimeToLiveSeconds();
            return minTTL >= 1 && entry.getModifiedTimeStamp() + (long)(1000 * minTTL) > System.currentTimeMillis();
        }
        log.trace((Object)"Eviction policy implementation does not support minimum TTL!");
        return false;
    }
}

