/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.Region;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTimerTask;
import org.jboss.cache.factories.annotations.Destroy;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RegionManager {
    public static final Fqn<?> DEFAULT_REGION = new Fqn<String>("_default_");
    private Map<Fqn, Region> regionsRegistry = new ConcurrentHashMap<Fqn, Region>();
    private boolean defaultInactive;
    private Log log = LogFactory.getLog(RegionManager.class);
    private CacheSPI cache;
    private boolean usingEvictions;
    private EvictionConfig evictionConfig;
    private EvictionTimerTask evictionTimerTask = new EvictionTimerTask();
    protected final Set<Fqn> activationChangeNodes = Collections.synchronizedSet(new HashSet());
    protected Configuration configuration;
    protected RPCManager rpcManager;

    @Inject
    void injectDependencies(CacheSPI cache, Configuration configuration, RPCManager rpcManager) {
        this.cache = cache;
        this.rpcManager = rpcManager;
        this.configuration = configuration;
    }

    @Start
    protected void start() {
        this.log.trace((Object)"Starting region manager");
        if (this.configuration.getEvictionConfig() != null && this.configuration.getEvictionConfig().isValidConfig()) {
            for (EvictionRegionConfig erc : this.configuration.getEvictionConfig().getEvictionRegionConfigs()) {
                EvictionPolicyConfig epc = erc.getEvictionPolicyConfig();
                if (epc == null) continue;
                epc.validate();
            }
            this.setEvictionConfig(this.configuration.getEvictionConfig());
            this.setUsingEvictions(true);
        } else {
            this.setUsingEvictions(false);
            this.log.debug((Object)"Not using an EvictionPolicy");
        }
        this.setDefaultInactive(this.configuration.isInactiveOnStartup());
    }

    @Stop
    protected void stop() {
        if (this.isUsingEvictions()) {
            this.stopEvictionThread();
        }
    }

    @Destroy
    protected void destroy() {
        this.regionsRegistry.clear();
        this.activationChangeNodes.clear();
    }

    public boolean isUsingEvictions() {
        return this.usingEvictions;
    }

    public boolean isDefaultInactive() {
        return this.defaultInactive;
    }

    public void setDefaultInactive(boolean defaultInactive) {
        this.defaultInactive = defaultInactive;
        Region defaultRegion = this.regionsRegistry.get(Fqn.ROOT);
        if (defaultRegion != null) {
            defaultRegion.setActive(!defaultInactive);
        }
    }

    public void setContextClassLoaderAsCurrent(Fqn fqn) {
        Region region;
        ClassLoader regionCL;
        if (fqn.isChildOf(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)) {
            fqn = fqn.size() <= 2 ? Fqn.ROOT : fqn.getSubFqn(2, fqn.size());
        }
        ClassLoader classLoader = regionCL = (region = this.getRegion(fqn, false)) == null ? null : region.getClassLoader();
        if (regionCL != null) {
            Thread.currentThread().setContextClassLoader(regionCL);
        }
    }

    public Region getRegion(Fqn fqn, boolean createIfAbsent) {
        return this.getRegion(fqn, Region.Type.ANY, createIfAbsent);
    }

    public Region getRegion(Fqn fqn, Region.Type type, boolean createIfAbsent) {
        Region r;
        Fqn fqnToUse;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Contents of RegionsRegistry: " + this.regionsRegistry));
        }
        if (DEFAULT_REGION.equals(fqnToUse = fqn)) {
            fqnToUse = Fqn.ROOT;
        }
        if (this.regionsRegistry.containsKey(fqnToUse)) {
            r = this.regionsRegistry.get(fqnToUse);
            if (type == Region.Type.ANY || type == Region.Type.MARSHALLING && r.getClassLoader() != null || type == Region.Type.EVICTION && r.getEvictionPolicyConfig() != null) {
                return r;
            }
        }
        if (createIfAbsent) {
            r = new RegionImpl(fqnToUse, this);
            this.regionsRegistry.put(fqnToUse, r);
            if (type == Region.Type.MARSHALLING) {
                r.registerContextClassLoader(this.getClass().getClassLoader());
            }
            return r;
        }
        Region nextBestThing = null;
        Fqn nextFqn = fqnToUse;
        while (nextBestThing == null) {
            if (this.regionsRegistry.containsKey(nextFqn = nextFqn.getParent())) {
                Region r2 = this.regionsRegistry.get(nextFqn);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Trying next region " + nextFqn + " and got " + r2));
                }
                if (type == Region.Type.ANY || type == Region.Type.MARSHALLING && r2.getClassLoader() != null || type == Region.Type.EVICTION && r2.getEvictionPolicyConfig() != null) {
                    nextBestThing = r2;
                }
            }
            if (!nextFqn.isRoot()) continue;
        }
        if (type == Region.Type.EVICTION && nextBestThing != null && nextBestThing.getFqn().isRoot() && !this.regionsRegistry.containsKey(Fqn.ROOT)) {
            this.log.trace((Object)"No default eviction region; returning null");
            nextBestThing = null;
        }
        return nextBestThing;
    }

    public Region getRegion(String fqn, boolean createIfAbsent) {
        return this.getRegion(Fqn.fromString(fqn), createIfAbsent);
    }

    public boolean removeRegion(Fqn fqn) {
        Region r = this.regionsRegistry.remove(fqn);
        if (r == null) {
            return false;
        }
        if (this.isUsingEvictions() && r.getEvictionPolicy() != null) {
            this.evictionTimerTask.removeRegionToProcess(r);
        }
        return true;
    }

    protected EvictionTimerTask getEvictionTimerTask() {
        return this.evictionTimerTask;
    }

    public void activate(Fqn fqn) throws RegionNotEmptyException {
        this.activate(fqn, false);
    }

    public void activateIfEmpty(Fqn fqn) {
        this.activate(fqn, true);
    }

    private void activate(Fqn fqn, boolean suppressRegionNotEmptyException) {
        try {
            Region r;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Activating region " + fqn));
            }
            if ((r = this.getRegion(fqn, false)) != null) {
                if (!this.defaultInactive && r.getClassLoader() == null) {
                    this.removeRegion(fqn);
                } else {
                    r.setStatus(Region.Status.ACTIVATING);
                    if (this.configuration.isFetchInMemoryState()) {
                        this.activateRegion(r.getFqn(), suppressRegionNotEmptyException);
                    }
                    r.setActive(true);
                }
            } else if (this.defaultInactive) {
                r = this.getRegion(fqn, true);
                r.setStatus(Region.Status.ACTIVATING);
                if (this.configuration.isFetchInMemoryState()) {
                    this.activateRegion(r.getFqn(), suppressRegionNotEmptyException);
                }
                r.setActive(true);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateRegion(Fqn fqn, boolean suppressRegionNotEmptyException) {
        block20: {
            Node subtreeRoot = this.cache.peek(fqn, false, false);
            if (this.isActivatingDeactivating(fqn)) {
                throw new CacheException("Region " + subtreeRoot.getFqn() + " is already being activated/deactivated");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("activating " + fqn));
            }
            try {
                this.activationChangeNodes.add(fqn);
                BuddyManager buddyManager = this.cache.getBuddyManager();
                if (buddyManager == null) {
                    List<Address> members;
                    if (subtreeRoot == null) {
                        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                        subtreeRoot = this.cache.getRoot().addChild(fqn);
                        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
                    }
                    if ((members = this.cache.getMembers()) != null && !members.isEmpty()) {
                        this.rpcManager.fetchPartialState(members, subtreeRoot.getFqn());
                    }
                } else if (!BuddyManager.isBackupFqn(fqn)) {
                    List<Address> buddies = buddyManager.getBackupDataOwners();
                    for (Address buddy : buddies) {
                        ArrayList<Address> sources = new ArrayList<Address>(1);
                        if (!this.cache.getMembers().contains(buddy)) continue;
                        sources.add(buddy);
                        Fqn buddyRoot = BuddyManager.getBackupFqn(buddy, fqn);
                        subtreeRoot = this.cache.peek(buddyRoot, false, false);
                        if (subtreeRoot == null) {
                            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                            subtreeRoot = this.cache.getRoot().addChild(buddyRoot);
                            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
                        }
                        this.rpcManager.fetchPartialState(sources, fqn, subtreeRoot.getFqn());
                    }
                } else {
                    this.log.info((Object)"Attempting to activate a backup region.  Not attempting to retrieve any state as this will be pushed.");
                }
            }
            catch (Throwable t) {
                this.log.error((Object)("failed to activate " + fqn), t);
                try {
                    this.inactivateRegion(fqn);
                }
                catch (Exception e) {
                    this.log.error((Object)("failed inactivating " + fqn), (Throwable)e);
                }
                if (t instanceof RegionNotEmptyException) {
                    if (!suppressRegionNotEmptyException) {
                        throw (RegionNotEmptyException)t;
                    }
                    break block20;
                }
                if (t instanceof CacheException) {
                    throw (CacheException)t;
                }
                throw new CacheException(t.getClass().getName() + " " + t.getLocalizedMessage(), t);
            }
            finally {
                this.activationChangeNodes.remove(fqn);
            }
        }
    }

    public boolean isInactive(Fqn fqn) {
        Region region = this.getRegion(fqn, false);
        return region == null ? this.defaultInactive : !region.isActive();
    }

    private void inactivateRegion(Fqn fqn) throws CacheException {
        if (this.isActivatingDeactivating(fqn)) {
            throw new CacheException("Region " + fqn + " is already being activated/deactivated");
        }
        NodeSPI parent = null;
        NodeSPI subtreeRoot = null;
        boolean parentLocked = false;
        boolean subtreeLocked = false;
        NodeLock parentLock = null;
        NodeLock subtreeLock = null;
        try {
            Set<Object> buddies;
            this.activationChangeNodes.add(fqn);
            if (!this.isInactive(fqn)) {
                this.deactivate(fqn);
            }
            BuddyManager buddyManager = this.cache.getBuddyManager();
            ArrayList<Fqn<Object>> list = new ArrayList<Fqn<Object>>();
            list.add(fqn);
            if (buddyManager != null && (buddies = this.cache.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, false, false).getChildrenNames()) != null) {
                Iterator<Object> it = buddies.iterator();
                while (it.hasNext()) {
                    Fqn<Object> base = new Fqn<Object>(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, it.next());
                    list.add(new Fqn<Object>(base, fqn));
                }
            }
            long stateFetchTimeout = this.cache.getConfiguration().getLockAcquisitionTimeout() + 5000L;
            for (Fqn fqn2 : list) {
                subtreeRoot = this.cache.peek(fqn2, false, false);
                if (subtreeRoot == null) continue;
                Object owner = this.getOwnerForLock();
                subtreeLock = subtreeRoot.getLock();
                subtreeLock.acquireAll(owner, stateFetchTimeout, NodeLock.LockType.WRITE);
                subtreeLocked = true;
                parent = subtreeRoot.getParent();
                if (parent != null) {
                    parentLock = parent.getLock();
                    parentLock.acquire(owner, stateFetchTimeout, NodeLock.LockType.WRITE);
                    parentLocked = true;
                }
                this.cache.evict(fqn2, true);
                if (parent != null) {
                    this.log.debug((Object)"forcing release of locks in parent");
                    parentLock.releaseAll();
                }
                parentLocked = false;
                this.log.debug((Object)"forcing release of all locks in subtree");
                subtreeLock.releaseAll();
                subtreeLocked = false;
            }
        }
        catch (InterruptedException ie) {
            throw new CacheException("Interrupted while acquiring lock", ie);
        }
        finally {
            if (parentLocked) {
                this.log.debug((Object)"forcing release of locks in parent");
                try {
                    parentLock.releaseAll();
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed releasing locks", t);
                }
            }
            if (subtreeLocked) {
                this.log.debug((Object)"forcing release of all locks in subtree");
                try {
                    subtreeLock.releaseAll();
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed releasing locks", t);
                }
            }
            this.activationChangeNodes.remove(fqn);
        }
    }

    private Object getOwnerForLock() {
        GlobalTransaction owner = this.cache.getCurrentTransaction();
        return owner == null ? Thread.currentThread() : owner;
    }

    private boolean isActivatingDeactivating(Fqn fqn) {
        return this.activationChangeNodes.contains(fqn);
    }

    public boolean hasRegion(Fqn fqn, Region.Type type) {
        Region r = this.regionsRegistry.get(fqn);
        if (r == null) {
            return false;
        }
        switch (type) {
            case ANY: {
                return true;
            }
            case EVICTION: {
                return r.getEvictionPolicy() != null && this.evictionTimerTask.isRegionRegisteredForProcessing(r);
            }
            case MARSHALLING: {
                return r.isActive() && r.getClassLoader() != null;
            }
        }
        return false;
    }

    public void deactivate(Fqn fqn) {
        try {
            Region region = this.getRegion(fqn, false);
            if (region != null) {
                if (this.defaultInactive && region.getClassLoader() == null) {
                    this.removeRegion(fqn);
                } else {
                    region.setActive(false);
                    if (this.cache.getConfiguration().isFetchInMemoryState()) {
                        this.inactivateRegion(fqn);
                    }
                }
            } else if (!this.defaultInactive) {
                region = this.getRegion(fqn, true);
                region.setActive(false);
                if (this.cache.getConfiguration().isFetchInMemoryState()) {
                    this.inactivateRegion(fqn);
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.regionsRegistry.clear();
    }

    public List<Region> getAllRegions(Region.Type type) {
        ArrayList<Region> regions;
        if (type != Region.Type.ANY) {
            regions = new ArrayList();
            for (Region r : this.regionsRegistry.values()) {
                if ((type != Region.Type.EVICTION || r.getEvictionPolicy() == null || !this.evictionTimerTask.isRegionRegisteredForProcessing(r)) && (type != Region.Type.MARSHALLING || !r.isActive() || r.getClassLoader() == null)) continue;
                regions.add(r);
            }
        } else {
            regions = new ArrayList<Region>(this.regionsRegistry.values());
        }
        Collections.sort(regions);
        return regions;
    }

    public void setUsingEvictions(boolean usingEvictions) {
        this.usingEvictions = usingEvictions;
    }

    public void setEvictionConfig(EvictionConfig evictionConfig) {
        this.evictionConfig = evictionConfig;
        boolean needDefault = true;
        List<EvictionRegionConfig> ercs = evictionConfig.getEvictionRegionConfigs();
        boolean bl = needDefault = ercs.size() == 0;
        if (needDefault) {
            EvictionRegionConfig dflt = evictionConfig.createDefaultEvictionRegionConfig();
            ercs.add(0, dflt);
            evictionConfig.setEvictionRegionConfigs(ercs);
        }
        boolean setDefault = false;
        for (EvictionRegionConfig erc : ercs) {
            Fqn fqn = erc.getRegionFqn();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Creating eviction region " + fqn));
            }
            if (fqn.equals(DEFAULT_REGION)) {
                if (setDefault) {
                    throw new ConfigurationException("A default region for evictions has already been set for this cache");
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Applying settings for " + DEFAULT_REGION + " to Fqn.ROOT"));
                }
                fqn = Fqn.ROOT;
                setDefault = true;
            }
            Region r = this.getRegion(fqn, true);
            r.setEvictionPolicy(erc.getEvictionPolicyConfig());
        }
    }

    public void startEvictionThread() {
        this.evictionTimerTask.init(this.evictionConfig.getWakeupIntervalSeconds());
    }

    public void stopEvictionThread() {
        this.evictionTimerTask.stop();
    }

    public String dumpRegions() {
        StringBuilder sb = new StringBuilder();
        for (Region r : this.regionsRegistry.values()) {
            sb.append("\tRegion " + r);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return "RegionManager " + this.dumpRegions();
    }

    public CacheSPI getCache() {
        return this.cache;
    }
}

