/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.SuspectException;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.annotations.ComponentName;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.invocation.RemoteCacheInvocationDelegate;
import org.jboss.cache.lock.LockUtil;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.InactiveRegionAwareRpcDispatcher;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.remoting.jgroups.CacheMessageListener;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.ThreadGate;
import org.jboss.cache.util.reflect.ReflectionUtil;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.StateTransferException;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCManagerImpl
implements RPCManager {
    private Channel channel;
    private Log log = LogFactory.getLog(RPCManagerImpl.class);
    private List<Address> members = new LinkedList<Address>();
    private volatile boolean coordinator = false;
    private final ThreadGate flushBlockGate = new ThreadGate();
    private RpcDispatcher disp = null;
    private CacheMessageListener messageListener;
    private Configuration configuration;
    private Notifier notifier;
    private CacheSPI spi;
    private boolean trace = this.log.isTraceEnabled();
    private RemoteCacheInvocationDelegate remoteDelegate;
    private Marshaller marshaller;
    private TransactionManager txManager;
    private TransactionTable txTable;
    private boolean isUsingBuddyReplication;
    private boolean isInLocalMode;

    @Inject
    private void setupDependencies(CacheMessageListener messageListener, Configuration configuration, Notifier notifier, CacheSPI spi, Marshaller marshaller, @ComponentName(value="remoteDelegate") RemoteCacheInvocationDelegate remoteDelegate, TransactionTable txTable, TransactionManager txManager) {
        this.messageListener = messageListener;
        this.configuration = configuration;
        this.notifier = notifier;
        this.spi = spi;
        this.remoteDelegate = remoteDelegate;
        this.marshaller = marshaller;
        this.txManager = txManager;
        this.txTable = txTable;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void start() {
        switch (1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[this.configuration.getCacheMode().ordinal()]) {
            case 1: {
                this.log.debug((Object)"cache mode is local, will not create the channel");
                this.isInLocalMode = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.isInLocalMode = false;
                v0 = this.isUsingBuddyReplication = this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled() != false;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cache mode is " + (Object)this.configuration.getCacheMode()));
                }
                this.initialiseChannelAndRpcDispatcher();
                if (this.shouldFetchStateOnStartup()) {
                    try {
                        start = System.currentTimeMillis();
                        this.channel.connect(this.configuration.getClusterName(), null, null, this.configuration.getStateRetrievalTimeout());
                        if (this.getMembers().size() > 1) {
                            this.messageListener.waitForState();
                        }
                        if (!this.log.isDebugEnabled()) ** GOTO lbl33
                        this.log.debug((Object)("connected, state was retrieved successfully (in " + (System.currentTimeMillis() - start) + " milliseconds)"));
                    }
                    catch (StateTransferException ste) {
                        this.disconnect();
                        throw new CacheException("Unable to fetch state on startup", ste);
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                    catch (Exception ex) {
                        throw new CacheException("Unable to fetch state on startup", ex);
                    }
                } else {
                    try {
                        this.channel.connect(this.configuration.getClusterName());
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                }
lbl33:
                // 3 sources

                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)("Cache local address is " + this.getLocalAddress()));
            }
        }
        this.isUsingBuddyReplication = this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled() != false;
    }

    @Override
    public void disconnect() {
        if (this.channel != null && this.channel.isOpen()) {
            this.log.info((Object)"Disconnecting and closing the Channel");
            this.channel.disconnect();
            this.channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop
    public void stop() {
        try {
            this.disconnect();
        }
        catch (Exception toLog) {
            this.log.error((Object)"Problem closing channel; setting it to null", (Throwable)toLog);
        }
        this.channel = null;
        this.configuration.getRuntimeConfig().setChannel(null);
        if (this.disp != null) {
            this.log.info((Object)"Stopping the RpcDispatcher");
            this.disp.stop();
        }
        if (this.members != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.clear();
            }
        }
        this.coordinator = false;
        this.disp = null;
    }

    private boolean shouldFetchStateOnStartup() {
        boolean loaderFetch = this.configuration.getCacheLoaderConfig() != null && this.configuration.getCacheLoaderConfig().isFetchPersistentState();
        return !this.configuration.isInactiveOnStartup() && !this.isUsingBuddyReplication && (this.configuration.isFetchInMemoryState() || loaderFetch);
    }

    private void initialiseChannelAndRpcDispatcher() throws CacheException {
        this.channel = this.configuration.getRuntimeConfig().getChannel();
        if (this.channel == null) {
            this.channel = this.getMultiplexerChannel();
            if (this.channel != null) {
                ReflectionUtil.setValue(this.configuration, "accessible", true);
                this.configuration.setUsingMultiplexer(true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Created Multiplexer Channel for cache cluster " + this.configuration.getClusterName() + " using stack " + this.configuration.getMultiplexerStack()));
                }
            } else {
                try {
                    if (this.configuration.getClusterConfig() == null) {
                        this.log.debug((Object)"setting cluster properties to default value");
                        this.channel = new JChannel(this.configuration.getDefaultClusterConfig());
                    } else {
                        if (this.trace) {
                            this.log.trace((Object)("Cache cluster properties: " + this.configuration.getClusterConfig()));
                        }
                        this.channel = new JChannel(this.configuration.getClusterConfig());
                    }
                }
                catch (ChannelException el) {
                    el.printStackTrace();
                }
            }
            this.configuration.getRuntimeConfig().setChannel(this.channel);
        }
        this.channel.setOpt(5, (Object)true);
        this.channel.setOpt(6, (Object)true);
        this.channel.setOpt(0, (Object)true);
        this.disp = this.configuration.isUseRegionBasedMarshalling() ? new InactiveRegionAwareRpcDispatcher(this.channel, (MessageListener)this.messageListener, (MembershipListener)new MembershipListenerAdaptor(), this.remoteDelegate) : new RpcDispatcher(this.channel, (MessageListener)this.messageListener, (MembershipListener)new MembershipListenerAdaptor(), (Object)this.remoteDelegate);
        this.disp.setRequestMarshaller((RpcDispatcher.Marshaller)this.marshaller);
        this.disp.setResponseMarshaller((RpcDispatcher.Marshaller)this.marshaller);
    }

    private JChannel getMultiplexerChannel() throws CacheException {
        String stackName = this.configuration.getMultiplexerStack();
        RuntimeConfig rtc = this.configuration.getRuntimeConfig();
        ChannelFactory channelFactory = rtc.getMuxChannelFactory();
        JChannel muxchannel = null;
        if (channelFactory != null) {
            try {
                muxchannel = (JChannel)channelFactory.createMultiplexerChannel(stackName, this.configuration.getClusterName());
            }
            catch (Exception e) {
                throw new CacheException("Failed to create multiplexed channel using stack " + stackName, e);
            }
        }
        return muxchannel;
    }

    private void removeLocksForDeadMembers(NodeSPI node, List deadMembers) {
        HashSet<GlobalTransaction> deadOwners = new HashSet<GlobalTransaction>();
        NodeLock lock = node.getLock();
        Object owner = lock.getWriterOwner();
        if (this.isLockOwnerDead(owner, deadMembers)) {
            deadOwners.add((GlobalTransaction)owner);
        }
        for (Object object : lock.getReaderOwners()) {
            if (!this.isLockOwnerDead(object, deadMembers)) continue;
            deadOwners.add((GlobalTransaction)object);
        }
        for (GlobalTransaction globalTransaction : deadOwners) {
            boolean localTx;
            boolean broken = LockUtil.breakTransactionLock(lock, globalTransaction, localTx = globalTransaction.getAddress().equals(this.getLocalAddress()), this.txTable, this.txManager);
            if (!broken || !this.trace) continue;
            this.log.trace((Object)("Broke lock for node " + node.getFqn() + " held by " + globalTransaction));
        }
        for (Object object : node.getChildrenDirect()) {
            this.removeLocksForDeadMembers((NodeSPI)object, deadMembers);
        }
    }

    private boolean isLockOwnerDead(Object owner, List deadMembers) {
        boolean result = false;
        if (owner != null && owner instanceof GlobalTransaction) {
            Object addr = ((GlobalTransaction)owner).getAddress();
            result = deadMembers.contains(addr);
        }
        return result;
    }

    @Override
    public List<Object> callRemoteMethods(List<Address> recipients, MethodCall methodCall, int mode, boolean excludeSelf, long timeout, boolean useOutOfBandMessage) throws Exception {
        return this.callRemoteMethods(recipients, methodCall, mode, excludeSelf, timeout, null, useOutOfBandMessage);
    }

    @Override
    public List<Object> callRemoteMethods(List<Address> recipients, MethodCall methodCall, boolean synchronous, boolean excludeSelf, int timeout, boolean useOutOfBandMessage) throws Exception {
        return this.callRemoteMethods(recipients, methodCall, synchronous ? 2 : 6, excludeSelf, (long)timeout, useOutOfBandMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> callRemoteMethods(List<Address> recipients, MethodCall methodCall, int mode, boolean excludeSelf, long timeout, RspFilter responseFilter, boolean useOutOfBandMessage) throws Exception {
        RspList rsps;
        Address local_addr;
        Vector<Address> validMembers;
        int modeToUse = mode;
        int preferredMode = this.spi.getInvocationContext().getOptionOverrides().getGroupRequestMode();
        if (preferredMode > -1) {
            modeToUse = preferredMode;
        }
        if (this.disp == null) {
            return null;
        }
        if (recipients != null) {
            validMembers = new Vector<Address>(recipients);
        } else {
            List<Address> list = this.members;
            synchronized (list) {
                validMembers = new Vector<Address>(this.members);
            }
        }
        if (excludeSelf && !validMembers.isEmpty() && (local_addr = this.getLocalAddress()) != null) {
            validMembers.remove(local_addr);
        }
        if (validMembers.isEmpty()) {
            if (this.trace) {
                this.log.trace((Object)"destination list is empty, discarding call");
            }
            return null;
        }
        if (this.trace) {
            this.log.trace((Object)("callRemoteMethods(): valid members are " + validMembers + " methods: " + (Object)((Object)methodCall) + " Using OOB? " + useOutOfBandMessage));
        }
        if (this.channel.flushSupported() && !this.flushBlockGate.await(this.configuration.getStateRetrievalTimeout())) {
            throw new TimeoutException("State retrieval timed out waiting for flush unblock.");
        }
        RspList rspList = rsps = responseFilter == null ? this.disp.callRemoteMethods(validMembers, (org.jgroups.blocks.MethodCall)methodCall, modeToUse, timeout, this.isUsingBuddyReplication, useOutOfBandMessage) : this.disp.callRemoteMethods(validMembers, (org.jgroups.blocks.MethodCall)methodCall, modeToUse, timeout, this.isUsingBuddyReplication, useOutOfBandMessage, responseFilter);
        if (rsps == null) {
            throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + methodCall.getName() + " not being serializable.");
        }
        if (mode == 6) {
            return Collections.emptyList();
        }
        if (this.trace) {
            this.log.trace((Object)("(" + this.getLocalAddress() + "): responses for method " + methodCall.getName() + ":\n" + rsps));
        }
        ArrayList<Object> retval = new ArrayList<Object>(rsps.size());
        for (Rsp rsp : rsps.values()) {
            if (rsp.wasSuspected() || !rsp.wasReceived()) {
                CacheException ex = rsp.wasSuspected() ? new SuspectException("Suspected member: " + rsp.getSender()) : new TimeoutException("Replication timeout for " + rsp.getSender());
                retval.add(new ReplicationException("rsp=" + rsp, ex));
                continue;
            }
            Object value = rsp.getValue();
            if (value instanceof Exception && !(value instanceof ReplicationException)) {
                if (this.trace) {
                    this.log.trace((Object)("Recieved exception'" + value + "' from " + rsp.getSender()));
                }
                throw (Exception)value;
            }
            retval.add(value);
        }
        return retval;
    }

    private boolean isCommitMethod(MethodCall call) {
        return call.getMethodId() == 11 || call.getMethodId() == 13 && this.isCommitMethod((MethodCall)((Object)call.getArgs()[0]));
    }

    @Override
    public void fetchPartialState(List<Address> sources, Fqn sourceTarget, Fqn integrationTarget) throws Exception {
        String encodedStateId = sourceTarget + "_PARTIAL_STATE_DELIMITER" + integrationTarget;
        this.fetchPartialState(sources, encodedStateId);
    }

    @Override
    public void fetchPartialState(List<Address> sources, Fqn subtree) throws Exception {
        if (subtree == null) {
            throw new IllegalArgumentException("Cannot fetch partial state. Null subtree.");
        }
        this.fetchPartialState(sources, subtree.toString());
    }

    private void fetchPartialState(List<Address> sources, String stateId) throws Exception {
        if (sources == null || sources.isEmpty() || stateId == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Cannot fetch partial state, targets are " + sources + " and stateId is " + stateId));
            }
            return;
        }
        LinkedList<Address> targets = new LinkedList<Address>(sources);
        targets.remove(this.getLocalAddress());
        if (targets.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Cannot fetch partial state. There are no target members specified");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from members " + targets));
        }
        boolean successfulTransfer = false;
        for (Address target : targets) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target));
            }
            this.messageListener.setStateSet(false);
            successfulTransfer = this.channel.getState(target, stateId, this.configuration.getStateRetrievalTimeout());
            if (successfulTransfer) {
                try {
                    this.messageListener.waitForState();
                }
                catch (Exception transferFailed) {
                    successfulTransfer = false;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target + (successfulTransfer ? " successful" : " failed")));
            }
            if (!successfulTransfer) continue;
            break;
        }
        if (!successfulTransfer && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " could not fetch partial state " + stateId + " from any member " + targets));
        }
    }

    @Override
    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Address> getMembers() {
        if (this.isInLocalMode) {
            return null;
        }
        List<Address> list = this.members;
        synchronized (list) {
            return new ArrayList<Address>(this.members);
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getCoordinator() {
        if (this.channel == null) {
            return null;
        }
        List<Address> list = this.members;
        synchronized (list) {
            while (this.members.isEmpty()) {
                this.log.debug((Object)"getCoordinator(): waiting on viewAccepted()");
                try {
                    this.members.wait();
                }
                catch (InterruptedException e) {
                    this.log.error((Object)"getCoordinator(): Interrupted while waiting for members to be set", (Throwable)e);
                    break;
                }
            }
            return this.members.size() > 0 ? this.members.get(0) : null;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$jboss$cache$config$Configuration$CacheMode;

        static {
            $SwitchMap$org$jboss$cache$config$Configuration$CacheMode = new int[Configuration.CacheMode.values().length];
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.REPL_SYNC.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.REPL_ASYNC.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.INVALIDATION_ASYNC.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.INVALIDATION_SYNC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    protected class MembershipListenerAdaptor
    implements ExtendedMembershipListener {
        protected MembershipListenerAdaptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View new_view) {
            Vector new_mbrs = new_view.getMembers();
            if (RPCManagerImpl.this.log.isInfoEnabled()) {
                RPCManagerImpl.this.log.info((Object)("Received new cluster view: " + new_view));
            }
            List list = RPCManagerImpl.this.members;
            synchronized (list) {
                boolean needNotification = false;
                if (new_mbrs != null) {
                    Vector removed = new Vector(RPCManagerImpl.this.members);
                    removed.removeAll(new_mbrs);
                    RPCManagerImpl.this.removeLocksForDeadMembers(RPCManagerImpl.this.spi.getRoot(), removed);
                    RPCManagerImpl.this.members.clear();
                    RPCManagerImpl.this.members.addAll(new_mbrs);
                    needNotification = true;
                }
                RPCManagerImpl.this.coordinator = RPCManagerImpl.this.members.size() != 0 && ((Address)RPCManagerImpl.this.members.get(0)).equals(RPCManagerImpl.this.getLocalAddress());
                if (needNotification && RPCManagerImpl.this.notifier != null) {
                    InvocationContext ctx = RPCManagerImpl.this.spi.getInvocationContext();
                    RPCManagerImpl.this.notifier.notifyViewChange(new_view, ctx);
                }
                RPCManagerImpl.this.members.notifyAll();
            }
        }

        public void suspect(Address suspected_mbr) {
        }

        public void block() {
            RPCManagerImpl.this.flushBlockGate.close();
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("Block received at " + RPCManagerImpl.this.getLocalAddress()));
            }
            RPCManagerImpl.this.remoteDelegate.block();
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("Block processed at " + RPCManagerImpl.this.getLocalAddress()));
            }
        }

        public void unblock() {
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("UnBlock received at " + RPCManagerImpl.this.getLocalAddress()));
            }
            RPCManagerImpl.this.remoteDelegate.unblock();
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("UnBlock processed at " + RPCManagerImpl.this.getLocalAddress()));
            }
            RPCManagerImpl.this.flushBlockGate.open();
        }
    }
}

