/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.Version;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.factories.annotations.ComponentName;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.invocation.RemoteCacheInvocationDelegate;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.CachePrinter;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheImpl {
    private Log log = LogFactory.getLog(CacheImpl.class);
    private NodeSPI root;
    private RegionManager regionManager = null;
    private TransactionTable transactionTable;
    private final Set<Fqn> internalFqns = new HashSet<Fqn>();
    private Marshaller marshaller = null;
    private TransactionManager transactionManager = null;
    private CacheLoaderManager cacheLoaderManager;
    CacheStatus cacheStatus;
    private BuddyManager buddyManager;
    private RemoteCacheInvocationDelegate remoteDelegate;
    private Notifier notifier;
    private final Configuration configuration;
    private final ComponentRegistry componentRegistry;
    private NodeFactory nodeFactory;
    private CacheSPI spi;
    private Interceptor interceptorChain;
    private boolean trace;
    private Thread shutdownHook;
    private boolean invokedFromShutdownHook;
    private RPCManager rpcManager;

    protected CacheImpl() {
        this(new Configuration());
    }

    protected CacheImpl(Configuration configuration) {
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(configuration);
        this.cacheStatus = CacheStatus.INSTANTIATED;
    }

    protected ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Inject
    private void injectDependencies(Notifier notifier, RegionManager regionManager, TransactionManager transactionManager, Marshaller marshaller, TransactionTable transactionTable, NodeFactory nodeFactory, CacheSPI spi, @ComponentName(value="remoteDelegate") RemoteCacheInvocationDelegate remoteDelegate, Interceptor interceptorChain, BuddyManager buddyManager, RPCManager rpcManager) {
        this.notifier = notifier;
        this.regionManager = regionManager;
        this.transactionManager = transactionManager;
        this.transactionTable = transactionTable;
        this.nodeFactory = nodeFactory;
        this.spi = spi;
        this.remoteDelegate = remoteDelegate;
        this.marshaller = marshaller;
        this.interceptorChain = interceptorChain;
        this.buddyManager = buddyManager;
        this.rpcManager = rpcManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getVersion() {
        return Version.printVersion();
    }

    public NodeSPI getRoot() {
        return this.root;
    }

    public TransactionTable getTransactionTable() {
        return this.transactionTable;
    }

    private void setIsolationLevel(IsolationLevel level) {
        LockStrategyFactory.setIsolationLevel(level);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void create() throws CacheException {
        if (!this.cacheStatus.createAllowed()) {
            if (this.cacheStatus.needToDestroyFailedCache()) {
                this.destroy();
            } else {
                return;
            }
        }
        try {
            this.internalCreate();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    private void handleLifecycleTransitionFailure(Throwable t) throws RuntimeException, Error {
        this.cacheStatus = CacheStatus.FAILED;
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalCreate() throws CacheException {
        this.configureLogCategory();
        this.componentRegistry.wire();
        this.correctRootNodeType();
        this.setIsolationLevel(this.configuration.getIsolationLevel());
        this.cacheStatus = CacheStatus.CREATED;
    }

    private void correctRootNodeType() {
        NodeSPI tempRoot = this.nodeFactory.createRootDataNode();
        Class<?> currentRootType = this.root == null ? null : ((NodeInvocationDelegate)this.root).getDelegationTarget().getClass();
        Class<?> tempRootType = ((NodeInvocationDelegate)tempRoot).getDelegationTarget().getClass();
        if (!tempRootType.equals(currentRootType)) {
            this.root = tempRoot;
        }
    }

    public void start() throws CacheException {
        if (!this.cacheStatus.startAllowed()) {
            if (this.cacheStatus.needToDestroyFailedCache()) {
                this.destroy();
            }
            if (this.cacheStatus.needCreateBeforeStart()) {
                this.create();
            } else {
                return;
            }
        }
        try {
            this.internalStart();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    private void removeConfigurationDependentComponents() {
        this.componentRegistry.unregisterComponent(Interceptor.class);
        this.componentRegistry.unregisterComponent(Marshaller.class);
        this.componentRegistry.unregisterComponent(TransactionManager.class);
        this.componentRegistry.unregisterComponent(BuddyManager.class);
        this.componentRegistry.unregisterComponent(CacheLoaderManager.class);
    }

    private void internalStart() throws CacheException, IllegalArgumentException {
        this.removeConfigurationDependentComponents();
        this.componentRegistry.updateDependencies();
        this.componentRegistry.wireDependencies(this.root);
        this.cacheStatus = CacheStatus.STARTING;
        this.componentRegistry.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Interceptor chain is:\n" + CachePrinter.printInterceptorChain(this.interceptorChain)));
        }
        if (this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC && this.transactionManager == null) {
            this.log.fatal((Object)"No transaction manager lookup class has been defined. Transactions cannot be used and thus OPTIMISTIC locking cannot be used!  Expect errors!!");
        }
        this.correctRootNodeType();
        switch (this.configuration.getCacheMode()) {
            case LOCAL: {
                this.log.debug((Object)"cache mode is local, will not create the channel");
                break;
            }
            case REPL_SYNC: 
            case REPL_ASYNC: 
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                this.configureLogCategory();
                break;
            }
            default: {
                throw new IllegalArgumentException("cache mode " + (Object)((Object)this.configuration.getCacheMode()) + " is invalid");
            }
        }
        this.startManualComponents();
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.preloadCache();
        }
        if (this.regionManager.isUsingEvictions()) {
            this.regionManager.startEvictionThread();
        }
        this.notifier.notifyCacheStarted(this.spi, this.spi.getInvocationContext());
        this.addShutdownHook();
        this.log.info((Object)("JBoss Cache version: " + this.getVersion()));
        this.cacheStatus = CacheStatus.STARTED;
    }

    private void startManualComponents() {
        if (this.rpcManager != null) {
            this.rpcManager.start();
        }
        if (this.buddyManager != null) {
            this.buddyManager.init();
            if (this.buddyManager.isEnabled()) {
                this.internalFqns.add(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
            }
        }
    }

    private void addShutdownHook() {
        boolean registerShutdownHook;
        ArrayList<MBeanServer> al = MBeanServerFactory.findMBeanServer(null);
        boolean bl = registerShutdownHook = this.configuration.getShutdownHookBehavior() == Configuration.ShutdownHookBehavior.DEFAULT && al.size() == 0 || this.configuration.getShutdownHookBehavior() == Configuration.ShutdownHookBehavior.REGISTER;
        if (registerShutdownHook) {
            if (this.trace) {
                this.log.trace((Object)("Registering a shutdown hook.  Configured behavior = " + (Object)((Object)this.configuration.getShutdownHookBehavior())));
            }
            this.shutdownHook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        CacheImpl.this.invokedFromShutdownHook = true;
                        CacheImpl.this.stop();
                    }
                    finally {
                        CacheImpl.this.invokedFromShutdownHook = false;
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else if (this.trace) {
            this.log.trace((Object)("Not registering a shutdown hook.  Configured behavior = " + (Object)((Object)this.configuration.getShutdownHookBehavior())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.cacheStatus.destroyAllowed()) {
            if (this.cacheStatus.needStopBeforeDestroy()) {
                try {
                    this.stop();
                }
                catch (CacheException e) {
                    this.log.warn((Object)"Needed to call stop() before destroying but stop() threw exception. Proceeding to destroy", (Throwable)e);
                }
            } else {
                return;
            }
        }
        try {
            this.internalDestroy();
        }
        finally {
            this.cacheStatus = CacheStatus.DESTROYED;
        }
    }

    private void internalDestroy() {
        this.cacheStatus = CacheStatus.DESTROYING;
        this.cacheLoaderManager = null;
        this.rpcManager.stop();
        this.transactionManager = null;
        this.componentRegistry.reset();
    }

    public void stop() {
        if (!this.cacheStatus.stopAllowed()) {
            return;
        }
        boolean failed = this.cacheStatus == CacheStatus.FAILED;
        try {
            this.internalStop();
        }
        catch (Throwable t) {
            if (failed) {
                this.log.warn((Object)"Attempted to stop() from FAILED state, but caught exception; try calling destroy()", t);
            }
            this.handleLifecycleTransitionFailure(t);
        }
    }

    private void internalStop() {
        this.cacheStatus = CacheStatus.STOPPING;
        if (!this.invokedFromShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.componentRegistry.stop();
        if (this.notifier != null) {
            this.notifier.notifyCacheStopped(this.spi, this.spi.getInvocationContext());
            this.notifier.removeAllCacheListeners();
        }
        this.transactionManager = null;
        this.cacheStatus = CacheStatus.STOPPED;
        this.root.clearDataDirect();
        this.root.removeChildrenDirect();
    }

    public CacheStatus getCacheStatus() {
        return this.cacheStatus;
    }

    public Set<Fqn> getInternalFqns() {
        return Collections.unmodifiableSet(this.internalFqns);
    }

    protected void _evictSubtree(Fqn subtree) throws CacheException {
        Set children;
        if (!this.exists(subtree)) {
            return;
        }
        if (this.trace) {
            this.log.trace((Object)("_evictSubtree(" + subtree + ")"));
        }
        if ((children = this.spi.getChildrenNames(subtree)) != null) {
            for (Object s : children) {
                Fqn<Object> tmp = new Fqn<Object>(subtree, s);
                this._remove(null, tmp, false, true, true);
            }
        }
        this._remove(null, subtree, false, true, true);
    }

    public Node _get(Fqn<?> fqn) throws CacheException {
        return this.findNode(fqn);
    }

    public Map _getData(Fqn<?> fqn) {
        NodeSPI n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getDataDirect();
    }

    public Set _getKeys(Fqn<?> fqn) throws CacheException {
        NodeSPI n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Set keys = n.getKeysDirect();
        return new HashSet(keys);
    }

    public Object _get(Fqn<?> fqn, Object key, boolean sendNodeEvent) throws CacheException {
        NodeSPI n;
        InvocationContext ctx = this.spi.getInvocationContext();
        if (this.trace) {
            this.log.trace((Object)new StringBuffer("_get(").append("\"").append(fqn).append("\", \"").append(key).append("\", \"").append(sendNodeEvent).append("\")"));
        }
        if (sendNodeEvent) {
            this.notifier.notifyNodeVisited(fqn, true, ctx);
        }
        if ((n = this.findNode(fqn)) == null) {
            this.log.trace((Object)"node not found");
            return null;
        }
        if (sendNodeEvent) {
            this.notifier.notifyNodeVisited(fqn, false, ctx);
        }
        return n.getDirect(key);
    }

    public boolean exists(String fqn) {
        return this.exists(Fqn.fromString(fqn));
    }

    public boolean exists(Fqn<?> fqn) {
        NodeSPI n = this.peek(fqn, false);
        return n != null;
    }

    public NodeSPI peek(Fqn<?> fqn, boolean includeDeletedNodes) {
        return this.peek(fqn, includeDeletedNodes, false);
    }

    public NodeSPI peek(Fqn<?> fqn, boolean includeDeletedNodes, boolean includeInvalidNodes) {
        if (fqn == null || fqn.size() == 0) {
            return this.root;
        }
        NodeSPI n = this.root;
        int fqnSize = fqn.size();
        for (int i = 0; i < fqnSize; ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChildDirect(obj)) == null) {
                return null;
            }
            if (!includeDeletedNodes && n.isDeleted()) {
                return null;
            }
            if (includeInvalidNodes || n.isValid()) continue;
            return null;
        }
        return n;
    }

    public boolean exists(String fqn, Object key) {
        return this.exists(Fqn.fromString(fqn), key);
    }

    public boolean exists(Fqn<?> fqn, Object key) {
        NodeSPI n = this.peek(fqn, false);
        return n != null && n.getKeysDirect().contains(key);
    }

    public <E> Set<E> _getChildrenNames(Fqn<E> fqn) throws CacheException {
        NodeSPI n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        HashSet childNames = new HashSet();
        Map childrenMap = n.getChildrenMapDirect();
        if (childrenMap == null || childrenMap.isEmpty()) {
            return Collections.emptySet();
        }
        Collection s = childrenMap.values();
        for (Node c : s) {
            NodeSPI child = (NodeSPI)c;
            if (child.isDeleted()) continue;
            Object e = child.getFqn().getLastElement();
            childNames.add(e);
        }
        return childNames;
    }

    public boolean hasChild(Fqn fqn) {
        if (fqn == null) {
            return false;
        }
        NodeSPI n = this.findNode(fqn);
        return n != null && n.hasChildrenDirect();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        if (!details) {
            sb.append(this.getClass().getName()).append(" [").append(this.getNumberOfNodes()).append(" nodes, ");
            sb.append(this.getNumberOfLocksHeld()).append(" locks]");
        } else {
            if (this.root == null) {
                return sb.toString();
            }
            for (NodeSPI n : this.root.getChildrenDirect()) {
                n.print(sb, indent);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuffer sb = new StringBuffer();
        this.root.printDetails(sb, 0);
        sb.append("\n");
        return sb.toString();
    }

    public String printLockInfo() {
        StringBuffer sb = new StringBuffer("\n");
        int indent = 0;
        for (NodeSPI n : this.root.getChildrenDirect()) {
            n.getLock().printLockInfo(sb, indent);
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getNumberOfLocksHeld() {
        return this.numLocks(this.root);
    }

    private int numLocks(NodeSPI n) {
        int num = 0;
        if (n != null) {
            if (n.getLock().isLocked()) {
                ++num;
            }
            for (NodeSPI cn : n.getChildrenDirect(true)) {
                num += this.numLocks(cn);
            }
        }
        return num;
    }

    public int getNumberOfNodes() {
        return this.numNodes(this.root) - 1;
    }

    private int numNodes(NodeSPI n) {
        int count = 1;
        if (n != null) {
            for (NodeSPI child : n.getChildrenDirect()) {
                count += this.numNodes(child);
            }
        }
        return count;
    }

    public int getNumberOfAttributes() {
        return this.numAttributes(this.root);
    }

    public int getNumberOfAttributes(Fqn fqn) {
        return this.numAttributes(this.findNode(fqn));
    }

    private int numAttributes(NodeSPI n) {
        int count = 0;
        for (NodeSPI child : n.getChildrenDirect()) {
            count += this.numAttributes(child);
        }
        return count += n.getDataDirect().size();
    }

    public void _putForExternalRead(GlobalTransaction gtx, Fqn fqn, Object key, Object value, DataVersion dv) throws CacheException {
        this._putForExternalRead(gtx, fqn, key, value);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops, DataVersion dv) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, false, dv);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops, boolean erase_contents, DataVersion dv) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, erase_contents);
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._put(tx, fqn, key, value, create_undo_ops);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, true);
    }

    public Object _remove(GlobalTransaction tx, Fqn fqn, Object key, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._remove(tx, fqn, key, create_undo_ops);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, DataVersion dv) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, true);
    }

    public void _put(GlobalTransaction tx, String fqn, Map data, boolean create_undo_ops) throws CacheException {
        this._put(tx, Fqn.fromString(fqn), data, create_undo_ops);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, false);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map data, boolean create_undo_ops, boolean erase_contents) throws CacheException {
        if (this.trace) {
            this.log.trace((Object)("_put(" + tx + ", \"" + fqn + "\", " + data + " undo=" + create_undo_ops + " erase=" + erase_contents + ")"));
        }
        InvocationContext ctx = this.spi.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        NodeSPI n = this.findNodeCheck(tx, fqn, isRollback);
        Map rawData = n.getDataDirect();
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.PUT_MAP, rawData, ctx);
        }
        if (tx != null && create_undo_ops) {
            MethodCall undo_op = MethodCallFactory.create(2, tx, fqn, new HashMap(rawData), false, true);
            this.transactionTable.addUndoOperation(tx, undo_op);
        }
        if (erase_contents) {
            n.clearDataDirect();
        }
        n.putAllDirect(data);
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.PUT_MAP, n.getDataDirect(), ctx);
        }
    }

    public Object _put(GlobalTransaction tx, String fqn, Object key, Object value, boolean create_undo_ops) throws CacheException {
        return this._put(tx, Fqn.fromString(fqn), key, value, create_undo_ops);
    }

    private boolean checkIsRollingBack(Transaction tx) {
        try {
            return tx != null && (tx.getStatus() == 4 || tx.getStatus() == 9 || tx.getStatus() == 1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, Object key, Object value, boolean create_undo_ops) throws CacheException {
        if (this.trace) {
            this.log.trace((Object)new StringBuffer("_put(").append(tx).append(", \"").append(fqn).append("\", k=").append(key).append(", v=").append(value).append(")"));
        }
        InvocationContext ctx = this.spi.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        NodeSPI n = this.findNodeCheck(tx, fqn, isRollback);
        Map rawData = n.getDataDirect();
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.PUT_DATA, rawData, ctx);
        }
        Object old_value = n.putDirect(key, value);
        if (tx != null && create_undo_ops) {
            MethodCall undo_op = old_value == null ? MethodCallFactory.create(6, tx, fqn, key, false) : MethodCallFactory.create(3, tx, fqn, key, old_value, false);
            this.transactionTable.addUndoOperation(tx, undo_op);
        }
        Map<Object, Object> newData = Collections.singletonMap(key, value);
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.PUT_DATA, newData, ctx);
        }
        return old_value;
    }

    public void _remove(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._remove(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, true);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, sendNodeEvent, eviction, null);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean skipSendingNodeEvents, boolean eviction, DataVersion version) throws CacheException {
        boolean found;
        NodeSPI n;
        if (this.trace) {
            this.log.trace((Object)("_remove(" + tx + ", \"" + fqn + "\", undo=" + create_undo_ops + ")"));
        }
        InvocationContext ctx = this.spi.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (tx != null) {
            try {
                if (isRollback) {
                    this.log.trace((Object)"This remove call is triggered by a transaction rollback, as a compensation operation.  Do a realRemove() instead.");
                    return this.realRemove(fqn, true);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)"Unable to get a hold of the transaction for a supposedly transactional call!  This *may* result in stale locks!", (Throwable)e);
            }
        }
        if ((n = this.findNode(fqn, version, true)) == null) {
            if (this.trace) {
                this.log.trace((Object)("node " + fqn + " not found"));
            }
            return false;
        }
        if (!isRollback && !skipSendingNodeEvents) {
            if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, true, ctx);
            } else {
                this.notifier.notifyNodeRemoved(fqn, true, n.getDataDirect(), ctx);
            }
        }
        NodeSPI parent_node = n.getParent();
        if (eviction || this.configuration.isNodeLockingOptimistic()) {
            found = n.isValid() && parent_node == null ? fqn.isRoot() : parent_node.removeChildDirect(n.getFqn().getLastElement());
        } else {
            found = n.isValid() && !n.isDeleted();
            n.markAsDeleted(true, true);
        }
        if (eviction && parent_node != null) {
            parent_node.setChildrenLoaded(false);
        }
        if (tx != null && create_undo_ops && !eviction && found) {
            MethodCall undo_op = MethodCallFactory.create(15, tx, parent_node.getFqn(), n.getFqn().getLastElement(), n, false);
            this.transactionTable.addUndoOperation(tx, undo_op);
        }
        if (!isRollback && !skipSendingNodeEvents) {
            if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, false, ctx);
            } else {
                this.notifier.notifyNodeRemoved(fqn, false, null, ctx);
            }
        }
        return found;
    }

    public Object _remove(GlobalTransaction tx, String fqn, Object key, boolean create_undo_ops) throws CacheException {
        return this._remove(tx, Fqn.fromString(fqn), key, create_undo_ops);
    }

    public Object _remove(GlobalTransaction tx, Fqn fqn, Object key, boolean create_undo_ops) throws CacheException {
        NodeSPI n;
        if (this.trace) {
            this.log.trace((Object)("_remove(" + tx + ", \"" + fqn + "\", key=" + key + ")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            this.log.warn((Object)("node " + fqn + " not found"));
            return null;
        }
        InvocationContext ctx = this.spi.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, n.getDataDirect(), ctx);
        }
        Object old_value = n.removeDirect(key);
        if (tx != null && create_undo_ops && old_value != null) {
            MethodCall undo_op = MethodCallFactory.create(3, tx, fqn, key, old_value, false);
            this.transactionTable.addUndoOperation(tx, undo_op);
        }
        Map removedData = Collections.singletonMap(key, old_value);
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, removedData, ctx);
        }
        return old_value;
    }

    public void _removeData(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, true);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, sendNodeEvent, eviction, null);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction, DataVersion version) throws CacheException {
        NodeSPI n;
        MethodCall undo_op = null;
        if (this.trace) {
            this.log.trace((Object)("_removeData(" + tx + ", \"" + fqn + "\")"));
        }
        if ((n = this.findNode(fqn, version)) == null) {
            this.log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        Map data = n.getDataDirect();
        InvocationContext ctx = this.spi.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (tx != null && create_undo_ops && !eviction && !data.isEmpty()) {
            undo_op = MethodCallFactory.create(1, tx, fqn, new HashMap(data), false);
        }
        if (!isRollback) {
            if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, true, ctx);
            } else {
                this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
            }
        }
        n.clearDataDirect();
        if (eviction) {
            n.setDataLoaded(false);
        }
        if (!isRollback) {
            if (sendNodeEvent) {
                this.notifier.notifyNodeVisited(fqn, false, ctx);
            } else if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, false, ctx);
            } else {
                this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
            }
        }
        if (tx != null && create_undo_ops) {
            this.transactionTable.addUndoOperation(tx, undo_op);
        }
    }

    public boolean _evict(Fqn fqn) throws CacheException {
        if (this.peek(fqn, false, true) == null) {
            return true;
        }
        boolean create_undo_ops = false;
        boolean sendNodeEvent = false;
        boolean eviction = true;
        if (this.trace) {
            this.log.trace((Object)("_evict(" + fqn + ")"));
        }
        if (this.hasChild(fqn)) {
            this._removeData(null, fqn, create_undo_ops, sendNodeEvent, eviction);
            return false;
        }
        this._remove(null, fqn, create_undo_ops, sendNodeEvent, eviction);
        return true;
    }

    public boolean _evict(Fqn fqn, DataVersion version) throws CacheException {
        if (!this.exists(fqn)) {
            return true;
        }
        if (this.trace) {
            this.log.trace((Object)("_evict(" + fqn + ", " + version + ")"));
        }
        if (this.hasChild(fqn)) {
            this._removeData(null, fqn, false, false, true, version);
            return false;
        }
        this._remove(null, fqn, false, true, true, version);
        return true;
    }

    public void invalidate(Fqn fqn, DataVersion versionToInvalidate) {
        NodeSPI node = this.spi.getNode(fqn);
        if (node == null) {
            if (!this.configuration.isNodeLockingOptimistic()) {
                return;
            }
            NodeSPI nodeSPI = this.peek(fqn, false, true);
            if (nodeSPI == null) {
                if (versionToInvalidate == null) {
                    if (this.trace) {
                        this.log.trace((Object)"Would have created a tombstone since the node doesn't exist, but the version to invalidate is null and hence cannot create a tombstone!");
                    }
                    return;
                }
                if (this.trace) {
                    this.log.trace((Object)("Node doesn't exist; creating a tombstone with data version " + versionToInvalidate));
                }
                Map m = Collections.emptyMap();
                InvocationContext ic = this.spi.getInvocationContext();
                Option o = ic.getOptionOverrides();
                boolean origCacheModeLocal = o.isCacheModeLocal();
                o.setCacheModeLocal(true);
                o.setDataVersion(versionToInvalidate);
                try {
                    Transaction suspended = null;
                    if (this.getTransactionManager() != null) {
                        suspended = this.getTransactionManager().suspend();
                    }
                    this.spi.put(fqn, m);
                    if (suspended != null) {
                        this.getTransactionManager().resume(suspended);
                    }
                    ic.getOptionOverrides().setCacheModeLocal(origCacheModeLocal);
                }
                catch (Exception e) {
                    this.log.error((Object)"Unable to create tombstone!", (Throwable)e);
                }
                nodeSPI = (NodeSPI)this.root.getChild(fqn);
            }
            node = nodeSPI;
        }
        if (this.configuration.isNodeLockingOptimistic()) {
            this._removeData(null, fqn, false, false, true, versionToInvalidate);
        } else {
            this._evict(fqn);
        }
        node.setValid(false, true);
        if (versionToInvalidate != null) {
            NodeSPI n = this.peek(fqn, false, true);
            n.setVersion(versionToInvalidate);
        }
    }

    public void _addChild(GlobalTransaction gtx, Fqn parent_fqn, Object child_name, Node cn, boolean undoOps) throws CacheException {
        NodeSPI childNode = (NodeSPI)cn;
        if (this.trace) {
            this.log.trace((Object)("_addChild(\"" + parent_fqn + "\", \"" + child_name + "\", node=" + childNode + ")"));
        }
        if (parent_fqn == null || child_name == null || childNode == null) {
            this.log.error((Object)"parent_fqn or child_name or childNode was null");
            return;
        }
        NodeSPI parentNode = this.findNode(parent_fqn);
        if (parentNode == null) {
            this.log.warn((Object)("node " + parent_fqn + " not found"));
            return;
        }
        InvocationContext ctx = this.spi.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        Fqn<Object> fqn = new Fqn<Object>(parent_fqn, child_name);
        if (!isRollback) {
            this.notifier.notifyNodeCreated(fqn, true, ctx);
        }
        parentNode.addChild(child_name, childNode);
        childNode.markAsDeleted(false, true);
        childNode.setValid(true, true);
        if (gtx != null && undoOps) {
            this.transactionTable.addUndoOperation(gtx, MethodCallFactory.create(5, gtx, fqn, false, false));
        }
        if (!isRollback) {
            this.notifier.notifyNodeCreated(fqn, false, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GravitateResult gravitateData(Fqn fqn, boolean searchSubtrees) throws CacheException {
        InvocationContext ctx = this.spi.getInvocationContext();
        if (this.trace) {
            this.log.trace((Object)("Caller is asking for " + fqn));
        }
        try {
            Object backupSubtree;
            ctx.setOriginLocal(false);
            ctx.getOptionOverrides().setSkipDataGravitation(true);
            NodeSPI actualNode = this.spi.getNode(fqn);
            ctx.getOptionOverrides().setSkipDataGravitation(false);
            if (this.trace) {
                this.log.trace((Object)("In local tree, this is " + actualNode));
            }
            Fqn backupNodeFqn = null;
            if (actualNode == null && searchSubtrees) {
                Set<Object> childNames;
                this.log.trace((Object)"Looking at backup trees.");
                backupSubtree = this.findNode(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
                if (backupSubtree != null && (childNames = backupSubtree.getChildrenNamesDirect()) != null) {
                    for (Object childName : childNames) {
                        backupNodeFqn = BuddyManager.getBackupFqn(childName.toString(), fqn);
                        ctx.getOptionOverrides().setSkipDataGravitation(true);
                        actualNode = this.spi.getNode(backupNodeFqn);
                        ctx.getOptionOverrides().setSkipDataGravitation(false);
                        if (this.trace) {
                            this.log.trace((Object)("Looking for " + backupNodeFqn + ". Search result: " + actualNode));
                        }
                        if (actualNode == null) continue;
                        break;
                    }
                }
            }
            if (actualNode == null) {
                backupSubtree = GravitateResult.noDataFound();
                return backupSubtree;
            }
            actualNode.getData();
            if (backupNodeFqn == null && searchSubtrees) {
                backupNodeFqn = BuddyManager.getBackupFqn(BuddyManager.getGroupNameFromAddress(this.rpcManager.getLocalAddress()), fqn);
            }
            List<NodeData> list = this.getNodeData(new LinkedList<NodeData>(), actualNode);
            GravitateResult gravitateResult = GravitateResult.subtreeResult(list, backupNodeFqn);
            return gravitateResult;
        }
        finally {
            ctx.setOriginLocal(true);
        }
    }

    private List<NodeData> getNodeData(List<NodeData> list, NodeSPI node) {
        NodeData data = new NodeData(BuddyManager.getActualFqn(node.getFqn()), node.getDataDirect());
        list.add(data);
        for (NodeSPI childNode : node.getChildrenDirect()) {
            this.getNodeData(list, childNode);
        }
        return list;
    }

    public void _releaseAllLocks(Fqn fqn) {
        try {
            NodeSPI n = this.findNode(fqn);
            if (n == null) {
                this.log.error((Object)("releaseAllLocks(): node " + fqn + " not found"));
                return;
            }
            this.releaseAll(n);
        }
        catch (Throwable t) {
            this.log.error((Object)"releaseAllLocks(): failed", t);
        }
    }

    private void releaseAll(NodeSPI n) {
        for (NodeSPI child : n.getChildrenDirect()) {
            this.releaseAll(child);
        }
        n.getLock().releaseAll();
    }

    public String _print(Fqn fqn) {
        try {
            NodeSPI n = this.findNode(fqn);
            if (n == null) {
                return null;
            }
            return n.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void _lock(Fqn fqn, NodeLock.LockType lock_type, boolean recursive) throws TimeoutException, LockingException {
        throw new UnsupportedOperationException("method _lock() should not be invoked on CacheImpl");
    }

    public void optimisticPrepare(GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) {
        throw new UnsupportedOperationException("optimisticPrepare() should not be called on CacheImpl directly");
    }

    public void prepare(GlobalTransaction global_tx, List modifications, Address coord, boolean onePhaseCommit) {
        throw new UnsupportedOperationException("prepare() should not be called on CacheImpl directly");
    }

    public void commit(GlobalTransaction tx) {
        throw new UnsupportedOperationException("commit() should not be called on CacheImpl directly");
    }

    public void rollback(GlobalTransaction tx) {
        throw new UnsupportedOperationException("rollback() should not be called on CacheImpl directly");
    }

    public void addUndoOperation(GlobalTransaction gtx, MethodCall undo_op) {
        this.transactionTable.addUndoOperation(gtx, undo_op);
    }

    public void _move(Fqn nodeToMoveFqn, Fqn newParentFqn) {
        NodeSPI newParent = this.findNode(newParentFqn);
        if (newParent == null) {
            throw new NodeNotExistsException("New parent node " + newParentFqn + " does not exist when attempting to move node!!");
        }
        NodeSPI node = this.findNode(nodeToMoveFqn);
        if (node == null) {
            throw new NodeNotExistsException("Node " + nodeToMoveFqn + " does not exist when attempting to move node!!");
        }
        NodeSPI oldParent = node.getParent();
        Object nodeName = nodeToMoveFqn.getLastElement();
        oldParent.removeChildDirect(nodeName);
        newParent.addChild(nodeName, node);
        InvocationContext ctx = this.spi.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (!isRollback) {
            this.notifier.notifyNodeMoved(nodeToMoveFqn, new Fqn<Object>(newParentFqn, nodeToMoveFqn.getLastElement()), true, ctx);
        }
        this.moveFqns(node, newParent.getFqn());
        if (!isRollback) {
            this.notifier.notifyNodeMoved(nodeToMoveFqn, new Fqn<Object>(newParentFqn, nodeToMoveFqn.getLastElement()), false, ctx);
        }
        if (ctx.getTransaction() != null) {
            MethodCall undo = MethodCallFactory.create(36, new Fqn<Object>(newParentFqn, nodeToMoveFqn.getLastElement()), oldParent.getFqn());
            this.transactionTable.addUndoOperation(ctx.getGlobalTransaction(), undo);
        }
    }

    public void _block() {
    }

    public void _unblock() {
    }

    private void moveFqns(NodeSPI node, Fqn newBase) {
        Fqn<Object> newFqn = new Fqn<Object>(newBase, node.getFqn().getLastElement());
        node.setFqn(newFqn);
    }

    private void configureLogCategory() {
        StringBuilder category = new StringBuilder(this.getClass().getName());
        if (this.configuration != null) {
            if (this.rpcManager != null) {
                String clusterName = this.configuration.getClusterName();
                if (clusterName != null) {
                    category.append('.');
                    category.append(clusterName);
                    if (this.rpcManager.getLocalAddress() != null) {
                        category.append('.');
                        category.append(this.rpcManager.getLocalAddress().toString().replace('.', '_'));
                    }
                }
            } else {
                category.append("_LOCAL");
            }
        }
        this.log = LogFactory.getLog((String)category.toString());
        this.trace = this.log.isTraceEnabled();
    }

    protected Transaction getLocalTransaction() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            return this.transactionManager.getTransaction();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean isValid(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 0 || status == 7;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    public GlobalTransaction getCurrentTransaction() {
        return this.getCurrentTransaction(true);
    }

    public GlobalTransaction getCurrentTransaction(boolean createIfNotExists) {
        Transaction tx = this.getLocalTransaction();
        if (tx == null) {
            return null;
        }
        if (!this.isValid(tx)) {
            int status = -1;
            try {
                status = tx.getStatus();
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (status != 3) {
                this.log.warn((Object)("status is " + status + " (not ACTIVE or PREPARING); returning null)"), new Throwable());
            } else {
                this.log.trace((Object)"status is COMMITTED; returning null");
            }
            return null;
        }
        return this.getCurrentTransaction(tx, createIfNotExists);
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx) {
        return this.getCurrentTransaction(tx, true);
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx, boolean createIfNotExists) {
        GlobalTransaction gtx = this.transactionTable.get(tx);
        if (gtx == null && createIfNotExists) {
            Address addr = this.rpcManager.getLocalAddress();
            gtx = GlobalTransaction.create(addr);
            this.transactionTable.put(tx, gtx);
            TransactionEntry ent = null;
            try {
                ent = this.configuration.isNodeLockingOptimistic() ? new OptimisticTransactionEntry(tx) : new TransactionEntry(tx);
            }
            catch (Exception e) {
                throw new CacheException("Unable to create a transaction entry!", e);
            }
            this.transactionTable.put(gtx, ent);
            if (this.trace) {
                this.log.trace((Object)("created new GTX: " + gtx + ", local TX=" + tx));
            }
        }
        return gtx;
    }

    protected Object getOwnerForLock() {
        Object owner = this.getCurrentTransaction();
        if (owner == null) {
            owner = Thread.currentThread();
        }
        return owner;
    }

    public NodeSPI findNode(Fqn fqn) {
        try {
            return this.findNode(fqn, null);
        }
        catch (CacheException e) {
            this.log.warn((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    private NodeSPI findNodeCheck(GlobalTransaction tx, Fqn fqn, boolean includeInvalid) {
        NodeSPI n = this.findNode(fqn, null, includeInvalid);
        if (n == null) {
            String errStr = "node " + fqn + " not found (gtx=" + tx + ", caller=" + Thread.currentThread() + ")";
            if (this.trace) {
                this.log.trace((Object)errStr);
            }
            throw new NodeNotExistsException(errStr);
        }
        return n;
    }

    public boolean realRemove(Fqn f, boolean skipMarkerCheck) {
        NodeSPI n = this.peek(f, true);
        if (n == null) {
            return false;
        }
        if (this.trace) {
            this.log.trace((Object)("Performing a real remove for node " + f + ", marked for removal."));
        }
        if (skipMarkerCheck || n.isDeleted()) {
            if (n.getFqn().isRoot()) {
                n.markAsDeleted(true);
                n.removeChildrenDirect();
                n.setValid(false, true);
                n.setValid(true, false);
                return true;
            }
            n.setValid(false, true);
            return n.getParent().removeChildDirect(n.getFqn().getLastElement());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + f + " NOT marked for removal as expected, not removing!"));
        }
        return false;
    }

    private NodeSPI findNode(Fqn fqn, DataVersion version) {
        return this.findNode(fqn, version, false);
    }

    private NodeSPI findNode(Fqn fqn, DataVersion version, boolean includeInvalidNodes) {
        if (fqn == null) {
            return null;
        }
        NodeSPI toReturn = this.peek(fqn, false, includeInvalidNodes);
        if (toReturn != null && version != null && this.configuration.isNodeLockingOptimistic()) {
            DataVersion nodeVersion = toReturn.getVersion();
            if (this.trace) {
                this.log.trace((Object)("looking for optimistic node [" + fqn + "] with version [" + version + "].  My version is [" + nodeVersion + "]"));
            }
            if (nodeVersion.newerThan(version)) {
                throw new CacheException("Unable to validate versions.");
            }
        }
        return toReturn;
    }

    public List<Interceptor> getInterceptorChain() {
        List<Interceptor> modifiable = this.getInterceptors();
        return modifiable == null ? null : Collections.unmodifiableList(modifiable);
    }

    private List<Interceptor> getInterceptors() {
        return InterceptorChainFactory.asList(this.interceptorChain);
    }

    private void setInterceptorChain(Interceptor startOfNewChain) {
        this.componentRegistry.registerComponent(Interceptor.class.getName(), startOfNewChain, Interceptor.class);
    }

    public synchronized void addInterceptor(Interceptor i, int position) {
        List<Interceptor> interceptors = this.getInterceptors();
        InterceptorChainFactory factory = this.componentRegistry.getComponent(InterceptorChainFactory.class);
        interceptors.add(position, i);
        Interceptor linkedChain = factory.correctInterceptorChaining(interceptors);
        this.setInterceptorChain(linkedChain);
    }

    public synchronized void removeInterceptor(int position) {
        InterceptorChainFactory factory = this.componentRegistry.getComponent(InterceptorChainFactory.class);
        List<Interceptor> i = this.getInterceptors();
        i.remove(position);
        this.setInterceptorChain(factory.correctInterceptorChaining(i));
    }

    public synchronized void removeInterceptor(Class<? extends Interceptor> interceptorType) {
        InterceptorChainFactory factory = this.componentRegistry.getComponent(InterceptorChainFactory.class);
        List<Interceptor> interceptors = this.getInterceptors();
        int position = -1;
        boolean found = false;
        for (Interceptor interceptor : interceptors) {
            ++position;
            if (!interceptor.getClass().equals(interceptorType)) continue;
            found = true;
            break;
        }
        if (found) {
            interceptors.remove(position);
            this.setInterceptorChain(factory.correctInterceptorChaining(interceptors));
        }
    }

    public synchronized void addInterceptor(Interceptor i, Class<? extends Interceptor> afterInterceptor) {
        InterceptorChainFactory factory = this.componentRegistry.getComponent(InterceptorChainFactory.class);
        List<Interceptor> interceptors = this.getInterceptors();
        int position = -1;
        boolean found = false;
        for (Interceptor interceptor : interceptors) {
            ++position;
            if (!interceptor.getClass().equals(afterInterceptor)) continue;
            found = true;
            break;
        }
        if (found) {
            this.componentRegistry.registerComponent(i, Interceptor.class);
            interceptors.add(++position, i);
            this.setInterceptorChain(factory.correctInterceptorChaining(interceptors));
            this.componentRegistry.start();
            this.startManualComponents();
        }
    }

    public RPCManager getRPCManager() {
        return this.configuration.getRuntimeConfig().getRPCManager();
    }

    public String getClusterName() {
        return this.getConfiguration().getClusterName();
    }

    public Region getRegion(Fqn<?> fqn, boolean createIfAbsent) {
        return this.regionManager.getRegion(fqn, createIfAbsent);
    }

    public boolean removeRegion(Fqn<?> fqn) {
        return this.regionManager.removeRegion(fqn);
    }

    public void _putForExternalRead(GlobalTransaction gtx, Fqn fqn, Object key, Object value) {
        this._put(gtx, fqn, key, value, true);
    }
}

