/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security.helpers;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.helpers.SecurityActions;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.jboss.security.javaee.SecurityRoleRef;

public class EJBContextHelper {
    public Principal getCallerPrincipal(SecurityContext sc, RealmMapping rm, SecurityDomain domain) {
        String unauth;
        Principal callerPrincipal = null;
        if (sc == null) {
            unauth = domain.unauthenticatedPrincipal();
            if (unauth != null && unauth.length() > 0 && domain.unauthenticatedPrincipal() != null) {
                callerPrincipal = new SimplePrincipal(unauth);
            }
        } else {
            AbstractEJBAuthorizationHelper helper;
            try {
                helper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)sc);
                helper.setPolicyRegistration(this.getPolicyRegistration());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            callerPrincipal = helper.getCallerPrincipal();
        }
        if (callerPrincipal == null) {
            callerPrincipal = sc.getUtil().getUserPrincipal();
            if (rm != null) {
                callerPrincipal = rm.getPrincipal(callerPrincipal);
            }
        }
        if (callerPrincipal == null && (unauth = domain.unauthenticatedPrincipal()) != null && unauth.length() > 0 && domain.unauthenticatedPrincipal() != null) {
            callerPrincipal = new SimplePrincipal(unauth);
        }
        return callerPrincipal;
    }

    public boolean isCallerInRole(SecurityContext sc, SecurityDomain domain, RealmMapping rm, JBossEnterpriseBeanMetaData eb, String roleName, String ejbName) {
        AbstractEJBAuthorizationHelper helper;
        SecurityRoleRefsMetaData srf;
        if (sc == null) {
            try {
                sc = SecurityActions.createSecurityContext(domain.value());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        HashSet roleRefs = new HashSet();
        if (eb != null && (srf = eb.getSecurityRoleRefs()) != null) {
            roleRefs.addAll(srf);
        }
        HashSet<SecurityRoleRef> srset = new HashSet<SecurityRoleRef>();
        for (SecurityRoleRefMetaData srmd : roleRefs) {
            srset.add(new SecurityRoleRef(srmd.getRoleName(), srmd.getRoleLink(), null));
        }
        Principal principal = this.getCallerPrincipal(sc, rm, domain);
        try {
            helper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)sc);
            helper.setPolicyRegistration(this.getPolicyRegistration());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Subject callerSubject = null;
        try {
            callerSubject = SecurityActions.getActiveSubject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return helper.isCallerInRole(roleName, ejbName, principal, callerSubject, this.getContextID(), srset);
    }

    private PolicyRegistration getPolicyRegistration() {
        PolicyRegistration policyRegistration = null;
        try {
            InitialContext ic = new InitialContext();
            policyRegistration = (PolicyRegistration)ic.lookup("java:/policyRegistration");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return policyRegistration;
    }

    private String getContextID() {
        try {
            return PolicyContext.getContextID();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

