/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSessionPool;
import javax.jms.TransactionInProgressException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.JBossConnectionConsumer;
import org.jboss.jms.client.container.ClientConsumer;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.delegate.DefaultCancel;
import org.jboss.jms.delegate.DeliveryInfo;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.BytesMessageProxy;
import org.jboss.jms.message.JBossBytesMessage;
import org.jboss.jms.message.JBossMapMessage;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.JBossObjectMessage;
import org.jboss.jms.message.JBossStreamMessage;
import org.jboss.jms.message.JBossTextMessage;
import org.jboss.jms.message.MapMessageProxy;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.message.ObjectMessageProxy;
import org.jboss.jms.message.StreamMessageProxy;
import org.jboss.jms.message.TextMessageProxy;
import org.jboss.jms.tx.LocalTx;
import org.jboss.jms.tx.ResourceManager;
import org.jboss.logging.Logger;

public class SessionAspect {
    private static final Logger log = Logger.getLogger(SessionAspect.class);
    private boolean trace = log.isTraceEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object handleClosing(Invocation invocation) throws Throwable {
        int ackMode;
        MethodInvocation mi = (MethodInvocation)invocation;
        SessionState state = this.getState(invocation);
        SessionDelegate del = (SessionDelegate)mi.getTargetObject();
        if (this.trace) {
            log.trace((Object)"handleClosing()");
        }
        if (state.isXA() && !this.isXAAndConsideredNonTransacted(state)) {
            ConnectionState connState;
            ResourceManager rm;
            if (this.trace) {
                log.trace((Object)"Session is XA");
            }
            if ((rm = (connState = (ConnectionState)state.getParent()).getResourceManager()).checkForAcksInSession(state.getSessionID())) {
                throw new IllegalStateException("Attempt to close an XASession when there are still uncommitted acknowledgements!");
            }
        }
        if ((ackMode = state.getAcknowledgeMode()) == 1 || this.isXAAndConsideredNonTransacted(state)) {
            DeliveryInfo remainingAutoAck = state.getAutoAckInfo();
            if (remainingAutoAck == null) return invocation.invokeNext();
            if (this.trace) {
                log.trace((Object)(this + " handleClosing(). Found remaining auto ack. Will ack " + remainingAutoAck));
            }
            try {
                this.ackDelivery(del, remainingAutoAck);
                if (!this.trace) return invocation.invokeNext();
                log.trace((Object)(this + " acked it"));
                return invocation.invokeNext();
            }
            finally {
                state.setAutoAckInfo(null);
            }
        } else if (ackMode == 3) {
            if (state.getClientAckList().isEmpty()) return invocation.invokeNext();
            try {
                this.acknowledgeDeliveries(del, state.getClientAckList());
                return invocation.invokeNext();
            }
            finally {
                state.getClientAckList().clear();
                state.setAutoAckInfo(null);
            }
        } else if (ackMode == 2) {
            this.cancelDeliveries(del, state.getClientAckList());
            state.getClientAckList().clear();
            return invocation.invokeNext();
        } else {
            if (!state.isTransacted() || state.isXA()) return invocation.invokeNext();
            ConnectionState connState = (ConnectionState)state.getParent();
            ResourceManager rm = connState.getResourceManager();
            List dels = rm.getDeliveriesForSession(state.getSessionID());
            this.cancelDeliveries(del, dels);
        }
        return invocation.invokeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleClose(Invocation invocation) throws Throwable {
        try {
            Object res;
            Object object = res = invocation.invokeNext();
            return object;
        }
        finally {
            SessionState state = this.getState(invocation);
            ConnectionState connState = (ConnectionState)state.getParent();
            Object xid = state.getCurrentTxId();
            if (xid != null) {
                connState.getResourceManager().removeTx(xid);
            }
            state.getExecutor().shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handlePreDeliver(Invocation invocation) throws Throwable {
        SessionState state;
        MethodInvocation mi = (MethodInvocation)invocation;
        SessionState sessionState = state = this.getState(invocation);
        synchronized (sessionState) {
            int ackMode = state.getAcknowledgeMode();
            Object[] args = mi.getArguments();
            DeliveryInfo info = (DeliveryInfo)args[0];
            if (ackMode == 2) {
                if (this.trace) {
                    log.trace((Object)(this + " added to CLIENT_ACKNOWLEDGE list delivery " + info));
                }
                if (info.getConnectionConsumerSession() != null) {
                    throw new IllegalStateException("CLIENT_ACKNOWLEDGE cannot be used with a connection consumer");
                }
                state.getClientAckList().add(info);
            } else if (ackMode == 1 || this.isXAAndConsideredNonTransacted(state)) {
                if (this.trace) {
                    log.trace((Object)(this + " added " + info + " to session state"));
                }
                state.setAutoAckInfo(info);
            } else if (ackMode == 3) {
                if (this.trace) {
                    log.trace((Object)(this + " added to DUPS_OK_ACKNOWLEDGE list delivery " + info));
                }
                state.getClientAckList().add(info);
                state.setAutoAckInfo(info);
            } else {
                Object txID = state.getCurrentTxId();
                if (txID != null) {
                    ClientSessionDelegate connectionConsumerDelegate;
                    ConnectionState connState = (ConnectionState)state.getParent();
                    if (this.trace) {
                        log.trace((Object)"sending acknowlegment transactionally, queueing on resource manager");
                    }
                    String sessionId = (connectionConsumerDelegate = (ClientSessionDelegate)info.getConnectionConsumerSession()) != null ? connectionConsumerDelegate.getID() : state.getSessionID();
                    connState.getResourceManager().addAck(txID, sessionId, info);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handlePostDeliver(Invocation invocation) throws Throwable {
        SessionState state;
        MethodInvocation mi = (MethodInvocation)invocation;
        SessionState sessionState = state = this.getState(invocation);
        synchronized (sessionState) {
            int ackMode = state.getAcknowledgeMode();
            SessionDelegate sd = (SessionDelegate)mi.getTargetObject();
            boolean res = true;
            if (ackMode == 1 || this.isXAAndConsideredNonTransacted(state)) {
                if (!state.isRecoverCalled()) {
                    DeliveryInfo delivery = state.getAutoAckInfo();
                    if (delivery == null) {
                        throw new IllegalStateException("Cannot find delivery to AUTO_ACKNOWLEDGE");
                    }
                    if (this.trace) {
                        log.trace((Object)(this + " auto acknowledging delivery " + delivery));
                    }
                    try {
                        res = this.ackDelivery(sd, delivery);
                    }
                    finally {
                        state.setAutoAckInfo(null);
                    }
                } else {
                    if (this.trace) {
                        log.trace((Object)(this + " recover called, so NOT acknowledging"));
                    }
                    state.setRecoverCalled(false);
                }
            } else if (ackMode == 3) {
                List acks = state.getClientAckList();
                if (!state.isRecoverCalled()) {
                    if (acks.size() >= state.getDupsOKBatchSize()) {
                        try {
                            this.acknowledgeDeliveries(sd, acks);
                        }
                        finally {
                            acks.clear();
                            state.setAutoAckInfo(null);
                        }
                    }
                } else {
                    if (this.trace) {
                        log.trace((Object)(this + " recover called, so NOT acknowledging"));
                    }
                    state.setRecoverCalled(false);
                }
                state.setAutoAckInfo(null);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleAcknowledgeAll(Invocation invocation) throws Throwable {
        SessionState state;
        MethodInvocation mi = (MethodInvocation)invocation;
        SessionState sessionState = state = this.getState(invocation);
        synchronized (sessionState) {
            SessionDelegate del = (SessionDelegate)mi.getTargetObject();
            if (!state.getClientAckList().isEmpty()) {
                this.acknowledgeDeliveries(del, state.getClientAckList());
                state.getClientAckList().clear();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleRecover(Invocation invocation) throws Throwable {
        SessionState state;
        if (this.trace) {
            log.trace((Object)"recover called");
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        SessionState sessionState = state = this.getState(invocation);
        synchronized (sessionState) {
            DeliveryInfo info;
            if (state.isTransacted() && !this.isXAAndConsideredNonTransacted(state)) {
                throw new IllegalStateException("Cannot recover a transacted session");
            }
            if (this.trace) {
                log.trace((Object)"recovering the session");
            }
            SessionDelegate del = (SessionDelegate)mi.getTargetObject();
            int ackMode = state.getAcknowledgeMode();
            if (ackMode == 2) {
                List dels = state.getClientAckList();
                state.setClientAckList(new ArrayList());
                del.redeliver(dels);
                state.setRecoverCalled(true);
            } else if ((ackMode == 1 || ackMode == 3 || this.isXAAndConsideredNonTransacted(state)) && (info = state.getAutoAckInfo()) != null) {
                ArrayList<DeliveryInfo> redels = new ArrayList<DeliveryInfo>();
                redels.add(info);
                del.redeliver(redels);
                state.setAutoAckInfo(null);
                state.setRecoverCalled(true);
            }
            return null;
        }
    }

    public Object handleRedeliver(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        SessionState state = this.getState(invocation);
        List toRedeliver = (List)mi.getArguments()[0];
        if (this.trace) {
            log.trace((Object)(this + " handleRedeliver() called: " + toRedeliver));
        }
        SessionDelegate del = (SessionDelegate)mi.getTargetObject();
        for (int i = toRedeliver.size() - 1; i >= 0; --i) {
            DeliveryInfo info = (DeliveryInfo)toRedeliver.get(i);
            MessageProxy proxy = info.getMessageProxy();
            ClientConsumer handler = state.getCallbackHandler(info.getConsumerId());
            if (handler == null) {
                this.cancelDelivery(del, info);
                continue;
            }
            if (handler.getRedeliveryDelay() != 0L) {
                this.cancelDelivery(del, info);
                continue;
            }
            if (this.trace) {
                log.trace((Object)"Adding proxy back to front of buffer");
            }
            handler.addToFrontOfBuffer(proxy);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleCommit(Invocation invocation) throws Throwable {
        SessionState state;
        SessionState sessionState = state = this.getState(invocation);
        synchronized (sessionState) {
            if (!state.isTransacted()) {
                throw new IllegalStateException("Cannot commit a non-transacted session");
            }
            if (state.isXA()) {
                throw new TransactionInProgressException("Cannot call commit on an XA session");
            }
            ConnectionState connState = (ConnectionState)state.getParent();
            ConnectionDelegate conn = (ConnectionDelegate)((Object)connState.getDelegate());
            try {
                connState.getResourceManager().commitLocal((LocalTx)state.getCurrentTxId(), conn);
            }
            finally {
                LocalTx xid = connState.getResourceManager().createLocalTx();
                state.setCurrentTxId(xid);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleRollback(Invocation invocation) throws Throwable {
        SessionState state;
        SessionState sessionState = state = this.getState(invocation);
        synchronized (sessionState) {
            if (!state.isTransacted()) {
                throw new IllegalStateException("Cannot rollback a non-transacted session");
            }
            if (state.isXA()) {
                throw new TransactionInProgressException("Cannot call rollback on an XA session");
            }
            ConnectionState connState = (ConnectionState)state.getParent();
            ResourceManager rm = connState.getResourceManager();
            try {
                rm.rollbackLocal((LocalTx)state.getCurrentTxId());
            }
            finally {
                LocalTx xid = rm.createLocalTx();
                state.setCurrentTxId(xid);
            }
            return null;
        }
    }

    public Object handleSend(Invocation invocation) throws Throwable {
        SessionState state = this.getState(invocation);
        Object txID = state.getCurrentTxId();
        if (!state.isXA() && state.isTransacted() || state.isXA() && !(txID instanceof LocalTx)) {
            ConnectionState connState = (ConnectionState)state.getParent();
            MethodInvocation mi = (MethodInvocation)invocation;
            Message m = (Message)mi.getArguments()[0];
            if (this.trace) {
                log.trace((Object)("sending message " + m + " transactionally, queueing on resource manager txID=" + txID + " sessionID= " + state.getSessionID()));
            }
            connState.getResourceManager().addMessage(txID, state.getSessionID(), (JBossMessage)m);
            return null;
        }
        if (this.trace) {
            log.trace((Object)"sending message NON-transactionally");
        }
        return invocation.invokeNext();
    }

    public Object handleGetXAResource(Invocation invocation) throws Throwable {
        return this.getState(invocation).getXAResource();
    }

    public Object handleGetTransacted(Invocation invocation) throws Throwable {
        return this.getState(invocation).isTransacted() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object handleGetAcknowledgeMode(Invocation invocation) throws Throwable {
        return new Integer(this.getState(invocation).getAcknowledgeMode());
    }

    public Object handleCreateMessage(Invocation invocation) throws Throwable {
        JBossMessage jbm = new JBossMessage(0L);
        return new MessageProxy(jbm);
    }

    public Object handleCreateBytesMessage(Invocation invocation) throws Throwable {
        JBossBytesMessage jbm = new JBossBytesMessage(0L);
        return new BytesMessageProxy(jbm);
    }

    public Object handleCreateMapMessage(Invocation invocation) throws Throwable {
        JBossMapMessage jbm = new JBossMapMessage(0L);
        return new MapMessageProxy(jbm);
    }

    public Object handleCreateObjectMessage(Invocation invocation) throws Throwable {
        JBossObjectMessage jbm = new JBossObjectMessage(0L);
        MethodInvocation mi = (MethodInvocation)invocation;
        if (mi.getArguments() != null && mi.getArguments().length > 0) {
            jbm.setObject((Serializable)mi.getArguments()[0]);
        }
        return new ObjectMessageProxy(jbm);
    }

    public Object handleCreateStreamMessage(Invocation invocation) throws Throwable {
        JBossStreamMessage jbm = new JBossStreamMessage(0L);
        return new StreamMessageProxy(jbm);
    }

    public Object handleCreateTextMessage(Invocation invocation) throws Throwable {
        JBossTextMessage jbm = new JBossTextMessage(0L);
        MethodInvocation mi = (MethodInvocation)invocation;
        if (mi.getArguments() != null && mi.getArguments().length > 0) {
            jbm.setText((String)mi.getArguments()[0]);
        }
        return new TextMessageProxy(jbm);
    }

    public Object handleSetMessageListener(Invocation invocation) throws Throwable {
        MethodInvocation mi;
        MessageListener listener;
        if (this.trace) {
            log.trace((Object)"setMessageListener()");
        }
        if ((listener = (MessageListener)(mi = (MethodInvocation)invocation).getArguments()[0]) == null) {
            throw new IllegalStateException("Cannot set a null MessageListener on the session");
        }
        this.getState(invocation).setDistinguishedListener(listener);
        return null;
    }

    public Object handleGetMessageListener(Invocation invocation) throws Throwable {
        if (this.trace) {
            log.trace((Object)"getMessageListener()");
        }
        return this.getState(invocation).getDistinguishedListener();
    }

    public Object handleCreateConnectionConsumer(Invocation invocation) throws Throwable {
        if (this.trace) {
            log.trace((Object)"createConnectionConsumer()");
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        JBossDestination dest = (JBossDestination)mi.getArguments()[0];
        String subscriptionName = (String)mi.getArguments()[1];
        String messageSelector = (String)mi.getArguments()[2];
        ServerSessionPool sessionPool = (ServerSessionPool)mi.getArguments()[3];
        int maxMessages = (Integer)mi.getArguments()[4];
        return new JBossConnectionConsumer((ConnectionDelegate)mi.getTargetObject(), dest, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public Object handleAddAsfMessage(Invocation invocation) throws Throwable {
        if (this.trace) {
            log.trace((Object)"addAsfMessage()");
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        MessageProxy m = (MessageProxy)mi.getArguments()[0];
        String theConsumerID = (String)mi.getArguments()[1];
        String queueName = (String)mi.getArguments()[2];
        int maxDeliveries = (Integer)mi.getArguments()[3];
        SessionDelegate connectionConsumerDelegate = (SessionDelegate)mi.getArguments()[4];
        boolean shouldAck = (Boolean)mi.getArguments()[5];
        if (m == null) {
            throw new IllegalStateException("Cannot add a null message to the session");
        }
        AsfMessageHolder holder = new AsfMessageHolder();
        holder.msg = m;
        holder.consumerID = theConsumerID;
        holder.queueName = queueName;
        holder.maxDeliveries = maxDeliveries;
        holder.connectionConsumerDelegate = connectionConsumerDelegate;
        holder.shouldAck = shouldAck;
        this.getState(invocation).getASFMessages().add(holder);
        return null;
    }

    public Object handleRun(Invocation invocation) throws Throwable {
        if (this.trace) {
            log.trace((Object)"run()");
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        SessionDelegate del = (SessionDelegate)mi.getTargetObject();
        SessionState state = this.getState(invocation);
        int ackMode = state.getAcknowledgeMode();
        LinkedList msgs = state.getASFMessages();
        while (msgs.size() > 0) {
            AsfMessageHolder holder = (AsfMessageHolder)msgs.removeFirst();
            if (this.trace) {
                log.trace((Object)("sending " + holder.msg + " to the message listener"));
            }
            ClientConsumer.callOnMessage(del, state.getDistinguishedListener(), holder.consumerID, holder.queueName, false, holder.msg, ackMode, holder.maxDeliveries, holder.connectionConsumerDelegate, holder.shouldAck);
        }
        return null;
    }

    public String toString() {
        return "SessionAspect[" + Integer.toHexString(this.hashCode()) + "]";
    }

    private SessionState getState(Invocation inv) {
        return (SessionState)((DelegateSupport)inv.getTargetObject()).getState();
    }

    private boolean ackDelivery(SessionDelegate sess, DeliveryInfo delivery) throws Exception {
        if (delivery.isShouldAck()) {
            SessionDelegate connectionConsumerSession = delivery.getConnectionConsumerSession();
            SessionDelegate sessionToUse = connectionConsumerSession != null ? connectionConsumerSession : sess;
            return sessionToUse.acknowledgeDelivery(delivery);
        }
        return true;
    }

    private void cancelDelivery(SessionDelegate sess, DeliveryInfo delivery) throws Exception {
        if (delivery.isShouldAck()) {
            SessionDelegate connectionConsumerSession = delivery.getConnectionConsumerSession();
            SessionDelegate sessionToUse = connectionConsumerSession != null ? connectionConsumerSession : sess;
            sessionToUse.cancelDelivery(new DefaultCancel(delivery.getDeliveryID(), delivery.getMessageProxy().getDeliveryCount(), false, false));
        }
    }

    private void cancelDeliveries(SessionDelegate del, List deliveryInfos) throws Exception {
        ArrayList<DefaultCancel> cancels = new ArrayList<DefaultCancel>();
        for (DeliveryInfo ack : deliveryInfos) {
            if (!ack.isShouldAck()) continue;
            DefaultCancel cancel = new DefaultCancel(ack.getMessageProxy().getDeliveryId(), ack.getMessageProxy().getDeliveryCount(), false, false);
            cancels.add(cancel);
        }
        if (!cancels.isEmpty()) {
            del.cancelDeliveries(cancels);
        }
    }

    private void acknowledgeDeliveries(SessionDelegate del, List deliveryInfos) throws Exception {
        ArrayList<DeliveryInfo> acks = new ArrayList<DeliveryInfo>();
        for (DeliveryInfo ack : deliveryInfos) {
            if (!ack.isShouldAck()) continue;
            acks.add(ack);
        }
        if (!acks.isEmpty()) {
            del.acknowledgeDeliveries(acks);
        }
    }

    private boolean isXAAndConsideredNonTransacted(SessionState state) {
        return state.isXA() && state.getCurrentTxId() instanceof LocalTx && state.getTreatAsNonTransactedWhenNotEnlisted() && state.getDistinguishedListener() == null;
    }

    private static class AsfMessageHolder {
        private MessageProxy msg;
        private String consumerID;
        private String queueName;
        private int maxDeliveries;
        private SessionDelegate connectionConsumerDelegate;
        private boolean shouldAck;

        private AsfMessageHolder() {
        }
    }
}

