/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.combine;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;

public class DenyOverridesPolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:deny-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public DenyOverridesPolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected DenyOverridesPolicyAlg(URI identifier) {
        super(identifier);
    }

    public Result combine(EvaluationCtx context, List parameters, List policyElements) {
        boolean atLeastOnePermit = false;
        HashSet permitObligations = new HashSet();
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2) {
                return new Result(1, context.getResourceId().encode());
            }
            if (match.getResult() != 0) continue;
            Result result = policy.evaluate(context);
            int effect = result.getDecision();
            if (effect == 1 || effect == 2) {
                return new Result(1, context.getResourceId().encode(), result.getObligations());
            }
            if (effect != 0) continue;
            atLeastOnePermit = true;
            permitObligations.addAll(result.getObligations());
        }
        if (atLeastOnePermit) {
            return new Result(0, context.getResourceId().encode(), permitObligations);
        }
        return new Result(3, context.getResourceId().encode());
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

