/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.Target;
import org.jboss.security.xacml.sunxacml.TargetMatch;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetMatchGroup {
    private List matches;
    private int matchType;
    private static final Logger logger = Logger.getLogger(Target.class.getName());

    public TargetMatchGroup(List matchElements, int matchType) {
        this.matches = matchElements == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(new ArrayList(matchElements));
        this.matchType = matchType;
    }

    public static TargetMatchGroup getInstance(Node root, int matchType, PolicyMetaData metaData) throws ParsingException {
        ArrayList<TargetMatch> matches = new ArrayList<TargetMatch>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = SunxacmlUtil.getNodeName(child);
            if (!name.equals(TargetMatch.NAMES[matchType] + "Match")) continue;
            matches.add(TargetMatch.getInstance(child, matchType, metaData));
        }
        return new TargetMatchGroup(matches, matchType);
    }

    public MatchResult match(EvaluationCtx context) {
        TargetMatch tm;
        Iterator it = this.matches.iterator();
        MatchResult result = null;
        while (it.hasNext() && (result = (tm = (TargetMatch)it.next()).match(context)).getResult() == 0) {
        }
        return result;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        Iterator it = this.matches.iterator();
        String name = TargetMatch.NAMES[this.matchType];
        out.println(indent + "<" + name + ">");
        indenter.in();
        while (it.hasNext()) {
            TargetMatch tm = (TargetMatch)it.next();
            tm.encode(output, indenter);
        }
        out.println(indent + "</" + name + ">");
        indenter.out();
    }
}

