/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.version.Version;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarClassLoaderDeployer
extends AbstractSimpleVFSRealDeployer<JBossWebMetaData> {
    private boolean java2ClassLoadingCompliance = false;
    private boolean includeWebInfInClasspath;
    private String filteredPackages;

    public WarClassLoaderDeployer() {
        super(JBossWebMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.addInput(ClassLoadingMetaData.class);
        this.setOutput(ClassLoadingMetaData.class);
    }

    public boolean isJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public String getFilteredPackages() {
        return this.filteredPackages;
    }

    public void setFilteredPackages(String pkgs) {
        this.filteredPackages = pkgs;
    }

    public boolean isIncludeWebInfInClasspath() {
        return this.includeWebInfInClasspath;
    }

    public void setIncludeWebInfInClasspath(boolean includeWebInfInClasspath) {
        this.includeWebInfInClasspath = includeWebInfInClasspath;
    }

    public void deploy(VFSDeploymentUnit unit, JBossWebMetaData metaData) throws DeploymentException {
        VirtualFile webInf;
        if (this.includeWebInfInClasspath && (webInf = this.getWebInf(unit)) != null) {
            ArrayList<VirtualFile> classPath = new ArrayList<VirtualFile>();
            List unitClassPath = unit.getClassPath();
            if (unitClassPath != null) {
                classPath.addAll(unitClassPath);
            }
            if (!classPath.contains(webInf)) {
                classPath.add(webInf);
            }
            unit.setClassPath(classPath);
        }
        if (unit.isAttachmentPresent(ClassLoadingMetaData.class)) {
            return;
        }
        boolean j2seClassLoadingCompliance = this.java2ClassLoadingCompliance;
        org.jboss.metadata.web.jboss.ClassLoadingMetaData webCLMD = metaData.getClassLoading();
        if (webCLMD != null) {
            j2seClassLoadingCompliance = webCLMD.isJava2ClassLoadingCompliance();
        }
        ClassLoadingMetaData classLoadingMetaData = new ClassLoadingMetaData();
        classLoadingMetaData.setName(unit.getName());
        classLoadingMetaData.setDomain(unit.getName());
        classLoadingMetaData.setExportAll(ExportAll.NON_EMPTY);
        classLoadingMetaData.setImportAll(true);
        classLoadingMetaData.setVersion((Object)Version.DEFAULT_VERSION);
        classLoadingMetaData.setJ2seClassLoadingCompliance(j2seClassLoadingCompliance);
        classLoadingMetaData.setExcludedPackages(this.filteredPackages);
        unit.addAttachment(ClassLoadingMetaData.class, (Object)classLoadingMetaData);
    }

    public void undeploy(VFSDeploymentUnit unit, JBossWebMetaData metaData) {
        List classPath;
        VirtualFile webInf;
        if (this.includeWebInfInClasspath && (webInf = this.getWebInf(unit)) != null && (classPath = unit.getClassPath()) != null) {
            classPath.remove(webInf);
        }
    }

    protected VirtualFile getWebInf(VFSDeploymentUnit unit) {
        return unit.getFile("WEB-INF");
    }
}

