/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.jboss.aop.proxy.container.ContainerCacheUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPProxyFactoryMixin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String construction;
    private WeakReference<Class<?>> mixinClassRef;
    private WeakReference<Class<?>>[] interfaceClassRefs;
    private int hashcode;

    public AOPProxyFactoryMixin(Class<?> mixin, Class<?>[] interfaces) {
        this.mixinClassRef = new WeakReference(mixin);
        this.interfaceClassRefs = ContainerCacheUtil.getSortedWeakReferenceForInterfaces(interfaces);
    }

    public AOPProxyFactoryMixin(Class<?> mixin, Class<?>[] interfaces, String parameters) {
        this(mixin, interfaces);
        StringBuffer construction = new StringBuffer(" new ");
        construction.append(mixin.getName());
        if (!parameters.startsWith("(")) {
            construction.append("(");
        }
        construction.append(parameters);
        if (!parameters.endsWith(")")) {
            construction.append(")");
        }
        this.construction = construction.toString();
    }

    public String getConstruction() {
        return this.construction;
    }

    public Class<?>[] getInterfaces() {
        if (this.interfaceClassRefs != null) {
            Class[] interfaces = new Class[this.interfaceClassRefs.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaces[i] = (Class)this.interfaceClassRefs[i].get();
            }
            return interfaces;
        }
        return null;
    }

    public Class<?> getMixin() {
        return (Class)this.mixinClassRef.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AOPProxyFactoryMixin)) {
            return false;
        }
        AOPProxyFactoryMixin other = (AOPProxyFactoryMixin)obj;
        if (!this.compareConstruction(other)) {
            return false;
        }
        if (!ContainerCacheUtil.compareClassRefs(this.mixinClassRef, other.mixinClassRef)) {
            return false;
        }
        return ContainerCacheUtil.compareInterfaceRefs(this.interfaceClassRefs, other.interfaceClassRefs);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            Class clazz = (Class)this.mixinClassRef.get();
            StringBuffer sb = new StringBuffer();
            if (clazz != null) {
                sb.append(clazz.getName());
            }
            if (this.interfaceClassRefs != null) {
                for (int i = 0; i < this.interfaceClassRefs.length; ++i) {
                    sb.append(";");
                    sb.append(((Class)this.interfaceClassRefs[i].get()).getName());
                }
            }
            this.hashcode = sb.toString().hashCode();
            if (this.construction != null) {
                this.hashcode += this.construction.hashCode();
            }
        }
        return this.hashcode;
    }

    public String toString() {
        return super.toString();
    }

    private boolean compareConstruction(AOPProxyFactoryMixin other) {
        if (this.construction == null && other.construction != null) {
            return false;
        }
        if (this.construction != null && other.construction == null) {
            return false;
        }
        return this.construction == null || this.construction.equals(other.construction);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.construction);
        out.writeObject(this.mixinClassRef.get());
        out.writeObject(this.getInterfaces());
        out.writeInt(this.hashCode());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.construction = (String)in.readObject();
        this.mixinClassRef = new WeakReference<Class>((Class)in.readObject());
        Class[] ifs = (Class[])in.readObject();
        this.interfaceClassRefs = new WeakReference[ifs.length];
        for (int i = 0; i < ifs.length; ++i) {
            this.interfaceClassRefs[i] = new WeakReference<Class>(ifs[i]);
        }
        this.hashcode = in.readInt();
    }
}

