/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class ControllerState
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final ControllerState ERROR = new ControllerState("**ERROR**");
    public static final ControllerState NOT_INSTALLED = new ControllerState("Not Installed");
    public static final ControllerState PRE_INSTALL = new ControllerState("PreInstall");
    public static final ControllerState DESCRIBED = new ControllerState("Described");
    public static final ControllerState INSTANTIATED = new ControllerState("Instantiated");
    public static final ControllerState CONFIGURED = new ControllerState("Configured");
    public static final ControllerState CREATE = new ControllerState("Create");
    public static final ControllerState START = new ControllerState("Start");
    public static final ControllerState INSTALLED = new ControllerState("Installed");
    protected final String stateString;
    private static Map<String, ControllerState> values = new HashMap<String, ControllerState>();

    public ControllerState(String stateString) {
        if (stateString == null) {
            throw new IllegalArgumentException("Null state string");
        }
        this.stateString = stateString;
    }

    public String getStateString() {
        return this.stateString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ControllerState)) {
            return false;
        }
        ControllerState other = (ControllerState)object;
        return this.stateString.equals(other.stateString);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.stateString);
    }

    protected int getHashCode() {
        return this.stateString.hashCode();
    }

    protected Object readResolve() throws ObjectStreamException {
        return values.get(this.stateString);
    }

    static {
        values.put(ERROR.getStateString(), ERROR);
        values.put(NOT_INSTALLED.getStateString(), NOT_INSTALLED);
        values.put(PRE_INSTALL.getStateString(), PRE_INSTALL);
        values.put(DESCRIBED.getStateString(), DESCRIBED);
        values.put(INSTANTIATED.getStateString(), INSTANTIATED);
        values.put(CONFIGURED.getStateString(), CONFIGURED);
        values.put(CREATE.getStateString(), CREATE);
        values.put(START.getStateString(), START);
        values.put(INSTALLED.getStateString(), INSTALLED);
    }
}

