/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.destination.ManagedQueue;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.contract.Queue;
import org.w3c.dom.Element;

public abstract class ManagedDestination
implements MessagingComponent {
    protected static final int ALL = 0;
    protected static final int DURABLE = 1;
    protected static final int NON_DURABLE = 2;
    private static final int DEFAULT_FULL_SIZE = 200000;
    private static final int DEFAULT_PAGE_SIZE = 2000;
    private static final int DEFAULT_DOWN_CACHE_SIZE = 2000;
    protected String name;
    protected String jndiName;
    protected boolean clustered;
    protected boolean temporary;
    protected int fullSize = 200000;
    protected int pageSize = 2000;
    protected int downCacheSize = 2000;
    protected Element securityConfig;
    protected ServerPeer serverPeer;
    protected ManagedQueue dlq;
    protected ManagedQueue expiryQueue;
    protected long redeliveryDelay = -1L;
    protected int maxSize = -1;
    protected int messageCounterHistoryDayLimit = -1;
    protected int maxDeliveryAttempts = -1;

    public ManagedDestination() {
    }

    public ManagedDestination(String name, int fullSize, int pageSize, int downCacheSize, boolean clustered) {
        this.name = name;
        this.fullSize = fullSize;
        this.pageSize = pageSize;
        this.downCacheSize = downCacheSize;
        this.clustered = clustered;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public int getDownCacheSize() {
        return this.downCacheSize;
    }

    public void setDownCacheSize(int downCacheSize) {
        this.downCacheSize = downCacheSize;
    }

    public int getFullSize() {
        return this.fullSize;
    }

    public void setFullSize(int fullSize) {
        this.fullSize = fullSize;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Element getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(Element securityConfig) {
        this.securityConfig = securityConfig;
    }

    public ServerPeer getServerPeer() {
        return this.serverPeer;
    }

    public void setServerPeer(ServerPeer serverPeer) {
        this.serverPeer = serverPeer;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public Queue getDLQ() throws Exception {
        Queue theQueue = null;
        if (this.dlq != null) {
            Binding binding = this.serverPeer.getPostOfficeInstance().getBindingForQueueName(this.dlq.getName());
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for queue " + this.dlq.getName());
            }
            Queue queue = binding.queue;
            if (queue.isActive()) {
                theQueue = queue;
            }
        }
        return theQueue;
    }

    public void setDLQ(ManagedQueue dlq) {
        this.dlq = dlq;
    }

    public Queue getExpiryQueue() throws Exception {
        Queue theQueue = null;
        if (this.expiryQueue != null) {
            Binding binding = this.serverPeer.getPostOfficeInstance().getBindingForQueueName(this.expiryQueue.getName());
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for queue " + this.expiryQueue.getName());
            }
            Queue queue = binding.queue;
            if (queue.isActive()) {
                theQueue = queue;
            }
        }
        return theQueue;
    }

    public void setExpiryQueue(ManagedQueue expiryQueue) {
        this.expiryQueue = expiryQueue;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(long delay) {
        this.redeliveryDelay = delay;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) throws Exception {
        this.maxSize = maxSize;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit;
    }

    public void setMessageCounterHistoryDayLimit(int limit) throws Exception {
        this.messageCounterHistoryDayLimit = limit;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public void setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
    }

    public abstract boolean isQueue();

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }
}

