/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jmx.adaptor.snmp.agent.AttributeMappingsBinding;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.ComparableSnmpObjectId;
import org.jboss.jmx.adaptor.snmp.agent.ReadOnlyException;
import org.jboss.jmx.adaptor.snmp.agent.Reconfigurable;
import org.jboss.jmx.adaptor.snmp.agent.RequestHandlerSupport;
import org.jboss.jmx.adaptor.snmp.config.attribute.AttributeMappings;
import org.jboss.jmx.adaptor.snmp.config.attribute.ManagedBean;
import org.jboss.jmx.adaptor.snmp.config.attribute.MappedAttribute;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.opennms.protocols.snmp.SnmpAgentSession;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpVarBind;

public class RequestHandlerImpl
extends RequestHandlerSupport
implements Reconfigurable {
    private static final String NO_ENTRY_FOUND_FOR_OID = "No entry found for oid ";
    private static final String SKIP_ENTRY = " - skipping entry";
    protected SortedMap bindings = new TreeMap();
    private SortedSet oidKeys = new TreeSet();
    private boolean initialized = false;

    public void initialize(String resourceName, MBeanServer server, Logger log, Clock uptime) throws Exception {
        log.debug((Object)("initialize() with res=" + resourceName));
        super.initialize(resourceName, server, log, uptime);
        if (resourceName != null) {
            this.initializeBindings();
        } else {
            log.warn((Object)"No RequestHandlerResName configured, disabling snmp-get");
        }
        this.initialized = true;
    }

    public void reconfigure(String resName) throws Exception {
        if (resName == null || resName.equals("")) {
            throw new IllegalArgumentException("Null or empty resName, cannot reconfigure");
        }
        if (!this.initialized) {
            throw new IllegalStateException("Cannot reconfigure, not initialized yet");
        }
        this.resourceName = resName;
        this.bindings.clear();
        this.initializeBindings();
    }

    public SnmpPduRequest snmpReceivedGet(SnmpPduPacket pdu, boolean getNext) {
        try {
            SnmpPduRequest response = null;
            int pduLength = pdu.getLength();
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)("requestId=" + pdu.getRequestId() + ", pduLength=" + pduLength + ", getNext=" + getNext));
            }
            SnmpVarBind[] vblist = new SnmpVarBind[pduLength];
            int errorStatus = 0;
            int errorIndex = 0;
            for (int i = 0; i < pduLength; ++i) {
                boolean good = true;
                SnmpVarBind vb = pdu.getVarBindAt(i);
                SnmpObjectId oid = vb.getName();
                if (getNext) {
                    ComparableSnmpObjectId coid = new ComparableSnmpObjectId(oid);
                    if ((oid = this.getNextOid(coid, true)) == null) {
                        good = false;
                    } else {
                        pdu.setVarBindAt(i, new SnmpVarBind(oid));
                    }
                }
                vblist[i] = oid != null ? new SnmpVarBind(oid) : new SnmpVarBind(vb.getName());
                if (trace) {
                    this.log.trace((Object)("oid=" + oid));
                }
                SnmpSyntax result = null;
                if (good && this.bindings != null) {
                    result = this.getValueFor(oid);
                }
                if (trace) {
                    this.log.trace((Object)("got result of " + result));
                }
                if (result == null || !good) {
                    errorStatus = 2;
                    errorIndex = i + 1;
                    this.log.debug((Object)("Error Occured " + vb.getName().toString()));
                    continue;
                }
                vblist[i].setValue(result);
                this.log.debug((Object)("Varbind[" + i + "] := " + vblist[i].getName().toString()));
                this.log.debug((Object)(" --> " + vblist[i].getValue().toString()));
            }
            response = new SnmpPduRequest(162, vblist);
            response.setErrorStatus(errorStatus);
            response.setErrorIndex(errorIndex);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SnmpPduRequest snmpReceivedSet(SnmpPduPacket pdu) {
        boolean trace = this.log.isTraceEnabled();
        SnmpPduRequest response = null;
        int errorStatus = 0;
        int errorIndex = 0;
        int k = pdu.getLength();
        SnmpVarBind[] vblist = new SnmpVarBind[k];
        for (int i = 0; i < k; ++i) {
            SnmpVarBind vb = pdu.getVarBindAt(i);
            vblist[i] = new SnmpVarBind(vb);
            SnmpObjectId oid = vb.getName();
            SnmpSyntax newVal = vb.getValue();
            if (trace) {
                this.log.trace((Object)("set: received oid " + oid.toString() + " with value " + newVal.toString()));
            }
            SnmpSyntax result = null;
            try {
                result = this.setValueFor(oid, newVal);
            }
            catch (ReadOnlyException e) {
                errorStatus = 4;
                errorIndex = i + 1;
            }
            if (result != null) {
                errorStatus = 4;
                errorIndex = i + 1;
                this.log.debug((Object)("Error occured " + vb.getName().toString()));
            }
            if (!trace) continue;
            this.log.trace((Object)("Varbind[" + i + "] := " + vb.getName().toString()));
            this.log.trace((Object)(" --> " + vb.getValue().toString()));
        }
        response = new SnmpPduRequest(162, vblist);
        response.setErrorStatus(errorStatus);
        response.setErrorIndex(errorIndex);
        return response;
    }

    public void snmpReceivedPdu(SnmpAgentSession session, InetAddress manager, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        this.log.error((Object)("Message from manager " + manager.toString() + " on port " + port));
        int cmd = pdu.getCommand();
        this.log.error((Object)("Unsupported PDU command......... " + cmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SnmpAgentSessionError(SnmpAgentSession session, int error, Object ref) {
        this.log.error((Object)"An error occured in the trap session");
        this.log.error((Object)("Session error code = " + error));
        if (ref != null) {
            this.log.error((Object)("Session error reference: " + ref.toString()));
        }
        if (error == -1) {
            SnmpAgentSession snmpAgentSession = session;
            synchronized (snmpAgentSession) {
                session.notify();
            }
        }
    }

    private void initializeBindings() throws Exception {
        this.log.debug((Object)("Reading resource: '" + this.resourceName + "'"));
        AttributeMappingsBinding omf = new AttributeMappingsBinding();
        InputStream is = null;
        AttributeMappings mappings = null;
        try {
            is = this.getClass().getResourceAsStream(this.resourceName);
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            mappings = (AttributeMappings)unmarshaller.unmarshal(is, (ObjectModelFactory)omf, null);
        }
        catch (Exception e) {
            this.log.error((Object)("Accessing resource '" + this.resourceName + "'"));
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (mappings == null) {
            this.log.warn((Object)("No bindings found in " + this.resourceName));
            return;
        }
        this.log.debug((Object)("Found " + mappings.size() + " attribute mappings"));
        Iterator it = mappings.iterator();
        while (it.hasNext()) {
            ManagedBean mmb = (ManagedBean)it.next();
            String oidPrefix = mmb.getOidPrefix();
            List attrs = mmb.getAttributes();
            for (MappedAttribute ma : attrs) {
                String oid = oidPrefix != null ? oidPrefix + ma.getOid() : ma.getOid();
                BindEntry be = new BindEntry(oid, mmb.getName(), ma.getName());
                be.isReadWrite = ma.isReadWrite();
                ComparableSnmpObjectId coid = new ComparableSnmpObjectId(oid);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("New bind entry   " + be));
                }
                if (this.bindings.containsKey(coid)) {
                    this.log.info((Object)("Duplicate oid " + oid + SKIP_ENTRY));
                    continue;
                }
                if (mmb.getName() == null || mmb.getName().equals("")) {
                    this.log.info((Object)("Invalid mbean name for oid " + oid + SKIP_ENTRY));
                    continue;
                }
                if (ma.getName() == null || ma.getName().equals("")) {
                    this.log.info((Object)("Invalid attribute name " + ma.getName() + " for oid " + oid + SKIP_ENTRY));
                    continue;
                }
                this.bindings.put(coid, be);
                this.oidKeys.add(coid);
            }
        }
    }

    private SnmpSyntax getValueFor(SnmpObjectId oid) {
        SnmpNull ssy;
        block9: {
            BindEntry be = this.findBindEntryForOid(oid);
            ssy = null;
            if (be != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Found entry " + be.toString() + " for oid " + oid));
                }
                try {
                    Object val = this.server.getAttribute(be.mbean, be.attr.getName());
                    if (val instanceof Long) {
                        Long uin = (Long)val;
                        ssy = new SnmpUInt32(uin);
                        break block9;
                    }
                    if (val instanceof String) {
                        String in = (String)val;
                        ssy = new SnmpOctetString(in.getBytes());
                        break block9;
                    }
                    if (val instanceof Integer) {
                        Integer in = (Integer)val;
                        ssy = new SnmpInt32(in);
                        break block9;
                    }
                    if (val instanceof SnmpObjectId) {
                        ssy = (SnmpObjectId)val;
                        break block9;
                    }
                    this.log.info((Object)("Unknown type for " + be));
                }
                catch (Exception e) {
                    this.log.warn((Object)("getValueFor (" + be.mbean.toString() + ", " + be.attr.getName() + ": " + e.toString()));
                }
            } else {
                ssy = new SnmpNull();
                this.log.info((Object)(NO_ENTRY_FOUND_FOR_OID + oid));
            }
        }
        return ssy;
    }

    private SnmpSyntax setValueFor(SnmpObjectId oid, SnmpSyntax newVal) throws ReadOnlyException {
        SnmpNull ssy;
        block15: {
            boolean trace = this.log.isTraceEnabled();
            BindEntry be = this.findBindEntryForOid(oid);
            if (trace) {
                this.log.trace((Object)("setValueFor: found bind entry for " + oid));
            }
            ssy = null;
            if (be != null) {
                if (trace) {
                    this.log.trace((Object)("setValueFor: " + be.toString()));
                }
                if (!be.isReadWrite) {
                    if (trace) {
                        this.log.trace((Object)"setValueFor: this is marked read only");
                    }
                    throw new ReadOnlyException(oid);
                }
                try {
                    Object val = null;
                    if (newVal instanceof SnmpOctetString) {
                        val = newVal.toString();
                    } else if (newVal instanceof SnmpInt32) {
                        val = new Integer(((SnmpInt32)newVal).getValue());
                    } else if (newVal instanceof SnmpUInt32) {
                        val = new Long(((SnmpUInt32)newVal).getValue());
                    }
                    if (val != null) {
                        Attribute at = new Attribute(be.attr.getName(), val);
                        this.server.setAttribute(be.mbean, at);
                        if (trace) {
                            this.log.trace((Object)"setValueFor: set attribute in mbean-Server");
                        }
                        break block15;
                    }
                    this.log.debug((Object)("Did not find a suitable data type for newVal " + newVal));
                    ssy = new SnmpNull();
                }
                catch (Exception e) {
                    this.log.debug((Object)("setValueFor: exception " + e.getMessage()));
                    ssy = new SnmpNull();
                }
            } else {
                ssy = new SnmpNull();
                this.log.info((Object)(NO_ENTRY_FOUND_FOR_OID + oid));
            }
        }
        return ssy;
    }

    private BindEntry findBindEntryForOid(SnmpObjectId oid) {
        ComparableSnmpObjectId coid = new ComparableSnmpObjectId(oid);
        if (coid.isLeaf()) {
            coid = coid.removeLastPart();
        }
        BindEntry be = (BindEntry)this.bindings.get(coid);
        return be;
    }

    private ComparableSnmpObjectId getNextOid(ComparableSnmpObjectId oid, boolean stayInSubtree) {
        ComparableSnmpObjectId parent;
        ComparableSnmpObjectId coid = new ComparableSnmpObjectId(oid);
        if (coid.isLeaf()) {
            coid = coid.removeLastPart();
        }
        SortedSet<ComparableSnmpObjectId> ret = this.oidKeys.tailSet(oid);
        Iterator it = ret.iterator();
        ComparableSnmpObjectId roid = null;
        if (it.hasNext()) {
            roid = (ComparableSnmpObjectId)it.next();
        }
        if (roid == null) {
            return null;
        }
        if (roid.compareTo(coid) == 0) {
            roid = it.hasNext() ? (ComparableSnmpObjectId)it.next() : null;
        }
        if (stayInSubtree && roid != null && !(parent = coid.removeLastPart()).isRootOf(roid)) {
            roid = null;
        }
        return roid;
    }

    private class BindEntry
    implements Comparable {
        private final ComparableSnmpObjectId oid;
        private ObjectName mbean;
        private Attribute attr;
        private String mName;
        private String aName;
        private boolean isReadWrite = false;

        BindEntry(String oidString, String mbName, String attrName) {
            this(new ComparableSnmpObjectId(oidString), mbName, attrName);
        }

        BindEntry(ComparableSnmpObjectId coid, String mbName, String attrName) {
            this.oid = coid;
            this.mName = mbName;
            this.aName = attrName;
            try {
                this.mbean = new ObjectName(mbName);
                this.attr = new Attribute(attrName, null);
            }
            catch (Exception e) {
                RequestHandlerImpl.this.log.warn((Object)e.toString());
                this.mName = "-unset-";
                this.aName = "-unset-";
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[oid=");
            buf.append(this.oid).append(", mbean=");
            buf.append(this.mName).append(", attr=");
            buf.append(this.aName).append(", rw=");
            buf.append(this.isReadWrite).append("]");
            return buf.toString();
        }

        public Attribute getAttr() {
            return this.attr;
        }

        public ObjectName getMbean() {
            return this.mbean;
        }

        public ComparableSnmpObjectId getOid() {
            return this.oid;
        }

        public int compareTo(Object other) {
            if (other == null) {
                throw new NullPointerException("Can't compare to NULL");
            }
            if (!(other instanceof BindEntry)) {
                throw new ClassCastException("Parameter is no BindEntry");
            }
            if (this.equals(other)) {
                return 0;
            }
            BindEntry obe = (BindEntry)other;
            if (this.getOid().equals(obe.getOid())) {
                return 0;
            }
            int res = this.oid.compare(obe.getOid());
            return res;
        }
    }
}

