/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;

public class Heartbeat {
    public static final String NOTIFICATION_MSG = "heartbeat report";
    private static final Logger log = Logger.getLogger(Heartbeat.class);
    private MBeanServer agent = null;
    private long interval = 0L;
    private ObjectName timer = null;
    private Integer heartbeatSchedule = null;

    public Heartbeat(MBeanServer agent, ObjectName timer, long interval) {
        this.agent = agent;
        this.timer = timer;
        this.interval = interval;
    }

    public void start() throws Exception {
        long period = this.interval * 1000L;
        if (period <= 0L) {
            log.debug((Object)"Heartbeat disabled");
            return;
        }
        if (this.heartbeatSchedule == null) {
            try {
                Object userData = null;
                Date startTime = new Date();
                Long nbOccurences = new Long(0L);
                this.heartbeatSchedule = (Integer)this.agent.invoke(this.timer, "addNotification", new Object[]{"jboss.snmp.agent.heartbeat", NOTIFICATION_MSG, userData, startTime, new Long(period), nbOccurences}, new String[]{"java.lang.String", "java.lang.String", Object.class.getName(), Date.class.getName(), Long.TYPE.getName(), Long.TYPE.getName()});
                log.debug((Object)("Heartbeat period set to " + period + " msecs"));
            }
            catch (Exception e) {
                log.error((Object)"while setting heartbeat notification", (Throwable)e);
                throw e;
            }
        }
    }

    public void stop() throws Exception {
        if (this.heartbeatSchedule != null) {
            try {
                this.agent.invoke(this.timer, "removeNotification", new Object[]{this.heartbeatSchedule}, new String[]{this.heartbeatSchedule.getClass().getName()});
                this.heartbeatSchedule = null;
            }
            catch (Exception e) {
                log.error((Object)"while unsetting heartbeat notification", (Throwable)e);
                throw e;
            }
        }
    }
}

