/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.jbosssx;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject, String domain) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject, domain);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject, domain);
        }
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(final Principal principal, final Object credential, final Subject subject, final String domain) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            SecurityContext sc = SecurityContextFactory.createSecurityContext((String)domain);
                            SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                            sc.getUtil().createSubjectInfo(principal, credential, subject);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SecurityContextAssociation.clearSecurityContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject, String domain) {
                try {
                    SecurityContext sc = SecurityContextFactory.createSecurityContext((String)domain);
                    SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                    sc.getUtil().createSubjectInfo(principal, credential, subject);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void pop() {
                SecurityContextAssociation.clearSecurityContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3, String var4);

        public void pop();
    }
}

