/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ws.tools.io.NullPrintStream;
import org.jboss.wsf.spi.tools.WSContractConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunRIConsumerImpl
extends WSContractConsumer {
    private List<File> bindingFiles;
    private File catalog;
    private boolean extension;
    private boolean generateSource;
    private boolean nocompile;
    private File outputDir = new File("output");
    private File sourceDir;
    private String targetPackage;
    private PrintStream messageStream;
    private String wsdlLocation;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private String target = "2.0";

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    public void consume(URL wsdl) {
        String xmlInputFactory;
        PrintStream stream;
        ArrayList<String> args = new ArrayList<String>();
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.nocompile) {
            args.add("-Xnocompile");
        }
        if (this.generateSource) {
            args.add("-keep");
            if (this.sourceDir != null) {
                if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + this.sourceDir.getName());
                }
                args.add("-s");
                args.add(this.sourceDir.getAbsolutePath());
            }
        }
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdllocation");
            args.add(this.wsdlLocation);
        }
        if ((stream = this.messageStream) != null) {
            args.add("-verbose");
        } else {
            stream = NullPrintStream.getInstance();
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
        }
        args.add("-d");
        args.add(this.outputDir.getAbsolutePath());
        if (!this.target.equals("2.0")) {
            throw new IllegalArgumentException("WSConsume (native) only supports JAX-WS 2.0");
        }
        args.add("-target");
        args.add(this.target);
        args.add(wsdl.toString());
        String javaClassPath = System.getProperty("java.class.path");
        if (!this.additionalCompilerClassPath.isEmpty()) {
            StringBuffer javaCP = new StringBuffer();
            for (String s : this.additionalCompilerClassPath) {
                javaCP.append(s).append(File.pathSeparator);
            }
            System.setProperty("java.class.path", javaCP.toString());
        }
        if ((xmlInputFactory = System.getProperty("javax.xml.stream.XMLInputFactory")) == null) {
            System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        }
        try {
            try {
                WsimportTool compileTool = new WsimportTool((OutputStream)stream);
                boolean success = compileTool.run(args.toArray(new String[args.size()]));
                if (!success) {
                    throw new IllegalStateException("WsImport invocation failed. Try the verbose switch for more information");
                }
                Object var9_10 = null;
            }
            catch (RuntimeException rte) {
                if (this.messageStream != null) {
                    this.messageStream.println("Failed to invoke WsImport");
                    rte.printStackTrace(this.messageStream);
                } else {
                    rte.printStackTrace();
                }
                throw rte;
            }
            this.resetSystemProperty("java.class.path", javaClassPath);
            this.resetSystemProperty("javax.xml.stream.XMLInputFactory", xmlInputFactory);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.resetSystemProperty("java.class.path", javaClassPath);
            this.resetSystemProperty("javax.xml.stream.XMLInputFactory", xmlInputFactory);
            throw throwable;
        }
    }

    private void resetSystemProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.clearProperty(key);
        }
    }
}

