/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Binding21;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.ConfigProvider;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.HTTPProtocolConnection;
import org.jboss.ws.core.client.HTTPRemotingConnection;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.SOAPProtocolConnectionHTTP;
import org.jboss.ws.core.jaxws.binding.BindingExt;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.client.DispatchHTTPBinding;
import org.jboss.ws.core.jaxws.client.DispatchSOAPBinding;
import org.jboss.ws.core.jaxws.client.ResponseImpl;
import org.jboss.ws.core.jaxws.handler.HandlerChainExecutor;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
implements Dispatch<T>,
ConfigProvider {
    private final Logger log = Logger.getLogger(DispatchImpl.class);
    private BindingProvider bindingProvider;
    private HandlerResolverImpl handlerResolver;
    private ClientEndpointMetaData epMetaData;
    private JAXBContext jaxbContext;
    private ExecutorService executor;
    private String securityConfig;
    private Class type;
    private Service.Mode mode;
    private Map<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor> executorMap = new HashMap<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor>();

    public DispatchImpl(ExecutorService executor, EndpointMetaData epMetaData, Class<T> type, Service.Mode mode) {
        this.bindingProvider = new BindingProviderImpl(epMetaData);
        this.epMetaData = (ClientEndpointMetaData)epMetaData;
        this.executor = executor;
        this.type = type;
        this.mode = mode;
        this.initDispatch();
    }

    public DispatchImpl(ExecutorService executor, EndpointMetaData epMetaData, JAXBContext jbc, Service.Mode mode) {
        this.bindingProvider = new BindingProviderImpl(epMetaData);
        this.epMetaData = (ClientEndpointMetaData)epMetaData;
        this.executor = executor;
        this.type = Object.class;
        this.jaxbContext = jbc;
        this.mode = mode;
        this.initDispatch();
    }

    public T invoke(T obj) {
        Object retObj = null;
        try {
            retObj = this.invokeInternal(obj, this.getResponseContext());
        }
        catch (Exception ex) {
            this.handleInvokeException(ex);
        }
        return (T)retObj;
    }

    private Object invokeInternal(Object obj, Map<String, Object> resContext) throws Exception {
        Object retObj = null;
        BindingExt binding = (BindingExt)this.bindingProvider.getBinding();
        String bindingID = binding.getBindingID();
        if (bindingID.indexOf("soap") > 0) {
            if (this.handlerResolver == null) {
                this.handlerResolver = new HandlerResolverImpl();
                this.handlerResolver.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.PRE, true);
                this.handlerResolver.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT, true);
                this.handlerResolver.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.POST, true);
                PortInfo portInfo = this.epMetaData.getPortInfo();
                List<Handler> preChain = this.handlerResolver.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.PRE);
                List<Handler> epChain = this.handlerResolver.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                List<Handler> postChain = this.handlerResolver.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.POST);
                binding.setHandlerChain(preChain, UnifiedHandlerMetaData.HandlerType.PRE);
                binding.setHandlerChain(epChain, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                binding.setHandlerChain(postChain, UnifiedHandlerMetaData.HandlerType.POST);
            }
            retObj = this.invokeInternalSOAP(obj);
        } else {
            retObj = this.invokeInternalNonSOAP(obj);
        }
        return retObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeInternalSOAP(Object obj) throws Exception {
        Object retObj = null;
        SOAPMessageImpl reqMsg = (SOAPMessageImpl)this.getRequestMessage(obj);
        String targetAddress = this.epMetaData.getEndpointAddress();
        String soapAction = null;
        Map<String, Object> reqContext = this.getRequestContext();
        Boolean useSOAPAction = (Boolean)reqContext.get("javax.xml.ws.soap.http.soapaction.use");
        if (Boolean.TRUE.equals(useSOAPAction) && (soapAction = (String)reqContext.get("javax.xml.ws.soap.http.soapaction.uri")) == null) {
            throw new IllegalStateException("Cannot obtain: javax.xml.ws.soap.http.soapaction.uri");
        }
        MimeHeaders mimeHeaders = reqMsg.getMimeHeaders();
        mimeHeaders.addHeader("SOAPAction", soapAction != null ? soapAction : "");
        UnifiedHandlerMetaData.HandlerType[] handlerType = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
        UnifiedHandlerMetaData.HandlerType[] faultType = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
        MessageContextJAXWS msgContext = new SOAPMessageContextJAXWS();
        MessageContextAssociation.pushMessageContext(msgContext);
        try {
            msgContext.setEndpointMetaData(this.epMetaData);
            msgContext.setSOAPMessage(reqMsg);
            msgContext.putAll((Map<? extends String, ? extends Object>)reqContext);
            ((CommonMessageContext)msgContext).setOperationMetaData(this.getOperationMetaData(this.epMetaData, reqMsg));
            msgContext.put("javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
            QName portName = this.epMetaData.getPortName();
            try {
                boolean handlerPass = this.callRequestHandlerChain(portName, handlerType[0]);
                handlerPass = handlerPass && this.callRequestHandlerChain(portName, handlerType[1]);
                handlerPass = handlerPass && this.callRequestHandlerChain(portName, handlerType[2]);
                XOPContext.visitAndRestoreXOPData();
                reqMsg = (SOAPMessageImpl)msgContext.getSOAPMessage();
                MessageAbstraction resMsg = null;
                if (handlerPass) {
                    HashMap<String, Object> callProps = new HashMap<String, Object>(this.getRequestContext());
                    if (callProps.containsKey("javax.xml.ws.service.endpoint.address")) {
                        targetAddress = (String)callProps.get("javax.xml.ws.service.endpoint.address");
                    }
                    EndpointInfo epInfo = new EndpointInfo(this.epMetaData, targetAddress, callProps);
                    resMsg = this.getRemotingConnection().invoke(reqMsg, epInfo, false);
                    msgContext = MessageContextJAXWS.processPivot(msgContext);
                    msgContext.setMessageAbstraction(resMsg);
                    handlerPass = this.callResponseHandlerChain(portName, handlerType[2]);
                    faultType[2] = null;
                    handlerPass = handlerPass && this.callResponseHandlerChain(portName, handlerType[1]);
                    faultType[1] = null;
                    handlerPass = handlerPass && this.callResponseHandlerChain(portName, handlerType[0]);
                    faultType[0] = null;
                }
                if (handlerPass) {
                    retObj = this.getReturnObject(resMsg);
                }
            }
            catch (Exception ex) {
                msgContext = MessageContextJAXWS.processPivot(msgContext);
                if (faultType[2] != null) {
                    this.callFaultHandlerChain(portName, faultType[2], ex);
                }
                if (faultType[1] != null) {
                    this.callFaultHandlerChain(portName, faultType[1], ex);
                }
                if (faultType[0] != null) {
                    this.callFaultHandlerChain(portName, faultType[0], ex);
                }
                throw ex;
            }
            finally {
                this.closeHandlerChain(portName, handlerType[2]);
                this.closeHandlerChain(portName, handlerType[1]);
                this.closeHandlerChain(portName, handlerType[0]);
            }
        }
        finally {
            MessageContextAssociation.popMessageContext();
        }
        return retObj;
    }

    private Object invokeInternalNonSOAP(Object obj) throws IOException {
        MessageAbstraction reqMsg = this.getRequestMessage(obj);
        String targetAddress = this.epMetaData.getEndpointAddress();
        HashMap<String, Object> callProps = new HashMap<String, Object>(this.getRequestContext());
        if (callProps.containsKey("javax.xml.ws.service.endpoint.address")) {
            targetAddress = (String)callProps.get("javax.xml.ws.service.endpoint.address");
        }
        MessageAbstraction resMsg = this.getRemotingConnection().invoke(reqMsg, targetAddress, false);
        Object retObj = this.getReturnObject(resMsg);
        return retObj;
    }

    private RemoteConnection getRemotingConnection() {
        String bindingID = ((Binding21)this.bindingProvider.getBinding()).getBindingID();
        if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID)) {
            throw new IllegalStateException("Unsupported binding: " + bindingID);
        }
        HTTPRemotingConnection remotingConnection = "http://www.w3.org/2004/08/wsdl/http".equals(bindingID) ? new HTTPProtocolConnection() : new SOAPProtocolConnectionHTTP();
        return remotingConnection;
    }

    public Response<T> invokeAsync(T msg) {
        ResponseImpl response = new ResponseImpl();
        AsyncRunnable task = new AsyncRunnable(response, null, msg);
        Future<?> future = this.executor.submit(task);
        response.setFuture(future);
        return response;
    }

    public Future invokeAsync(T obj, AsyncHandler<T> handler) {
        ResponseImpl response = new ResponseImpl();
        AsyncRunnable task = new AsyncRunnable(response, handler, obj);
        Future<?> future = this.executor.submit(task);
        response.setFuture(future);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeOneWay(T msg) {
        SOAPMessageContextJAXWS msgContext = new SOAPMessageContextJAXWS();
        MessageContextAssociation.pushMessageContext(msgContext);
        try {
            msgContext.setEndpointMetaData(this.epMetaData);
            MessageAbstraction reqMsg = this.getRequestMessage(msg);
            String targetAddress = this.epMetaData.getEndpointAddress();
            this.getRemotingConnection().invoke(reqMsg, targetAddress, true);
        }
        catch (Exception ex) {
            this.handleInvokeException(ex);
        }
        finally {
            MessageContextAssociation.popMessageContext();
        }
    }

    private void handleInvokeException(Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)((Object)ex);
        }
        String msg = "Cannot dispatch message";
        this.log.error((Object)msg, (Throwable)ex);
        throw new WebServiceException(msg, (Throwable)ex);
    }

    public Map<String, Object> getRequestContext() {
        return this.bindingProvider.getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return this.bindingProvider.getResponseContext();
    }

    public Binding getBinding() {
        return this.bindingProvider.getBinding();
    }

    private void initDispatch() {
        if (!(SOAPMessage.class.isAssignableFrom(this.type) && this.mode == Service.Mode.MESSAGE || Source.class.isAssignableFrom(this.type) || this.jaxbContext != null && this.mode == Service.Mode.PAYLOAD)) {
            throw new WebServiceException("Illegal argument combination [type=" + (this.type != null ? this.type.getName() : null) + ",mode=" + this.mode + "]");
        }
    }

    private MessageAbstraction getRequestMessage(Object obj) {
        MessageAbstraction message;
        String bindingID;
        if (obj == null) {
            try {
                SOAPFactory factory = SOAPFactory.newInstance();
                SOAPFault fault = factory.createFault("Request object cannot be null", new QName("http://org.jboss.ws", "Dispatch"));
                fault.setFaultActor("client");
                throw new SOAPFaultException(fault);
            }
            catch (SOAPException e) {
                // empty catch block
            }
        }
        if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID = ((Binding21)this.bindingProvider.getBinding()).getBindingID())) {
            throw new IllegalStateException("Unsupported binding: " + bindingID);
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
            DispatchHTTPBinding helper = new DispatchHTTPBinding(this.mode, this.type, this.jaxbContext);
            this.epMetaData.configure(helper);
            message = helper.getRequestMessage(obj);
        } else {
            DispatchSOAPBinding helper = new DispatchSOAPBinding(this.mode, this.type, this.jaxbContext);
            this.epMetaData.configure(helper);
            message = helper.getRequestMessage(obj);
        }
        return message;
    }

    private Object getReturnObject(MessageAbstraction resMsg) {
        String bindingID = ((Binding21)this.bindingProvider.getBinding()).getBindingID();
        if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID)) {
            throw new IllegalStateException("Unsupported binding: " + bindingID);
        }
        Object retObj = null;
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
            DispatchHTTPBinding helper = new DispatchHTTPBinding(this.mode, this.type, this.jaxbContext);
            retObj = helper.getReturnObject(resMsg);
        } else {
            DispatchSOAPBinding helper = new DispatchSOAPBinding(this.mode, this.type, this.jaxbContext);
            retObj = helper.getReturnObject(resMsg);
        }
        return retObj;
    }

    public EndpointReference getEndpointReference() {
        throw new NotImplementedException();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        throw new NotImplementedException();
    }

    @Override
    public String getConfigFile() {
        return this.epMetaData.getConfigFile();
    }

    @Override
    public String getConfigName() {
        return this.epMetaData.getConfigName();
    }

    @Override
    public void setConfigName(String configName) {
        this.epMetaData.setConfigName(configName);
    }

    @Override
    public void setConfigName(String configName, String configFile) {
        this.epMetaData.setConfigName(configName, configFile);
    }

    @Override
    public String getSecurityConfig() {
        return this.securityConfig;
    }

    @Override
    public void setSecurityConfig(String securityConfig) {
        ServiceMetaData serviceMetaData;
        this.securityConfig = securityConfig;
        if (securityConfig != null && (serviceMetaData = this.epMetaData.getServiceMetaData()).getSecurityConfiguration() == null) {
            try {
                WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
                UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
                WSSecurityConfiguration config = wsseConfFactory.createConfiguration(vfsRoot, securityConfig);
                serviceMetaData.setSecurityConfiguration(config);
            }
            catch (IOException ex) {
                WSException.rethrow("Cannot set security config", ex);
            }
        }
    }

    private boolean callRequestHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        BindingExt binding = (BindingExt)this.bindingProvider.getBinding();
        HandlerChainExecutor executor = new HandlerChainExecutor(this.epMetaData, binding.getHandlerChain(type));
        this.executorMap.put(type, executor);
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        return executor.handleMessage(msgContext);
    }

    private boolean callResponseHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        return executor != null ? executor.handleMessage(msgContext) : true;
    }

    private boolean callFaultHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        return executor != null ? executor.handleFault(msgContext, ex) : true;
    }

    private void closeHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        if (executor != null) {
            executor.close(msgContext);
        }
    }

    private OperationMetaData getOperationMetaData(EndpointMetaData epMetaData, MessageAbstraction reqMessage) throws SOAPException {
        OperationMetaData opMetaData = null;
        if ("http://www.w3.org/2004/08/wsdl/http".equals(epMetaData.getBindingId()) && epMetaData.getOperations().size() == 1) {
            opMetaData = epMetaData.getOperations().get(0);
        } else if (reqMessage instanceof SOAPMessageImpl) {
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)reqMessage;
            opMetaData = soapMessage.getOperationMetaData(epMetaData);
        }
        if (opMetaData == null) {
            this.log.debug((Object)"Cannot find the right operation metadata!");
        }
        return opMetaData;
    }

    class AsyncRunnable
    implements Runnable {
        private ResponseImpl response;
        private AsyncHandler handler;
        private Object payload;

        public AsyncRunnable(ResponseImpl response, AsyncHandler handler, Object payload) {
            if (response == null) {
                throw new IllegalArgumentException("Async response cannot be null");
            }
            if (payload == null) {
                throw new IllegalArgumentException("Async payload cannot be null");
            }
            this.response = response;
            this.handler = handler;
            this.payload = payload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Map<String, Object> resContext = this.response.getContext();
                Object result = DispatchImpl.this.invokeInternal(this.payload, resContext);
                this.response.set(result);
            }
            catch (Exception ex) {
                this.handleAsynInvokeException(ex);
            }
            finally {
                if (this.handler != null) {
                    this.handler.handleResponse((Response)this.response);
                }
            }
        }

        private void handleAsynInvokeException(Exception ex) {
            String msg = "Cannot dispatch message";
            DispatchImpl.this.log.error((Object)msg, (Throwable)ex);
            WebServiceException wsex = ex instanceof WebServiceException ? (WebServiceException)((Object)ex) : new WebServiceException(msg, (Throwable)ex);
            this.response.setException(wsex);
        }
    }
}

