/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.interceptors.annotation.impl.InterceptorsImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PostActivateImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PostConstructImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PreDestroyImpl;
import org.jboss.ejb3.interceptors.annotation.impl.PrePassivateImpl;
import org.jboss.ejb3.interceptors.aop.annotation.DefaultInterceptors;
import org.jboss.ejb3.interceptors.aop.annotation.DefaultInterceptorsImpl;
import org.jboss.ejb3.interceptors.aop.annotation.InterceptorOrder;
import org.jboss.ejb3.interceptors.aop.annotation.InterceptorOrderImpl;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.ejb3.interceptors.metadata.EnvironmentInterceptorMetaDataBridge;
import org.jboss.ejb3.interceptors.util.InterceptorCollection;
import org.jboss.ejb3.metadata.MetaDataBridge;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInterceptorMetaDataBridge
extends EnvironmentInterceptorMetaDataBridge<JBossEnterpriseBeanMetaData>
implements MetaDataBridge<JBossEnterpriseBeanMetaData> {
    private static final Logger log = Logger.getLogger(BeanInterceptorMetaDataBridge.class);
    private volatile boolean initialisedBean;
    private DefaultInterceptors defaultInterceptors;
    private Interceptors interceptors;
    private InterceptorOrder interceptorOrder;
    private ExcludeDefaultInterceptors excludeDefaultInterceptors;
    private Map<Signature, Interceptors> methodInterceptors = new HashMap<Signature, Interceptors>();
    private Map<Signature, InterceptorOrder> methodInterceptorOrders = new HashMap<Signature, InterceptorOrder>();
    private Map<Signature, ExcludeDefaultInterceptors> methodExcludeDefaultInterceptors = new HashMap<Signature, ExcludeDefaultInterceptors>();
    private Map<Signature, ExcludeClassInterceptors> methodExcludeClassInterceptors = new HashMap<Signature, ExcludeClassInterceptors>();
    private Map<String, AroundInvoke> aroundInvokes;
    private Map<String, PostConstruct> postConstructs;
    private Map<String, PostActivate> postActivates;
    private Map<String, PrePassivate> prePassivates;
    private Map<String, PreDestroy> preDestroys;
    private Class<?> beanClass;
    private ClassLoader classLoader;
    private JBossEnterpriseBeanMetaData beanMetaData;
    public static long time;

    public BeanInterceptorMetaDataBridge(Class<?> beanClass, ClassLoader classLoader, JBossEnterpriseBeanMetaData beanMetaData) {
        assert (beanClass != null) : "beanClass is null";
        this.beanClass = beanClass;
        this.classLoader = classLoader;
        this.beanMetaData = beanMetaData;
        this.initialise();
    }

    protected Class<?> getBeanClass() {
        return this.beanClass;
    }

    private static boolean add(InterceptorCollection interceptors, ClassLoader classLoader, InterceptorBindingMetaData binding) {
        boolean result = false;
        Object interceptorClassesMetaData = binding.isTotalOrdering() ? binding.getInterceptorOrder() : binding.getInterceptorClasses();
        if (interceptorClassesMetaData != null) {
            for (String interceptorClassName : interceptorClassesMetaData) {
                result |= interceptors.addValue(BeanInterceptorMetaDataBridge.loadClass(classLoader, interceptorClassName));
            }
        }
        return result;
    }

    protected static boolean add(List<Class<?>> interceptors, ClassLoader classLoader, InterceptorBindingMetaData binding) {
        Object interceptorClassesMetaData = binding.isTotalOrdering() ? binding.getInterceptorOrder() : binding.getInterceptorClasses();
        for (String interceptorClassName : interceptorClassesMetaData) {
            interceptors.add(BeanInterceptorMetaDataBridge.loadClass(classLoader, interceptorClassName));
        }
        return true;
    }

    private static Class<?> loadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void initialise() {
        if (this.initialisedBean) {
            return;
        }
        ArrayList<InterceptorBindingMetaData> defaultInterceptorBindingMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> classInterceptorBindingMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> classInterceptorOrderMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> methodInterceptorBindingMetaData = new ArrayList<InterceptorBindingMetaData>();
        ArrayList<InterceptorBindingMetaData> methodInterceptorOrderMetaData = new ArrayList<InterceptorBindingMetaData>();
        this.setupMetaDataLists(this.beanMetaData, defaultInterceptorBindingMetaData, classInterceptorBindingMetaData, classInterceptorOrderMetaData, methodInterceptorBindingMetaData, methodInterceptorOrderMetaData);
        this.initialiseDefaultInterceptors(defaultInterceptorBindingMetaData);
        this.initialiseInterceptors(classInterceptorBindingMetaData);
        this.initialiseInterceptorOrder(classInterceptorOrderMetaData);
        Map<String, List<Method>> methodMap = ClassHelper.getAllMethodsMap(this.beanClass);
        MethodSignatures methodSignatures = new MethodSignatures();
        this.initialiseMethodInterceptors(methodMap, methodSignatures, methodInterceptorBindingMetaData);
        this.initialiseMethodInterceptorOrders(methodMap, methodSignatures, methodInterceptorOrderMetaData);
        this.initialiseAroundInvoke(methodMap);
    }

    private void setupMetaDataLists(JBossEnterpriseBeanMetaData beanMetaData, List<InterceptorBindingMetaData> defaultInterceptorBindingMetaData, List<InterceptorBindingMetaData> classInterceptorBindingMetaData, List<InterceptorBindingMetaData> classInterceptorOrderMetaData, List<InterceptorBindingMetaData> methodInterceptorBindingMetaData, List<InterceptorBindingMetaData> methodInterceptorOrderMetaData) {
        try {
            InterceptorBindingsMetaData bindings = beanMetaData.getEjbJarMetaData().getAssemblyDescriptor().getInterceptorBindings();
            if (bindings != null) {
                String ejbName = beanMetaData.getEjbName();
                for (InterceptorBindingMetaData binding : bindings) {
                    String bindingEjbName = binding.getEjbName();
                    this.checkBeanExistsInDeployment(beanMetaData, bindingEjbName);
                    if (bindingEjbName.equals("*")) {
                        assert (binding.getMethod() == null) : "method binding not allowed on default interceptor";
                        defaultInterceptorBindingMetaData.add(binding);
                        continue;
                    }
                    if (!bindingEjbName.equals(ejbName)) continue;
                    if (binding.getMethod() == null) {
                        if (binding.isTotalOrdering()) {
                            classInterceptorOrderMetaData.add(binding);
                            continue;
                        }
                        classInterceptorBindingMetaData.add(binding);
                        continue;
                    }
                    if (binding.isTotalOrdering()) {
                        methodInterceptorOrderMetaData.add(binding);
                        continue;
                    }
                    methodInterceptorBindingMetaData.add(binding);
                }
            }
        }
        catch (NullPointerException e) {
            if (beanMetaData == null) {
                throw new IllegalStateException("Null beannMetaData", e);
            }
            if (beanMetaData.getEjbJarMetaData() == null) {
                throw new IllegalStateException("Null ejbJarMetaData", e);
            }
            if (beanMetaData.getEjbJarMetaData().getAssemblyDescriptor() == null) {
                throw new IllegalStateException("Null AssemblyDescriptor", e);
            }
            throw e;
        }
    }

    private void initialiseDefaultInterceptors(List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            ArrayList classes = new ArrayList();
            for (InterceptorBindingMetaData binding : bindings) {
                BeanInterceptorMetaDataBridge.add(classes, this.classLoader, binding);
            }
            if (!classes.isEmpty()) {
                this.defaultInterceptors = new DefaultInterceptorsImpl(classes);
            }
        }
    }

    private void initialiseInterceptors(List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            InterceptorsImpl interceptors = new InterceptorsImpl();
            for (InterceptorBindingMetaData binding : bindings) {
                BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                this.checkClassLevelExcludeDefaultInterceptors(binding);
            }
            if (!interceptors.isEmpty()) {
                this.interceptors = interceptors;
            }
        }
    }

    private void initialiseInterceptorOrder(List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            InterceptorOrderImpl interceptors = new InterceptorOrderImpl();
            for (InterceptorBindingMetaData binding : bindings) {
                BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                this.checkClassLevelExcludeDefaultInterceptors(binding);
            }
            if (!interceptors.isEmpty()) {
                this.interceptorOrder = interceptors;
            }
        }
    }

    private void checkClassLevelExcludeDefaultInterceptors(InterceptorBindingMetaData binding) {
        ExcludeDefaultInterceptors exDefaultInterceptors = this.checkExcludeDefaultInterceptors(binding);
        if (exDefaultInterceptors != null) {
            this.excludeDefaultInterceptors = exDefaultInterceptors;
        }
    }

    private ExcludeDefaultInterceptors checkExcludeDefaultInterceptors(InterceptorBindingMetaData binding) {
        if (binding.isExcludeDefaultInterceptors()) {
            return new ExcludeDefaultInterceptors(){

                public Class<? extends Annotation> annotationType() {
                    return ExcludeDefaultInterceptors.class;
                }
            };
        }
        return null;
    }

    private void addMethodLevelExclusions(Signature sig, InterceptorBindingMetaData binding) {
        ExcludeDefaultInterceptors exDefaultInterceptors = this.checkExcludeDefaultInterceptors(binding);
        if (exDefaultInterceptors != null) {
            this.methodExcludeDefaultInterceptors.put(sig, exDefaultInterceptors);
        }
        if (binding.isExcludeClassInterceptors()) {
            this.methodExcludeClassInterceptors.put(sig, new ExcludeClassInterceptors(){

                public Class<? extends Annotation> annotationType() {
                    return ExcludeClassInterceptors.class;
                }
            });
        }
    }

    private void initialiseMethodInterceptors(Map<String, List<Method>> methodMap, MethodSignatures methodSignatures, List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            this.methodInterceptors = new HashMap<Signature, Interceptors>();
            for (InterceptorBindingMetaData binding : bindings) {
                NamedMethodMetaData method = binding.getMethod();
                if (method.getMethodName() == null) continue;
                List<Method> methods = methodMap.get(method.getMethodName());
                if (methods == null) {
                    throw new IllegalStateException("Bean class " + this.beanClass.getName() + " does not have a method called '" + method.getMethodName() + "'. This method name was used in an interceptor-binding entry.");
                }
                for (Method refMethod : methods) {
                    Signature signature = methodSignatures.getSignature(refMethod);
                    if (!this.matchesMethod(signature, refMethod, method)) continue;
                    InterceptorsImpl interceptors = (InterceptorsImpl)this.methodInterceptors.get(signature);
                    if (interceptors == null) {
                        interceptors = new InterceptorsImpl();
                        this.methodInterceptors.put(signature, interceptors);
                    }
                    BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                    this.addMethodLevelExclusions(signature, binding);
                }
            }
        }
    }

    private void initialiseMethodInterceptorOrders(Map<String, List<Method>> methodMap, MethodSignatures methodSignatures, List<InterceptorBindingMetaData> bindings) {
        if (bindings != null && bindings.size() > 0) {
            this.methodInterceptorOrders = new HashMap<Signature, InterceptorOrder>();
            for (InterceptorBindingMetaData binding : bindings) {
                NamedMethodMetaData method = binding.getMethod();
                if (method.getMethodName() == null) continue;
                List<Method> methods = methodMap.get(method.getMethodName());
                for (Method refMethod : methods) {
                    Signature signature = methodSignatures.getSignature(refMethod);
                    if (!this.matchesMethod(signature, refMethod, method)) continue;
                    InterceptorOrderImpl interceptors = (InterceptorOrderImpl)this.methodInterceptors.get(signature);
                    if (interceptors == null) {
                        interceptors = new InterceptorOrderImpl();
                        this.methodInterceptorOrders.put(signature, interceptors);
                    }
                    BeanInterceptorMetaDataBridge.add(interceptors, this.classLoader, binding);
                }
            }
        }
    }

    private boolean matchesMethod(Signature sig, Method refMethod, NamedMethodMetaData method) {
        assert (refMethod.getName().equals(method.getMethodName()));
        MethodParametersMetaData methodParams = method.getMethodParams();
        if (methodParams == null) {
            return true;
        }
        return Arrays.equals(methodParams.toArray(), sig.getParameters());
    }

    private void initialiseAroundInvoke(Map<String, List<Method>> methodMap) {
        AroundInvokesMetaData aroundInvokes = null;
        if (this.beanMetaData instanceof JBossMessageDrivenBeanMetaData) {
            aroundInvokes = ((JBossMessageDrivenBeanMetaData)this.beanMetaData).getAroundInvokes();
        } else if (this.beanMetaData instanceof JBossSessionBeanMetaData) {
            aroundInvokes = ((JBossSessionBeanMetaData)this.beanMetaData).getAroundInvokes();
        }
        if (aroundInvokes != null) {
            for (String methodName : methodMap.keySet()) {
                AroundInvoke aroundInvoke = this.getAroundInvokeAnnotation(aroundInvokes, methodName);
                if (aroundInvoke == null) continue;
                if (this.aroundInvokes == null) {
                    this.aroundInvokes = new HashMap<String, AroundInvoke>();
                }
                this.aroundInvokes.put(methodName, aroundInvoke);
            }
        }
    }

    private void initialiseLifecycleAnnotations(Map<String, List<Method>> methodMap) {
        if (this.beanMetaData instanceof JBossSessionBeanMetaData) {
            for (String methodName : methodMap.keySet()) {
                PreDestroy preDestroy;
                PrePassivate prePassivate;
                PostActivate postActivate;
                PostConstruct postConstruct = this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPostConstructs(), PostConstructImpl.class, methodName);
                if (postConstruct != null) {
                    if (this.postConstructs == null) {
                        this.postConstructs = new HashMap<String, PostConstruct>();
                    }
                    this.postConstructs.put(methodName, postConstruct);
                }
                if ((postActivate = (PostActivate)this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPostActivates(), PostActivateImpl.class, methodName)) != null) {
                    if (this.postActivates == null) {
                        this.postActivates = new HashMap<String, PostActivate>();
                    }
                    this.postActivates.put(methodName, postActivate);
                }
                if ((prePassivate = (PrePassivate)this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPrePassivates(), PrePassivateImpl.class, methodName)) != null) {
                    if (this.prePassivates == null) {
                        this.prePassivates = new HashMap<String, PrePassivate>();
                    }
                    this.prePassivates.put(methodName, prePassivate);
                }
                if ((preDestroy = (PreDestroy)this.getLifeCycleAnnotation(((JBossSessionBeanMetaData)this.beanMetaData).getPreDestroys(), PreDestroyImpl.class, methodName)) == null) continue;
                if (this.preDestroys == null) {
                    this.preDestroys = new HashMap<String, PreDestroy>();
                }
                this.preDestroys.put(methodName, preDestroy);
            }
        }
    }

    @Override
    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData beanMetaData, ClassLoader classLoader) {
        if (annotationClass == DefaultInterceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.defaultInterceptors));
        }
        if (annotationClass == InterceptorOrder.class) {
            return (A)((Annotation)annotationClass.cast(this.interceptorOrder));
        }
        if (annotationClass == Interceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.interceptors));
        }
        if (annotationClass == ExcludeDefaultInterceptors.class) {
            return (A)((Annotation)annotationClass.cast(this.excludeDefaultInterceptors));
        }
        return super.retrieveAnnotation(annotationClass, beanMetaData, classLoader);
    }

    @Override
    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData beanMetaData, ClassLoader classLoader, String methodName, String ... parameterNames) {
        if (annotationClass == AroundInvoke.class) {
            if (parameterNames.length == 1 && parameterNames[0].equals(InvocationContext.class.getName()) && this.aroundInvokes != null) {
                return (A)((Annotation)annotationClass.cast(this.aroundInvokes.get(methodName)));
            }
            return null;
        }
        if (annotationClass == InterceptorOrder.class) {
            MethodSignature signature = new MethodSignature(methodName, parameterNames);
            if (this.methodInterceptorOrders == null) {
                return null;
            }
            return (A)((Annotation)annotationClass.cast(this.methodInterceptorOrders.get(signature)));
        }
        if (annotationClass == Interceptors.class) {
            MethodSignature signature = new MethodSignature(methodName, parameterNames);
            if (this.methodInterceptors == null) {
                return null;
            }
            return (A)((Annotation)annotationClass.cast(this.methodInterceptors.get(signature)));
        }
        if (annotationClass == ExcludeDefaultInterceptors.class) {
            MethodSignature signature = new MethodSignature(methodName, parameterNames);
            return (A)((Annotation)annotationClass.cast(this.methodExcludeDefaultInterceptors.get(signature)));
        }
        if (annotationClass == ExcludeClassInterceptors.class) {
            MethodSignature signature = new MethodSignature(methodName, parameterNames);
            return (A)((Annotation)annotationClass.cast(this.methodExcludeClassInterceptors.get(signature)));
        }
        if (annotationClass == PostActivate.class) {
            if (beanMetaData instanceof JBossSessionBeanMetaData && parameterNames.length == 0 && this.postActivates != null) {
                return (A)((Annotation)annotationClass.cast(this.postActivates.get(methodName)));
            }
        } else if (annotationClass == PostConstruct.class) {
            if (beanMetaData instanceof JBossSessionBeanMetaData && parameterNames.length == 0 && this.postConstructs != null) {
                return (A)((Annotation)annotationClass.cast(this.postConstructs.get(methodName)));
            }
        } else if (annotationClass == PreDestroy.class) {
            if (beanMetaData instanceof JBossSessionBeanMetaData && parameterNames.length == 0 && this.preDestroys != null) {
                return (A)((Annotation)annotationClass.cast(this.preDestroys.get(methodName)));
            }
        } else if (annotationClass == PrePassivate.class && beanMetaData instanceof JBossSessionBeanMetaData && parameterNames.length == 0 && this.prePassivates != null) {
            return (A)((Annotation)annotationClass.cast(this.prePassivates.get(methodName)));
        }
        return super.retrieveAnnotation(annotationClass, beanMetaData, classLoader, methodName, parameterNames);
    }

    private void checkBeanExistsInDeployment(JBossEnterpriseBeanMetaData beanMetaData, String ejbName) {
        if (ejbName.equals("*")) {
            return;
        }
        JBossEnterpriseBeansMetaData beansMetaData = beanMetaData.getEnterpriseBeansMetaData();
        if (beansMetaData.get(ejbName) == null) {
            throw new IllegalArgumentException("No bean with name specified in interceptor-binding: " + ejbName);
        }
    }

    private static class MethodSignatures {
        Map<Method, Signature> methodSignatures = new HashMap<Method, Signature>();

        private MethodSignatures() {
        }

        Signature getSignature(Method m) {
            Signature s = this.methodSignatures.get(m);
            if (s == null) {
                s = new MethodSignature(m);
                this.methodSignatures.put(m, s);
            }
            return s;
        }
    }
}

