/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.LinkedList;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.framework.management.recording.ManagedRecordProcessor;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.recording.RecordProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRecordProcessorDeploymentAspect
extends DeploymentAspect {
    private MBeanServer mbeanServer;
    private List<RecordProcessor> processors;

    public void setProcessors(List<RecordProcessor> processors) {
        this.processors = processors;
    }

    public void start(Deployment dep, WSFRuntime runtime) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            LinkedList<RecordProcessor> processorList = new LinkedList<RecordProcessor>();
            if (this.processors != null) {
                for (RecordProcessor pr : this.processors) {
                    try {
                        RecordProcessor clone = (RecordProcessor)pr.clone();
                        this.registerRecordProcessor(clone, ep);
                        processorList.add(clone);
                    }
                    catch (CloneNotSupportedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            ep.setRecordProcessors(processorList);
        }
    }

    public void destroy(Deployment dep, WSFRuntime runtime) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            List processors = ep.getRecordProcessors();
            for (RecordProcessor processor : processors) {
                this.unregisterRecordProcessor(processor, ep);
            }
        }
    }

    private void registerRecordProcessor(RecordProcessor processor, Endpoint ep) {
        try {
            this.mbeanServer.registerMBean(processor, ObjectNameFactory.create((String)(ep.getName() + ",recordProcessor=" + processor.getName())));
        }
        catch (JMException ex) {
            this.log.debug((Object)("Cannot register endpoint with JMX server, trying with the default ManagedRecordProcessor: " + ex.getMessage()));
            try {
                this.mbeanServer.registerMBean(new ManagedRecordProcessor(processor), ObjectNameFactory.create((String)(ep.getName() + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException innerEx) {
                this.log.error((Object)"Cannot register endpoint with JMX server", (Throwable)innerEx);
            }
        }
    }

    private void unregisterRecordProcessor(RecordProcessor processor, Endpoint ep) {
        try {
            this.mbeanServer.unregisterMBean(ObjectNameFactory.create((String)(ep.getName() + ",recordProcessor=" + processor.getName())));
        }
        catch (JMException ex) {
            this.log.error((Object)"Cannot unregister record processor with JMX server", (Throwable)ex);
        }
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }
}

