/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.resource.deployers.management.DsDataSourceTemplateInfo;
import org.jboss.resource.deployers.management.LocalDSInstanceClassFactory;
import org.jboss.resource.deployers.management.NoTxCFInstanceClassFactory;
import org.jboss.resource.deployers.management.NoTxInstanceClassFactory;
import org.jboss.resource.deployers.management.TxInstanceClassFactory;
import org.jboss.resource.deployers.management.XADSInstanceClassFactory;
import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
import org.jboss.virtual.VirtualFile;

public class DsDataSourceTemplate
implements DeploymentTemplate {
    private static final Logger log = Logger.getLogger(DsDataSourceTemplate.class);
    private DeploymentTemplateInfo info;

    public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values) throws Exception {
        String dsName = deploymentBaseName + "-ds.xml";
        URI dsXmlURI = new URI(root.toURI() + dsName);
        File dsXml = new File(dsXmlURI.getPath());
        this.writeTemplate(dsXml, values);
        return root.findChild(dsName);
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTemplate(File dsXml, DeploymentTemplateInfo values) throws Exception {
        ManagedObject cfMO;
        LocalDataSourceDeploymentMetaData mcf;
        String cfType = ((DsDataSourceTemplateInfo)values).getConnectionFactoryType();
        ManagedObjectFactory mof = ManagedObjectFactoryBuilder.create();
        String rootElementName = "datasources";
        if ("local-tx-datasource".equals(cfType)) {
            mcf = new LocalDataSourceDeploymentMetaData();
            mof.setInstanceClassFactory(LocalDataSourceDeploymentMetaData.class, (InstanceClassFactory)new LocalDSInstanceClassFactory());
            cfMO = mof.initManagedObject((Serializable)mcf, KnownComponentTypes.DataSourceTypes.LocalTx.getType().getType(), KnownComponentTypes.DataSourceTypes.LocalTx.getType().getSubtype());
        } else if ("xa-datasource".equals(cfType)) {
            mcf = new XADataSourceDeploymentMetaData();
            mof.setInstanceClassFactory(XADataSourceDeploymentMetaData.class, (InstanceClassFactory)new XADSInstanceClassFactory());
            cfMO = mof.initManagedObject((Serializable)mcf, KnownComponentTypes.DataSourceTypes.XA.getType().getType(), KnownComponentTypes.DataSourceTypes.XA.getType().getSubtype());
        } else if ("tx-connection-factory".equals(cfType)) {
            rootElementName = "connection-factories";
            mcf = new TxConnectionFactoryDeploymentMetaData();
            mof.setInstanceClassFactory(TxConnectionFactoryDeploymentMetaData.class, (InstanceClassFactory)new TxInstanceClassFactory());
            cfMO = mof.initManagedObject((Serializable)mcf, KnownComponentTypes.ConnectionFactoryTypes.XA.getType().getType(), KnownComponentTypes.ConnectionFactoryTypes.XA.getType().getSubtype());
        } else if ("no-tx-connection-factory".equals(cfType)) {
            rootElementName = "connection-factories";
            mcf = new NoTxConnectionFactoryDeploymentMetaData();
            mof.setInstanceClassFactory(NoTxConnectionFactoryDeploymentMetaData.class, (InstanceClassFactory)new NoTxCFInstanceClassFactory());
            cfMO = mof.initManagedObject((Serializable)mcf, KnownComponentTypes.ConnectionFactoryTypes.NoTx.getType().getType(), KnownComponentTypes.ConnectionFactoryTypes.NoTx.getType().getSubtype());
        } else if ("no-tx-datasource".equals(cfType)) {
            mcf = new NoTxDataSourceDeploymentMetaData();
            mof.setInstanceClassFactory(NoTxDataSourceDeploymentMetaData.class, (InstanceClassFactory)new NoTxInstanceClassFactory());
            cfMO = mof.initManagedObject((Serializable)mcf, KnownComponentTypes.DataSourceTypes.NoTx.getType().getType(), KnownComponentTypes.DataSourceTypes.NoTx.getType().getSubtype());
        } else {
            throw new IllegalStateException("Unexpected value connection factory type: " + cfType);
        }
        ManagedConnectionFactoryDeploymentGroup group = new ManagedConnectionFactoryDeploymentGroup();
        group.addManagedConnectionFactoryDeployment((ManagedConnectionFactoryDeploymentMetaData)mcf);
        boolean logTrace = log.isTraceEnabled();
        for (ManagedProperty tempProp : values.getProperties().values()) {
            ManagedProperty dsProp = cfMO.getProperty(tempProp.getName());
            if (dsProp != null) {
                if (logTrace) {
                    log.trace((Object)("setting " + tempProp.getName() + "=" + tempProp.getValue()));
                }
                dsProp.setValue((Serializable)tempProp.getValue());
                continue;
            }
            if (!logTrace) continue;
            log.trace((Object)("property not found: " + tempProp.getName()));
        }
        Class[] classes = new Class[]{ManagedConnectionFactoryDeploymentGroup.class};
        JAXBContext context = JAXBContext.newInstance((Class[])classes);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        JAXBElement root = new JAXBElement(new QName(rootElementName), ManagedConnectionFactoryDeploymentGroup.class, null, (Object)group);
        FileWriter fw = null;
        try {
            fw = new FileWriter(dsXml);
            marshaller.marshal((Object)root, (Writer)fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }
}

