/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.builder;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.resource.connectionmanager.NoTxConnectionManager;
import org.jboss.resource.connectionmanager.TxConnectionManager;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManagerBuilder
extends AbstractBuilder {
    private static final String CCM_JMX = "jboss.jca:service=CachedConnectionManager";
    private static final String JAAS_JMX = "jboss.security:service=JaasSecurityManager";
    private static final String TM_JMX = "jboss:service=TransactionManager";
    private static final String POOL_JMX = "jboss.jca:service=ManagedConnectionPool,name=";
    private static final String SUBJECT_FACTORY_NAME = "JBossSecuritySubjectFactory";
    private String ccmJMXName = "jboss.jca:service=CachedConnectionManager";
    private String jaasJMXName = "jboss.security:service=JaasSecurityManager";
    private String jaasJndiBeanName = "JBossSecurityJNDIContextEstablishment";
    private String subjectFactoryName = "JBossSecuritySubjectFactory";
    private String tmJMXName = "jboss:service=TransactionManager";
    private String poolJMXPrefix = "jboss.jca:service=ManagedConnectionPool,name=";

    public String getCcmJMXName() {
        return this.ccmJMXName;
    }

    public void setCcmJMXName(String ccmJMXName) {
        this.ccmJMXName = ccmJMXName;
    }

    public String getJaasJMXName() {
        return this.jaasJMXName;
    }

    public void setJaasJMXName(String jaasJMXName) {
        this.jaasJMXName = jaasJMXName;
    }

    public String getJaasJndiBeanName() {
        return this.jaasJndiBeanName;
    }

    public void setJaasJndiBeanName(String jaasJndiBeanName) {
        this.jaasJndiBeanName = jaasJndiBeanName;
    }

    public String getSubjectFactoryName() {
        return this.subjectFactoryName;
    }

    public void setSubjectFactoryName(String subjectFactoryName) {
        this.subjectFactoryName = subjectFactoryName;
    }

    public String getTmJMXName() {
        return this.tmJMXName;
    }

    public void setTmJMXName(String tmJMXName) {
        this.tmJMXName = tmJMXName;
    }

    public String getPoolJMXPrefix() {
        return this.poolJMXPrefix;
    }

    public void setPoolJMXPrefix(String poolJMXPrefix) {
        this.poolJMXPrefix = poolJMXPrefix;
    }

    @Override
    public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md) {
        ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attribute = null;
        attribute = this.buildSimpleAttribute("JndiName", md.getJndiName());
        attributes.add(attribute);
        if (md.getSecurityMetaData() != null && md.getSecurityMetaData().getDomain() != null && !md.getSecurityMetaData().getDomain().equals("")) {
            attribute = this.buildSimpleAttribute("SecurityDomainJndiName", md.getSecurityMetaData().getDomain());
            attributes.add(attribute);
        }
        attribute = new ServiceAttributeMetaData();
        attribute.setName("SubjectFactory");
        ServiceInjectionValueMetaData injectionValue = new ServiceInjectionValueMetaData((Object)this.subjectFactoryName);
        attribute.setValue((ServiceValueMetaData)injectionValue);
        attributes.add(attribute);
        attribute = this.buildDependencyAttribute("CachedConnectionManager", this.ccmJMXName);
        attributes.add(attribute);
        attribute = this.buildDependencyAttribute("JaasSecurityManagerService", this.jaasJMXName);
        attributes.add(attribute);
        attribute = this.buildDependencyAttribute("ManagedConnectionPool", this.poolJMXPrefix + md.getJndiName());
        attributes.add(attribute);
        if (!md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE)) {
            attribute = this.buildDependencyAttribute("TransactionManagerService", this.tmJMXName);
            attributes.add(attribute);
            attribute = this.buildSimpleAttribute("LocalTransactions", String.valueOf(md.getLocalTransactions()));
            attributes.add(attribute);
            attribute = this.buildSimpleAttribute("TrackConnectionByTx", String.valueOf(md.getTrackConnectionByTransaction()));
            attributes.add(attribute);
            if (md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.XA)) {
                // empty if block
            }
        }
        return attributes;
    }

    @Override
    public List<ServiceDependencyMetaData> buildDependencies(ManagedConnectionFactoryDeploymentMetaData md) {
        List<ServiceDependencyMetaData> dependencies = super.buildDependencies(md);
        ServiceDependencyMetaData serviceDependencyMetaData = new ServiceDependencyMetaData();
        serviceDependencyMetaData.setIDependOn(this.jaasJndiBeanName);
        dependencies.add(serviceDependencyMetaData);
        return dependencies;
    }

    @Override
    public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md) {
        String cmType = "jboss.jca:service=";
        String jndiName = md.getJndiName();
        cmType = md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE) ? cmType + "NoTxCM,name=" + jndiName : (md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.LOCAL) ? (md instanceof DataSourceDeploymentMetaData ? cmType + "LocalTxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName) : (md instanceof DataSourceDeploymentMetaData ? cmType + "XATxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName));
        return ObjectNameFactory.create((String)cmType);
    }

    @Override
    public String getCode(ManagedConnectionFactoryDeploymentMetaData md) {
        String code = null;
        code = md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE) ? NoTxConnectionManager.class.getName() : TxConnectionManager.class.getName();
        return code;
    }
}

