/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.io.Serializable;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.SimpleValue;

public class SimpleValueSupport
extends AbstractMetaValue
implements SimpleValue {
    private static final long serialVersionUID = 8473043036261557127L;
    private SimpleMetaType metaType;
    private Serializable value;

    public static SimpleValue wrap(Serializable object) {
        if (object == null) {
            return null;
        }
        String className = object.getClass().getName();
        SimpleMetaType metaType = SimpleMetaType.resolve(className);
        return new SimpleValueSupport(metaType, object);
    }

    public SimpleValueSupport(SimpleMetaType metaType, Serializable value) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null simple meta type");
        }
        this.metaType = metaType;
        this.setValue(value);
    }

    public SimpleMetaType getMetaType() {
        return this.metaType;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SimpleValue)) {
            return false;
        }
        SimpleValue other = (SimpleValue)obj;
        if (!this.metaType.equals(other.getMetaType())) {
            return false;
        }
        Serializable otherValue = other.getValue();
        if (this.value == null && otherValue == null) {
            return true;
        }
        if (this.value == null && otherValue != null) {
            return false;
        }
        return this.value.equals(otherValue);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.metaType + ":" + this.value;
    }
}

