/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMetaType
extends AbstractMetaType {
    private static final long serialVersionUID = 6786422588217893696L;
    private List<String> validValues;

    public EnumMetaType(String className, List<String> validValues) {
        super(String.class.getName(), className, className);
        if (validValues == null) {
            throw new IllegalArgumentException("Null valid values");
        }
        this.validValues = validValues;
    }

    public EnumMetaType(Enum<?>[] validValues) {
        super(String.class.getName(), EnumMetaType.isValid(validValues) ? validValues[0].getClass().getName() : null, EnumMetaType.isValid(validValues) ? validValues[0].getClass().getName() : null);
        if (!EnumMetaType.isValid(validValues)) {
            throw new IllegalArgumentException("Null or empty valid values");
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Enum<?> e : validValues) {
            values.add(e.name());
        }
        this.validValues = values;
    }

    protected static boolean isValid(Enum<?>[] values) {
        return values != null && values.length > 0;
    }

    public List<String> getValidValues() {
        return Collections.unmodifiableList(this.validValues);
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof SimpleValue)) {
            return false;
        }
        SimpleValue value = (SimpleValue)obj;
        if (!(SimpleMetaType.STRING == value.getMetaType())) {
            return false;
        }
        return this.validValues.contains(value.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof EnumMetaType)) {
            return false;
        }
        EnumMetaType other = (EnumMetaType)obj;
        return this.getTypeName().equals(other.getTypeName()) && ((Object)this.getValidValues()).equals(other.getValidValues());
    }

    public String toString() {
        return this.getTypeName() + "{" + this.validValues + "}";
    }
}

