/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;

public class NonSerializableAttributeTester
implements HttpSessionAttributeListener {
    public void attributeAdded(HttpSessionBindingEvent event) {
        this.testAttributeSerializability(event.getName(), event.getValue());
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.testAttributeSerializability(event.getName(), event.getValue());
    }

    private void testAttributeSerializability(String name, Object value) {
        if (!this.testSerializability(value)) {
            System.out.println(name + " of type " + value.getClass() + " cannot be serialized");
            this.testRecursively(value);
        }
    }

    private boolean testSerializability(Object obj) {
        if (obj == null) {
            return true;
        }
        if (!(obj instanceof Serializable)) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (NotSerializableException io) {
            return false;
        }
        catch (IOException io) {
            System.out.println("Unexpected IOException");
            io.printStackTrace(System.out);
        }
        return true;
    }

    private void testRecursively(Object obj) {
        if (obj instanceof Collection) {
            this.testCollectionSerializability((Collection)obj);
        } else if (obj instanceof Map) {
            this.testMapSerializability((Map)obj);
        }
    }

    private void testCollectionSerializability(Collection coll) {
        System.out.println("Testing Collection elements");
        int i = 0;
        for (Object obj : coll) {
            if (!this.testSerializability(obj)) {
                System.out.println("Element " + i + " of type " + obj.getClass() + " cannot be serialized");
                this.testRecursively(obj);
            }
            ++i;
        }
    }

    private void testMapSerializability(Map map) {
        System.out.println("Testing Map entries");
        for (Map.Entry entry : map.entrySet()) {
            if (!this.testSerializability(entry.getKey())) {
                System.out.println("Map Key " + entry.getKey() + " of type " + entry.getKey().getClass() + " cannot be serialized");
                this.testRecursively(entry.getKey());
                continue;
            }
            if (this.testSerializability(entry.getValue())) continue;
            System.out.println("Map value under Key " + entry.getKey() + " of type " + entry.getValue().getClass() + " cannot be serialized");
            this.testRecursively(entry.getValue());
        }
    }
}

