/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.apache.catalina.Container;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.ha.framework.server.MarshalledValueHelper;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.CacheListener;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.PassivationListener;
import org.jboss.web.tomcat.service.session.SessionSerializationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheService {
    protected static Logger log_ = Logger.getLogger(JBossCacheService.class);
    public static final String BUDDY_BACKUP = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_FQN = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN;
    public static final String SESSION = "JSESSION";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String VERSION_KEY = "V";
    public static final String TIMESTAMP_KEY = "T";
    public static final String METADATA_KEY = "M";
    public static final String ATTRIBUTE_KEY = "A";
    public static final String FQN_DELIMITER = "/";
    private Cache plainCache_;
    protected String hostName_;
    protected String webAppPath_;
    protected TransactionManager tm;
    private JBossCacheManager manager_;
    private CacheListener cacheListener_;
    protected JBossCacheWrapper cacheWrapper_;
    private boolean useTreeCacheMarshalling_ = false;
    private boolean usePassivation_ = false;
    private PassivationListener passivationListener_;
    private boolean useBuddyReplication_ = false;

    public JBossCacheService(Cache cache) {
        this.plainCache_ = cache;
        this.cacheWrapper_ = new JBossCacheWrapper(this.plainCache_);
        this.useTreeCacheMarshalling_ = this.plainCache_.getConfiguration().isUseRegionBasedMarshalling();
        CacheLoaderConfig clc = this.plainCache_.getConfiguration().getCacheLoaderConfig();
        if (clc != null) {
            this.usePassivation_ = clc.isPassivation() && !clc.isShared();
        }
    }

    protected JBossCacheManager getManager() {
        return this.manager_;
    }

    protected Cache getCache() {
        return this.plainCache_;
    }

    protected void setCache(Cache cache) {
        this.plainCache_ = cache;
    }

    public void start(ClassLoader tcl, JBossCacheManager manager) {
        this.manager_ = manager;
        Container webapp = this.manager_.getContainer();
        String path = webapp.getName();
        this.webAppPath_ = path.length() == 0 || path.equals(FQN_DELIMITER) ? "ROOT" : (path.startsWith(FQN_DELIMITER) ? path.substring(1) : path);
        this.webAppPath_ = this.webAppPath_.replace('/', '?');
        log_.debug((Object)("Old and new web app path are: " + path + ", " + this.webAppPath_));
        String host = webapp.getParent().getName();
        this.hostName_ = host == null || host.length() == 0 ? "localhost" : host;
        log_.debug((Object)("Old and new virtual host name are: " + host + ", " + this.hostName_));
        this.tm = this.plainCache_.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (!(this.tm instanceof BatchModeTransactionManager)) {
            throw new RuntimeException("start(): JBoss Cache transaction manager is not of type BatchModeTransactionManager. It is " + (this.tm == null ? "null" : this.tm.getClass().getName()));
        }
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        Fqn pathFqn = new Fqn(objs);
        BuddyReplicationConfig brc = this.plainCache_.getConfiguration().getBuddyReplicationConfig();
        boolean bl = this.useBuddyReplication_ = brc != null && brc.isEnabled();
        if (this.useTreeCacheMarshalling_ || this.useBuddyReplication_) {
            this.cleanWebappRegion(pathFqn);
        }
        this.cacheListener_ = new CacheListener(this.cacheWrapper_, this.manager_, this.hostName_, this.webAppPath_);
        this.plainCache_.addCacheListener((Object)this.cacheListener_);
        if (this.useTreeCacheMarshalling_) {
            try {
                log_.debug((Object)("UseMarshalling is true. We will register the fqn: " + pathFqn + " with class loader" + tcl + " and activate the webapp's Region"));
                Node root = this.plainCache_.getRoot();
                if (!root.hasChild(pathFqn)) {
                    this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                    root.addChild(pathFqn);
                }
                Region region = this.plainCache_.getRegion(pathFqn, true);
                region.registerContextClassLoader(tcl);
                region.activate();
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't register class loader", ex);
            }
        }
        if (this.manager_.isPassivationEnabled()) {
            log_.debug((Object)"Passivation is enabled");
            this.passivationListener_ = new PassivationListener(this.manager_, this.hostName_, this.webAppPath_);
            this.plainCache_.addCacheListener((Object)this.passivationListener_);
        } else {
            log_.debug((Object)"Passivation is disabled");
        }
    }

    private void cleanWebappRegion(Fqn regionFqn) {
        try {
            this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.plainCache_.removeNode(regionFqn);
        }
        catch (CacheException e) {
            log_.error((Object)"can't clean content from the underlying distributed cache");
        }
    }

    public void stop() {
        BuddyReplicationConfig brc;
        this.plainCache_.removeCacheListener((Object)this.cacheListener_);
        if (this.passivationListener_ != null) {
            this.plainCache_.removeCacheListener((Object)this.passivationListener_);
        }
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        Fqn pathFqn = new Fqn(objs);
        if (this.useTreeCacheMarshalling_) {
            log_.debug((Object)("UseMarshalling is true. We will inactivate the fqn: " + pathFqn + " and un-register its classloader"));
            try {
                Region region = this.plainCache_.getRegion(pathFqn, false);
                if (region != null) {
                    region.deactivate();
                    region.unregisterContextClassLoader();
                }
            }
            catch (Exception e) {
                log_.error((Object)("Exception during inactivation of webapp region " + pathFqn + " or un-registration of its class loader"), (Throwable)e);
            }
        }
        boolean bl = this.useBuddyReplication_ = (brc = this.plainCache_.getConfiguration().getBuddyReplicationConfig()) != null && brc.isEnabled();
        if (this.useTreeCacheMarshalling_ || this.useBuddyReplication_) {
            this.cleanWebappRegion(pathFqn);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean isMarshallingAvailable() {
        return this.useTreeCacheMarshalling_;
    }

    public JBossCacheClusteredSession loadSession(String realId, JBossCacheClusteredSession toLoad) {
        Fqn fqn = this.getSessionFqn(realId);
        Map sessionData = this.cacheWrapper_.getData(fqn, true);
        if (sessionData == null) {
            return null;
        }
        this.setupSessionRegion(toLoad, fqn);
        Integer version = (Integer)sessionData.get(VERSION_KEY);
        ClusteredSession.SessionTimestamp timestamp = (ClusteredSession.SessionTimestamp)sessionData.get(TIMESTAMP_KEY);
        ClusteredSession.SessionMetadata metadata = (ClusteredSession.SessionMetadata)sessionData.get(METADATA_KEY);
        Map attrs = (Map)this.getUnMarshalledValue(sessionData.get(ATTRIBUTE_KEY));
        toLoad.update(version, timestamp, metadata, attrs);
        return toLoad;
    }

    public void putSession(String realId, JBossCacheClusteredSession session) {
        Map<String, Object> attrs;
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("putSession(): putting session " + session.getIdInternal()));
        }
        Fqn fqn = this.getSessionFqn(realId);
        this.setupSessionRegion(session, fqn);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(VERSION_KEY, new Integer(session.getVersion()));
        map.put(TIMESTAMP_KEY, session.getSessionTimestamp());
        if (session.isSessionMetadataDirty()) {
            map.put(METADATA_KEY, session.getSessionMetadata());
        }
        if (session.isSessionAttributeMapDirty() && (attrs = session.getSessionAttributeMap()) != null) {
            map.put(ATTRIBUTE_KEY, this.getMarshalledValue(attrs));
        }
        this.cacheWrapper_.put(fqn, map);
    }

    private void setupSessionRegion(JBossCacheClusteredSession session, Fqn fqn) {
        if (session.needRegionForSession()) {
            this.plainCache_.getRegion(fqn, true);
            session.createdRegionForSession();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Created region for session at " + fqn));
            }
        }
    }

    public void removeSession(String realId, boolean removeRegion) {
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove session from distributed store. Fqn: " + fqn));
        }
        if (removeRegion) {
            this.plainCache_.removeRegion(fqn);
        }
        this.cacheWrapper_.remove(fqn);
    }

    public void removeSessionLocal(String realId, boolean removeRegion) {
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
        }
        if (removeRegion) {
            this.plainCache_.removeRegion(fqn);
        }
        this.cacheWrapper_.removeLocal(fqn);
    }

    public void removeSessionLocal(String realId, String dataOwner) {
        if (dataOwner == null) {
            this.removeSessionLocal(realId, false);
        } else {
            Fqn fqn = this.getSessionFqn(realId, dataOwner);
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
            }
            this.cacheWrapper_.removeLocal(fqn);
        }
    }

    public void evictSession(String realId) {
        this.evictSession(realId, null);
    }

    public void evictSession(String realId, String dataOwner) {
        Fqn fqn;
        Fqn fqn2 = fqn = dataOwner == null ? this.getSessionFqn(realId) : this.getSessionFqn(realId, dataOwner);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("evictSession(): evicting session from my distributed store. Fqn: " + fqn));
        }
        this.cacheWrapper_.evictSubtree(fqn);
    }

    public boolean exists(String realId) {
        Fqn fqn = this.getSessionFqn(realId);
        return this.plainCache_.getRoot().hasChild(fqn);
    }

    public Map getSessionData(String realId, String dataOwner) {
        Fqn fqn = dataOwner == null ? this.getSessionFqn(realId) : this.getSessionFqn(realId, dataOwner);
        return this.cacheWrapper_.getData(fqn, false);
    }

    public Object getAttribute(String realId, String key) {
        Fqn fqn = this.getAttributeFqn(realId);
        return this.getUnMarshalledValue(this.cacheWrapper_.get(fqn, key));
    }

    public void putAttribute(String realId, String key, Object value) {
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.put(fqn, key, this.getMarshalledValue(value));
    }

    public void putAttribute(String realId, Map map) {
        HashMap marshalled = new HashMap(map.size());
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            marshalled.put(entry.getKey(), this.getMarshalledValue(entry.getValue()));
        }
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.put(fqn, marshalled);
    }

    public void removeAttributes(String realId) {
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.remove(fqn);
    }

    public Object removeAttribute(String realId, String key) {
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        return this.getUnMarshalledValue(this.cacheWrapper_.remove(fqn, key));
    }

    public void removeAttributesLocal(String realId) {
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove attributes from my own distributed store only. Fqn: " + fqn));
        }
        this.cacheWrapper_.removeLocal(fqn);
    }

    public Set getAttributeKeys(String realId) {
        Set keys = null;
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            Node node = this.plainCache_.getRoot().getChild(fqn);
            if (node != null) {
                keys = node.getKeys();
            }
        }
        catch (CacheException e) {
            log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Map getAttributes(String realId) {
        if (realId == null || realId.length() == 0) {
            return new HashMap();
        }
        HashMap attrs = new HashMap();
        Fqn fqn = this.getAttributeFqn(realId);
        Node node = this.plainCache_.getRoot().getChild(fqn);
        Map rawData = node.getData();
        for (Map.Entry entry : rawData.entrySet()) {
            attrs.put(entry.getKey(), this.getUnMarshalledValue(entry.getValue()));
        }
        return attrs;
    }

    public Map<String, String> getSessionIds() throws CacheException {
        Set owners;
        HashMap<String, String> result = new HashMap<String, String>();
        Node bbRoot = this.plainCache_.getRoot().getChild(BUDDY_BACKUP_FQN);
        if (bbRoot != null && (owners = bbRoot.getChildren()) != null) {
            for (Node owner : owners) {
                Node webRoot = owner.getChild(this.getWebappFqn());
                if (webRoot == null) continue;
                Set ids = webRoot.getChildrenNames();
                this.storeSessionOwners(ids, (String)owner.getFqn().getLastElement(), result);
            }
        }
        this.storeSessionOwners(this.getChildrenNames(this.getWebappFqn()), null, result);
        return result;
    }

    protected Set getChildrenNames(Fqn fqn) {
        Node node = this.plainCache_.getRoot().getChild(fqn);
        return node == null ? null : node.getChildrenNames();
    }

    private void storeSessionOwners(Set<String> ids, String owner, Map<String, String> map) {
        if (ids != null) {
            for (String id : ids) {
                if ("__JBossInternal__".equals(id)) continue;
                map.put(id, owner);
            }
        }
    }

    public boolean isBuddyReplicationEnabled() {
        BuddyReplicationConfig brc = this.plainCache_.getConfiguration().getBuddyReplicationConfig();
        return brc != null && brc.isEnabled();
    }

    public boolean isCachePassivationEnabled() {
        return this.usePassivation_;
    }

    protected Fqn getWebappFqn() {
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        return new Fqn(objs);
    }

    protected Fqn getSessionFqn(String id) {
        return JBossCacheService.getSessionFqn(this.hostName_, this.webAppPath_, id);
    }

    public static Fqn getSessionFqn(String hostname, String contextPath, String sessionId) {
        Object[] objs = new Object[]{SESSION, hostname, contextPath, sessionId};
        return new Fqn(objs);
    }

    private Fqn getSessionFqn(String id, String dataOwner) {
        return JBossCacheService.getSessionFqn(dataOwner, this.hostName_, this.webAppPath_, id);
    }

    public static Fqn getSessionFqn(String dataOwner, String hostname, String contextPath, String sessionId) {
        Object[] objs = new Object[]{BUDDY_BACKUP, dataOwner, SESSION, hostname, contextPath, sessionId};
        return new Fqn(objs);
    }

    protected Fqn getAttributeFqn(String id) {
        return JBossCacheService.getAttributeFqn(this.hostName_, this.webAppPath_, id);
    }

    public static Fqn getAttributeFqn(String hostname, String contextPath, String sessionId) {
        Object[] objs = new Object[]{SESSION, hostname, contextPath, sessionId, ATTRIBUTE};
        return new Fqn(objs);
    }

    private Object getMarshalledValue(Object value) {
        if (MarshalledValueHelper.isTypeExcluded(value.getClass())) {
            return value;
        }
        try {
            SimpleCachableMarshalledValue mv = SessionSerializationFactory.createMarshalledValue((Serializable)value);
            return mv;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(value + " does not implement java.io.Serializable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getUnMarshalledValue(Object obj) {
        if (!(obj instanceof SimpleCachableMarshalledValue)) {
            return obj;
        }
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.manager_.getWebappClassLoader());
        try {
            try {
                SimpleCachableMarshalledValue mv = (SimpleCachableMarshalledValue)obj;
                mv.setObjectStreamSource(SessionSerializationFactory.getObjectStreamSource());
                Serializable serializable = mv.get();
                Object var6_9 = null;
                Thread.currentThread().setContextClassLoader(prevTCL);
                return serializable;
            }
            catch (IOException e) {
                log_.error((Object)"IOException occurred unmarshalling value ", (Throwable)e);
                Object var4_7 = null;
                Object var6_10 = null;
                Thread.currentThread().setContextClassLoader(prevTCL);
                return var4_7;
            }
            catch (ClassNotFoundException e) {
                log_.error((Object)"ClassNotFoundException occurred unmarshalling value ", (Throwable)e);
                Object var4_8 = null;
                Object var6_11 = null;
                Thread.currentThread().setContextClassLoader(prevTCL);
                return var4_8;
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            Thread.currentThread().setContextClassLoader(prevTCL);
            throw throwable;
        }
    }
}

