/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.aop.Advised;
import org.jboss.web.tomcat.service.session.FieldBasedJBossCacheService;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.Util;

class FieldBasedClusteredSession
extends JBossCacheClusteredSession {
    private static final long serialVersionUID = 8347544395334247623L;
    protected static final String info = "FieldBasedClusteredSession/1.0";
    protected transient Map attributes_ = Collections.synchronizedMap(new HashMap());
    protected transient FieldBasedJBossCacheService fieldProxy_;
    protected transient boolean needRegion_ = true;

    public FieldBasedClusteredSession(JBossCacheManager manager) {
        super(manager);
    }

    public void recycle() {
        super.recycle();
        this.attributes_.clear();
        this.needRegion_ = true;
    }

    public boolean needRegionForSession() {
        return this.needRegion_;
    }

    public boolean hasRegionForSession() {
        return !this.needRegion_;
    }

    public void createdRegionForSession() {
        this.needRegion_ = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FieldBasedClusteredSession[");
        sb.append(super.toString());
        sb.append("]");
        return sb.toString();
    }

    public void removeMyself() {
        this.proxy_.removeSession(this.realId, true);
    }

    public void removeMyselfLocal() {
        this.fieldProxy_.removePojosLocal(this.realId);
        this.fieldProxy_.removeSessionLocal(this.realId, true);
    }

    protected void establishProxy() {
        if (this.fieldProxy_ == null) {
            this.fieldProxy_ = ((JBossCacheManager)this.manager).getPojoCacheService();
            if (this.fieldProxy_ == null) {
                throw new IllegalStateException("Cache service is null");
            }
            this.proxy_ = this.fieldProxy_;
        }
    }

    protected void populateAttributes() {
        Map excluded = FieldBasedClusteredSession.removeExcludedAttributes(this.attributes_);
        Set keys = this.fieldProxy_.getPojoKeys(this.realId);
        HashSet oldKeys = new HashSet(this.attributes_.keySet());
        boolean hasListener = false;
        if (keys != null) {
            oldKeys.removeAll(keys);
            for (String name : keys) {
                Object newAttrib = this.fieldProxy_.getPojo(this.realId, name);
                if (newAttrib != null) {
                    this.attributes_.put(name, newAttrib);
                    if (!(newAttrib instanceof HttpSessionActivationListener)) continue;
                    hasListener = true;
                    continue;
                }
                this.attributes_.remove(name);
            }
        }
        this.hasActivationListener = hasListener ? Boolean.TRUE : Boolean.FALSE;
        Iterator it = oldKeys.iterator();
        while (it.hasNext()) {
            this.attributes_.remove(it.next());
        }
        if (excluded != null) {
            this.attributes.putAll(excluded);
        }
    }

    protected Object getJBossInternalAttribute(String name) {
        Object result = this.attributes_.get(name);
        if (this.isGetDirty(result)) {
            this.sessionAttributesDirty();
        }
        return result;
    }

    protected boolean isMutable(Object attribute) {
        boolean pojo = attribute instanceof Advised;
        boolean mutable = !pojo && super.isMutable(attribute);
        return mutable;
    }

    protected Object removeJBossInternalAttribute(String name, boolean localCall, boolean localOnly) {
        Object result;
        if (localCall && !replicationExcludes.contains(name)) {
            if (localOnly) {
                this.fieldProxy_.removePojoLocal(this.realId, name);
            } else {
                this.fieldProxy_.removePojo(this.realId, name);
            }
            this.sessionAttributesDirty();
        }
        if ((result = this.attributes_.remove(name)) == null) {
            log.warn((Object)("removeJBossInternalAttribute(): null value to remove with key: " + name));
            return null;
        }
        return result;
    }

    protected Map getJBossInternalAttributes() {
        return this.attributes_;
    }

    protected Set getJBossInternalKeys() {
        return this.attributes_.keySet();
    }

    protected String[] keys() {
        return this.getJBossInternalKeys().toArray(EMPTY_ARRAY);
    }

    protected boolean canAttributeBeReplicated(Object attribute) {
        return attribute == null || Util.checkPojoType(attribute);
    }

    protected Object setJBossInternalAttribute(String key, Object value) {
        Object oldVal = null;
        if (!replicationExcludes.contains(key)) {
            oldVal = this.fieldProxy_.setPojo(this.realId, key, value, this);
            if (value != null && (value instanceof Map || value instanceof Collection)) {
                value = this.fieldProxy_.getPojo(this.realId, key);
            }
            this.sessionAttributesDirty();
        }
        oldVal = this.attributes_.put(key, value);
        return oldVal;
    }
}

