/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.File;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.web.tomcat.security.HttpServletRequestPolicyContextHandler;
import org.jboss.web.tomcat.service.deployers.TomcatDeployer;
import org.jboss.web.tomcat.service.deployers.TomcatServiceMBean;

public class TomcatService
extends ServiceMBeanSupport
implements NotificationListener,
TomcatServiceMBean {
    private TomcatDeployer tomcatDeployer;

    public TomcatDeployer getTomcatDeployer() {
        return this.tomcatDeployer;
    }

    public void setTomcatDeployer(TomcatDeployer tomcatDeployer) {
        this.tomcatDeployer = tomcatDeployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before starting");
        }
        this.tomcatDeployer.setServiceClassLoader(this.getClass().getClassLoader());
        CatalinaProperties.getProperty((String)"");
        this.log.debug((Object)"Starting tomcat deployer");
        MBeanServer server = super.getServer();
        System.setProperty("catalina.ext.dirs", System.getProperty("jboss.server.home.dir") + File.separator + "lib");
        String objectNameS = this.tomcatDeployer.getDomain() + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        Registry.getRegistry().setMBeanServer(server);
        Registry.getRegistry().registerComponent(Class.forName("org.apache.catalina.startup.Catalina").newInstance(), objectName, "org.apache.catalina.startup.Catalina");
        server.setAttribute(objectName, new Attribute("catalinaHome", System.getProperty("jboss.server.home.dir")));
        server.setAttribute(objectName, new Attribute("configFile", this.tomcatDeployer.getConfigFile()));
        server.setAttribute(objectName, new Attribute("useNaming", new Boolean(false)));
        server.setAttribute(objectName, new Attribute("useShutdownHook", new Boolean(false)));
        server.setAttribute(objectName, new Attribute("await", new Boolean(false)));
        server.setAttribute(objectName, new Attribute("redirectStreams", new Boolean(false)));
        server.invoke(objectName, "create", new Object[0], new String[0]);
        server.invoke(objectName, "start", new Object[0], new String[0]);
        InitialContext ic = new InitialContext();
        try {
            ic.bind("TomcatAuthenticators", (Object)this.tomcatDeployer.getAuthenticators());
        }
        catch (NamingException ne) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Binding Authenticators to JNDI failed", (Throwable)ne);
            }
        }
        finally {
            try {
                ic.close();
            }
            catch (NamingException nee) {}
        }
        HttpServletRequestPolicyContextHandler handler = new HttpServletRequestPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)handler, (boolean)true);
        Boolean started = (Boolean)server.getAttribute(ServerImplMBean.OBJECT_NAME, "Started");
        if (started.booleanValue()) {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' already started, starting connectors now"));
            this.startConnectors();
        } else {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' not started, registering for start-up notification"));
            server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
        }
    }

    protected void stopService() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before stopping");
        }
        this.stopConnectors();
        MBeanServer server = super.getServer();
        String objectNameS = this.tomcatDeployer.getDomain() + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        server.invoke(objectName, "stop", new Object[0], new String[0]);
        server.invoke(objectName, "destroy", new Object[0], new String[0]);
        server.unregisterMBean(objectName);
        MBeanServer server2 = server;
        ObjectName queryObjectName = new ObjectName(this.tomcatDeployer.getDomain() + ":*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName toRemove = oi.getObjectName();
            if ("WebServer".equals(toRemove.getKeyProperty("service")) || !server2.isRegistered(toRemove)) continue;
            server2.unregisterMBean(toRemove);
        }
        queryObjectName = new ObjectName("Catalina:*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName name = oi.getObjectName();
            server2.unregisterMBean(name);
        }
    }

    public String getConfigFile() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getConfigFile();
    }

    public String getContextMBeanCode() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getContextMBeanCode();
    }

    public String getDomain() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getDomain();
    }

    public String[] getFilteredPackages() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getFilteredPackages();
    }

    public String getManagerClass() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getManagerClass();
    }

    public String getSessionIdAlphabet() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getSessionIdAlphabet();
    }

    public String getSubjectAttributeName() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getSubjectAttributeName();
    }

    public boolean getUseJBossWebLoader() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getUseJBossWebLoader();
    }

    public boolean isAllowSelfPrivilegedWebApps() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.isAllowSelfPrivilegedWebApps();
    }

    public void setAllowSelfPrivilegedWebApps(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setAllowSelfPrivilegedWebApps(flag);
        }
    }

    public void setConfigFile(String configFile) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setConfigFile(configFile);
        }
    }

    public void setContextMBeanCode(String className) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setContextMBeanCode(className);
        }
    }

    public void setDomain(String domainName) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDomain(domainName);
        }
    }

    public void setFilteredPackages(String[] pkgs) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setFilteredPackages(pkgs);
        }
    }

    public void setManagerClass(String managerClass) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setManagerClass(managerClass);
        }
    }

    public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSecurityManagerService(mgr);
        }
    }

    public void setSessionIdAlphabet(String sessionIdAlphabet) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSessionIdAlphabet(sessionIdAlphabet);
        }
    }

    public void setSubjectAttributeName(String name) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSubjectAttributeName(name);
        }
    }

    public void setUseJBossWebLoader(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setUseJBossWebLoader(flag);
        }
    }

    public void startConnectors() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before starting connectors");
        }
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.tomcatDeployer.getDomain() + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.start();
        }
    }

    public void stopConnectors() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before stopping connectors");
        }
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.tomcatDeployer.getDomain() + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.stop();
        }
    }

    public void handleNotification(Notification msg, Object handback) {
        String type = msg.getType();
        if (type.equals("org.jboss.system.server.started")) {
            this.log.debug((Object)("Saw " + type + " notification, starting connectors"));
            try {
                this.startConnectors();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to startConnectors", (Throwable)e);
            }
        }
    }

    public String getDefaultSecurityDomain() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getDefaultSecurityDomain();
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getJava2ClassLoadingCompliance();
    }

    public boolean getLenientEjbLink() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getLenientEjbLink();
    }

    public boolean getUnpackWars() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getUnpackWars();
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDefaultSecurityDomain(defaultSecurityDomain);
        }
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setJava2ClassLoadingCompliance(flag);
        }
    }

    public void setLenientEjbLink(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setLenientEjbLink(flag);
        }
    }

    public void setUnpackWars(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setUnpackWars(flag);
        }
    }
}

