/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityAssociationActions {
    public static final String AUTH_EXCEPTION_KEY = "org.jboss.security.exception";

    SecurityAssociationActions() {
    }

    static void clearSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static SecurityContext createSecurityContext(final String securityDomain) throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)securityDomain);
            }
        });
    }

    static SecurityContext createSecurityContext(final String securityDomain, final String fqnClassName) throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)securityDomain, (String)fqnClassName);
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static void clear() {
        AccessController.doPrivileged(ClearAction.ACTION);
    }

    static Subject getSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static Principal getPrincipal() {
        Principal principal = (Principal)AccessController.doPrivileged(GetPrincipalAction.ACTION);
        return principal;
    }

    static Object getCredential() {
        Object credential = AccessController.doPrivileged(GetCredentialAction.ACTION);
        return credential;
    }

    static void pushRunAsIdentity(RunAsIdentity principal) {
        PushRunAsRoleAction action = new PushRunAsRoleAction(principal);
        AccessController.doPrivileged(action);
    }

    static RunAsIdentity popRunAsIdentity() {
        RunAsIdentity principal = (RunAsIdentity)AccessController.doPrivileged(PopRunAsRoleAction.ACTION);
        return principal;
    }

    static Throwable getAuthException() {
        Throwable ex = (Throwable)AccessController.doPrivileged(GetAuthExceptionAction.ACTION);
        return ex;
    }

    static void clearAuthException() {
        AccessController.doPrivileged(ClearAuthExceptionAction.ACTION);
    }

    static Class<?> loadClass(final String fqn) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException, ClassNotFoundException {
                return Thread.currentThread().getContextClassLoader().loadClass(fqn);
            }
        });
    }

    static Subject getSubjectFromRequestPrincipal(final Principal userPrincipal) {
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                if (userPrincipal instanceof JBossGenericPrincipal) {
                    return ((JBossGenericPrincipal)((Object)userPrincipal)).getSubject();
                }
                return null;
            }
        });
    }

    private static class ClearAuthExceptionAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new ClearAuthExceptionAction();

        private ClearAuthExceptionAction() {
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            sc.getData().put(SecurityAssociationActions.AUTH_EXCEPTION_KEY, null);
            return null;
        }
    }

    private static class GetAuthExceptionAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetAuthExceptionAction();

        private GetAuthExceptionAction() {
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            Object exception = sc.getData().get(SecurityAssociationActions.AUTH_EXCEPTION_KEY);
            return exception;
        }
    }

    private static class PopRunAsRoleAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new PopRunAsRoleAction();

        private PopRunAsRoleAction() {
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            RunAs principal = null;
            principal = sc.getOutgoingRunAs();
            sc.setOutgoingRunAs(null);
            return principal;
        }
    }

    private static class PushRunAsRoleAction
    implements PrivilegedAction {
        RunAsIdentity principal;

        PushRunAsRoleAction(RunAsIdentity principal) {
            this.principal = principal;
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            sc.setOutgoingRunAs((RunAs)this.principal);
            return null;
        }
    }

    private static class GetCredentialAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetCredentialAction();

        private GetCredentialAction() {
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            return sc.getUtil().getCredential();
        }
    }

    private static class GetPrincipalAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetPrincipalAction();

        private GetPrincipalAction() {
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            return sc.getUtil().getUserPrincipal();
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            return sc.getUtil().getSubject();
        }
    }

    private static class ClearAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new ClearAction();

        private ClearAction() {
        }

        public Object run() {
            SecurityContextAssociation.clearSecurityContext();
            return null;
        }
    }

    private static class SetPrincipalInfoAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;
        Subject subject;
        String securityDomain;

        SetPrincipalInfoAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        public Object run() {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context has not been set");
            }
            sc.getUtil().createSubjectInfo(this.principal, this.credential, this.subject);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

