/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndipolicy.impl;

import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;

public class PackagingBasedJndiBindingPolicy
implements DefaultJndiBindingPolicy {
    private static final String JNDI_SUFFIX_REMOTE = "/remote";
    private static final String JNDI_SUFFIX_LOCAL = "/local";
    private static final String JNDI_SUFFIX_REMOTE_HOME = "/home";
    private static final String JNDI_SUFFIX_LOCAL_HOME = "/localHome";

    public String getJndiName(EjbDeploymentSummary summary) {
        if (!summary.isLocal()) {
            if (summary.isHome()) {
                return this.getDefaultRemoteHomeJndiName(summary);
            }
            return this.getDefaultRemoteJndiName(summary);
        }
        if (summary.isHome()) {
            return this.getDefaultLocalHomeJndiName(summary);
        }
        return this.getDefaultLocalJndiName(summary);
    }

    public String getDefaultRemoteJndiName(EjbDeploymentSummary summary) {
        String name = summary.getEjbName() + JNDI_SUFFIX_REMOTE;
        if (summary.getDeploymentScopeBaseName() != null) {
            name = summary.getDeploymentScopeBaseName() + "/" + name;
        }
        return name;
    }

    public String getDefaultRemoteHomeJndiName(EjbDeploymentSummary summary) {
        return summary.getEjbName() + JNDI_SUFFIX_REMOTE_HOME;
    }

    public String getDefaultLocalHomeJndiName(EjbDeploymentSummary summary) {
        return summary.getEjbName() + JNDI_SUFFIX_LOCAL_HOME;
    }

    public String getDefaultLocalJndiName(EjbDeploymentSummary summary) {
        String name = summary.getEjbName() + JNDI_SUFFIX_LOCAL;
        if (summary.getDeploymentScopeBaseName() != null) {
            name = summary.getDeploymentScopeBaseName() + "/" + name;
        }
        return name;
    }

    public String getJndiName(EjbDeploymentSummary summary, String iface, KnownInterfaces.KnownInterfaceType ifaceType) {
        return this.getJndiName(summary);
    }
}

