/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.singleton.HASingletonElectionPolicySimple;
import org.jboss.ha.singleton.PreferredMasterElectionPolicyMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferredMasterElectionPolicy
extends HASingletonElectionPolicySimple
implements PreferredMasterElectionPolicyMBean {
    private String preferredMaster;

    @Override
    public void setPreferredMaster(String node) {
        this.preferredMaster = node;
    }

    @Override
    public String getPreferredMaster() {
        return this.preferredMaster;
    }

    @Override
    protected ClusterNode elect(List<ClusterNode> candidates) {
        if (this.preferredMaster != null) {
            this.log.debug((Object)("Checking if " + this.preferredMaster + " is in candidate list " + candidates));
            for (ClusterNode node : candidates) {
                if (!node.getName().equals(this.preferredMaster)) continue;
                return node;
            }
            URI uri = this.createUri(this.preferredMaster);
            InetAddress addr = this.parseInetAddress(uri);
            if (addr != null) {
                int port = uri.getPort();
                String rewritten = addr.getHostAddress() + ":" + port;
                if (this.preferredMaster.equals(rewritten)) {
                    rewritten = addr.getHostName() + ":" + port;
                }
                for (ClusterNode node : candidates) {
                    if (!node.getName().equals(rewritten)) continue;
                    return node;
                }
            }
        }
        return super.elect(candidates);
    }

    protected URI createUri(String str) {
        try {
            return new URI("cluster://" + this.preferredMaster);
        }
        catch (URISyntaxException use) {
            this.log.debug((Object)("Cannot extract URI from " + this.preferredMaster), (Throwable)use);
            return null;
        }
    }

    protected InetAddress parseInetAddress(URI uri) {
        if (uri != null) {
            String host = uri.getHost();
            int port = uri.getPort();
            if (host != null && port != -1) {
                try {
                    InetAddress addr = InetAddress.getByName(host);
                    this.log.debug((Object)("Parsed " + this.preferredMaster + " into " + addr + " and " + port));
                    return addr;
                }
                catch (UnknownHostException uhe) {
                    this.log.debug((Object)("Cannot extract InetAddress from " + this.preferredMaster), (Throwable)uhe);
                }
            }
        }
        return null;
    }
}

