/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation.bridges;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.jboss.cache.invalidation.BatchInvalidation;
import org.jboss.cache.invalidation.BridgeInvalidationSubscription;
import org.jboss.cache.invalidation.InvalidationBridgeListener;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.cache.invalidation.bridges.JGCacheInvalidationBridgeMBean;
import org.jboss.cache.invalidation.bridges.NodeInfo;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.system.ServiceMBeanSupport;

public class JGCacheInvalidationBridge
extends ServiceMBeanSupport
implements JGCacheInvalidationBridgeMBean,
DistributedState.DSListenerEx,
InvalidationBridgeListener,
DistributedReplicantManager.ReplicantListener {
    protected HAPartition partition;
    protected String bridgeName = "DefaultJGCacheIB";
    protected DistributedState ds = null;
    protected DistributedReplicantManager drm = null;
    protected String RPC_HANDLER_NAME = null;
    protected String nodeName = null;
    protected InvalidationManagerMBean invalMgr = null;
    protected BridgeInvalidationSubscription invalidationSubscription = null;
    protected Collection localGroups = null;
    protected Vector bridgedGroups = new Vector();
    protected final Class[] rpc_invalidate_types = new Class[]{String.class, Serializable.class};
    protected final Class[] rpc_invalidates_types = new Class[]{String.class, Serializable[].class};
    protected final Class[] rpc_invalidate_all_types = new Class[]{String.class};
    protected final Class[] rpc_batch_invalidate_types = new Class[]{BatchInvalidation[].class};

    public HAPartition getHAPartition() {
        return this.partition;
    }

    public void setHAPartition(HAPartition clusterPartition) {
        this.partition = clusterPartition;
    }

    public String getPartitionName() {
        return this.partition.getPartitionName();
    }

    public String getBridgeName() {
        return this.bridgeName;
    }

    public void setBridgeName(String name) {
        this.bridgeName = name;
    }

    public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
        if (key.equals(this.RPC_HANDLER_NAME) && this.drm.isMasterReplica(this.RPC_HANDLER_NAME)) {
            this.log.debug((Object)"The list of replicants for the JG bridge has changed, computing and updating local info...");
            Collection coll = this.ds.getAllKeys(this.RPC_HANDLER_NAME);
            if (coll == null) {
                this.log.debug((Object)"... No bridge info was associated with this node");
                return;
            }
            ArrayList collCopy = new ArrayList(coll);
            List newReplicantsNodeNames = this.drm.lookupReplicantsNodeNames(this.RPC_HANDLER_NAME);
            for (int i = 0; i < collCopy.size(); ++i) {
                String nodeEntry = (String)collCopy.get(i);
                if (newReplicantsNodeNames.contains(nodeEntry)) continue;
                try {
                    this.log.debug((Object)"removing bridge information associated with this node from the DS");
                    this.ds.remove(this.RPC_HANDLER_NAME, (Serializable)((Object)nodeEntry), true);
                    continue;
                }
                catch (Exception e) {
                    this.log.info((Object)"Unable to remove a node entry from the distributed cache", (Throwable)e);
                }
            }
        }
    }

    public void valueHasChanged(String category, Serializable key, Serializable value, boolean locallyModified) {
        this.updatedBridgedInvalidationGroupsInfo();
    }

    public void keyHasBeenRemoved(String category, Serializable key, Serializable previousContent, boolean locallyModified) {
        this.updatedBridgedInvalidationGroupsInfo();
    }

    public void batchInvalidate(BatchInvalidation[] invalidations, boolean asynchronous) {
        if (invalidations == null) {
            return;
        }
        ArrayList<BatchInvalidation> acceptedGroups = new ArrayList<BatchInvalidation>();
        for (int i = 0; i < invalidations.length; ++i) {
            BatchInvalidation currBI = invalidations[i];
            if (!this.groupExistsRemotely(currBI.getInvalidationGroupName())) continue;
            acceptedGroups.add(currBI);
        }
        if (acceptedGroups.size() > 0) {
            BatchInvalidation[] result = new BatchInvalidation[acceptedGroups.size()];
            result = acceptedGroups.toArray(result);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Transmitting batch invalidation: " + result));
            }
            this._do_rpc_batchInvalidate(result, asynchronous);
        }
    }

    public void invalidate(String invalidationGroupName, Serializable[] keys, boolean asynchronous) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Transmitting invalidations for group: " + invalidationGroupName));
        }
        if (this.groupExistsRemotely(invalidationGroupName)) {
            this._do_rpc_invalidates(invalidationGroupName, keys, asynchronous);
        }
    }

    public void invalidate(String invalidationGroupName, Serializable key, boolean asynchronous) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Transmitting invalidation for group: " + invalidationGroupName));
        }
        if (this.groupExistsRemotely(invalidationGroupName)) {
            this._do_rpc_invalidate(invalidationGroupName, key, asynchronous);
        }
    }

    public void invalidateAll(String groupName, boolean async) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Transmitting for all entries for invalidation for group: " + groupName));
        }
        if (this.groupExistsRemotely(groupName)) {
            this._do_rpc_invalidate_all(groupName, async);
        }
    }

    public void newGroupCreated(String groupInvalidationName) {
        try {
            this.publishLocalInvalidationGroups();
        }
        catch (Exception e) {
            this.log.info((Object)"Problem while registering a new invalidation group over the cluster", (Throwable)e);
        }
    }

    public void groupIsDropped(String groupInvalidationName) {
        try {
            this.publishLocalInvalidationGroups();
        }
        catch (Exception e) {
            this.log.info((Object)"Problem while un-registering a new invalidation group over the cluster", (Throwable)e);
        }
    }

    public InvalidationManagerMBean getInvalidationManager() {
        return this.invalMgr;
    }

    public void setInvalidationManager(InvalidationManagerMBean manager) {
        this.invalMgr = manager;
    }

    public void startService() throws Exception {
        if (this.partition == null) {
            throw new IllegalStateException("HAPartition property must be set before starting InvalidationBridge service");
        }
        this.RPC_HANDLER_NAME = "DCacheBridge-" + this.bridgeName;
        this.ds = this.partition.getDistributedStateService();
        this.drm = this.partition.getDistributedReplicantManager();
        this.nodeName = this.partition.getNodeName();
        this.drm.add(this.RPC_HANDLER_NAME, (Serializable)((Object)""));
        this.drm.registerListener(this.RPC_HANDLER_NAME, (DistributedReplicantManager.ReplicantListener)this);
        this.ds.registerDSListenerEx(this.RPC_HANDLER_NAME, (DistributedState.DSListenerEx)this);
        this.partition.registerRPCHandler(this.RPC_HANDLER_NAME, (Object)this);
        if (this.invalMgr == null) {
            throw new IllegalStateException("Failed to find an InvalidationManagerMBean, ensure one is injected");
        }
        this.publishLocalInvalidationGroups();
        this.updatedBridgedInvalidationGroupsInfo();
        this.invalidationSubscription = this.invalMgr.registerBridgeListener((InvalidationBridgeListener)this);
    }

    public void stopService() {
        try {
            this.partition.unregisterRPCHandler(this.RPC_HANDLER_NAME, (Object)this);
            this.ds.unregisterDSListenerEx(this.RPC_HANDLER_NAME, (DistributedState.DSListenerEx)this);
            this.drm.unregisterListener(this.RPC_HANDLER_NAME, (DistributedReplicantManager.ReplicantListener)this);
            this.drm.remove(this.RPC_HANDLER_NAME);
            this.invalidationSubscription.unregister();
            this.ds.remove(this.RPC_HANDLER_NAME, (Serializable)((Object)this.nodeName), true);
            this.drm = null;
            this.ds = null;
            this.invalidationSubscription = null;
            this.RPC_HANDLER_NAME = null;
            this.nodeName = null;
            this.localGroups = null;
            this.bridgedGroups = new Vector();
        }
        catch (Exception e) {
            this.log.info((Object)"Problem while shuting down invalidation cache bridge", (Throwable)e);
        }
    }

    public void _rpc_invalidate(String invalidationGroupName, Serializable key) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Received remote invalidation for group: " + invalidationGroupName));
        }
        this.invalidationSubscription.invalidate(invalidationGroupName, key);
    }

    public void _rpc_invalidates(String invalidationGroupName, Serializable[] keys) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Received remote invalidations for group: " + invalidationGroupName));
        }
        this.invalidationSubscription.invalidate(invalidationGroupName, keys);
    }

    public void _rpc_invalidate_all(String invalidationGroupName) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Received remote invalidate_all for group: " + invalidationGroupName));
        }
        this.invalidationSubscription.invalidateAll(invalidationGroupName);
    }

    public void _rpc_batchInvalidate(BatchInvalidation[] invalidations) {
        if (this.log.isTraceEnabled() && invalidations != null) {
            this.log.trace((Object)("Received remote batch invalidation for this number of groups: " + invalidations.length));
        }
        this.invalidationSubscription.batchInvalidate(invalidations);
    }

    protected void _do_rpc_invalidate(String invalidationGroupName, Serializable key, boolean asynch) {
        Object[] params = new Object[]{invalidationGroupName, key};
        try {
            if (asynch) {
                this.partition.callAsynchMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_invalidate", params, this.rpc_invalidate_types, true);
            } else {
                this.partition.callMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_invalidate", params, this.rpc_invalidate_types, true);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Distributed invalidation (1) has failed for group " + invalidationGroupName + " (Bridge: " + this.bridgeName + ")"));
        }
    }

    protected void _do_rpc_invalidates(String invalidationGroupName, Serializable[] keys, boolean asynch) {
        Object[] params = new Object[]{invalidationGroupName, keys};
        try {
            if (asynch) {
                this.partition.callAsynchMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_invalidates", params, this.rpc_invalidates_types, true);
            } else {
                this.partition.callMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_invalidates", params, this.rpc_invalidates_types, true);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Distributed invalidation (2) has failed for group " + invalidationGroupName + " (Bridge: " + this.bridgeName + ")"));
        }
    }

    protected void _do_rpc_invalidate_all(String invalidationGroupName, boolean asynch) {
        Object[] params = new Object[]{invalidationGroupName};
        try {
            if (asynch) {
                this.partition.callAsynchMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_invalidate_all", params, this.rpc_invalidate_all_types, true);
            } else {
                this.partition.callMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_invalidate_all", params, this.rpc_invalidate_all_types, true);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Distributed invalidation (2) has failed for group " + invalidationGroupName + " (Bridge: " + this.bridgeName + ")"));
        }
    }

    protected void _do_rpc_batchInvalidate(BatchInvalidation[] invalidations, boolean asynch) {
        Object[] params = new Object[]{invalidations};
        try {
            if (asynch) {
                this.partition.callAsynchMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_batchInvalidate", params, this.rpc_batch_invalidate_types, true);
            } else {
                this.partition.callMethodOnCluster(this.RPC_HANDLER_NAME, "_rpc_batchInvalidate", params, this.rpc_batch_invalidate_types, true);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Distributed invalidation (3) has failed (Bridge: " + this.bridgeName + ")"));
        }
    }

    protected synchronized void publishLocalInvalidationGroups() throws Exception {
        this.localGroups = this.invalMgr.getInvalidationGroups();
        this.log.debug((Object)("Publishing locally available invalidation groups: " + this.localGroups));
        ArrayList content = new ArrayList(this.localGroups);
        ArrayList<String> result = new ArrayList<String>(content.size());
        for (int i = 0; i < content.size(); ++i) {
            String aGroup = ((InvalidationGroup)content.get(i)).getGroupName();
            result.add(aGroup);
        }
        if (result.size() > 0) {
            NodeInfo info = new NodeInfo(result, this.nodeName);
            this.ds.set(this.RPC_HANDLER_NAME, (Serializable)((Object)this.nodeName), (Serializable)info, true);
        } else {
            this.ds.remove(this.RPC_HANDLER_NAME, (Serializable)((Object)this.nodeName), true);
        }
    }

    protected void updatedBridgedInvalidationGroupsInfo() {
        Collection bridgedByNode = this.ds.getAllValues(this.RPC_HANDLER_NAME);
        this.log.debug((Object)"Updating list of invalidation groups that are bridged...");
        if (bridgedByNode != null) {
            ArrayList copy = new ArrayList(bridgedByNode);
            Vector<String> result = new Vector<String>();
            for (int i = 0; i < copy.size(); ++i) {
                NodeInfo infoForNode = (NodeInfo)copy.get(i);
                this.log.trace((Object)("InfoForNode: " + infoForNode));
                if (infoForNode == null || infoForNode.groupName.equals(this.nodeName)) continue;
                ArrayList groupsForNode = infoForNode.groups;
                this.log.trace((Object)("Groups for node: " + groupsForNode));
                for (int j = 0; j < groupsForNode.size(); ++j) {
                    String aGroup = (String)groupsForNode.get(j);
                    if (result.contains(aGroup)) continue;
                    this.log.trace((Object)("Adding: " + aGroup));
                    result.add(aGroup);
                }
            }
            this.bridgedGroups = result;
            this.log.debug((Object)("... computed list of bridged groups: " + result));
        } else {
            this.log.debug((Object)"... nothing needs to be bridged.");
        }
    }

    protected boolean groupExistsRemotely(String groupName) {
        return this.bridgedGroups.contains(groupName);
    }
}

