/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.container.jboss50.deployment.tomcat.WebMetaDataModifier;
import org.jboss.wsf.container.jboss50.transport.WebAppGenerator;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.transport.HttpListenerRef;
import org.jboss.wsf.spi.transport.HttpSpec;
import org.jboss.wsf.spi.transport.ListenerRef;
import org.jboss.wsf.spi.transport.TransportManager;
import org.jboss.wsf.spi.transport.TransportSpec;

public class EndpointAPIHttpTransportManager
implements TransportManager {
    private static Logger log = Logger.getLogger(EndpointAPIHttpTransportManager.class);
    private static final String PROCESSED_BY_DEPLOYMENT_FACTORY = "processed.by.deployment.factory";
    private WebAppGenerator generator;
    private DeploymentFactory factory = new DeploymentFactory();
    private WebMetaDataModifier webMetaDataModifier;
    private DeployerClient mainDeployer;
    private Map<String, org.jboss.wsf.spi.deployment.Deployment> deploymentRegistry = new HashMap<String, org.jboss.wsf.spi.deployment.Deployment>();

    public ListenerRef createListener(Endpoint endpoint, TransportSpec transportSpec) {
        assert (this.generator != null);
        assert (this.webMetaDataModifier != null);
        if (!(transportSpec instanceof HttpSpec)) {
            throw new IllegalArgumentException("Unknown TransportSpec " + transportSpec);
        }
        HttpSpec httpSpec = (HttpSpec)transportSpec;
        org.jboss.wsf.spi.deployment.Deployment topLevelDeployment = endpoint.getService().getDeployment();
        Boolean alreadyDeployed = (Boolean)topLevelDeployment.getProperty(PROCESSED_BY_DEPLOYMENT_FACTORY);
        if (alreadyDeployed == null || !alreadyDeployed.booleanValue()) {
            this.generator.create(topLevelDeployment);
            this.deploy(topLevelDeployment);
            topLevelDeployment.setProperty(PROCESSED_BY_DEPLOYMENT_FACTORY, (Object)Boolean.TRUE);
        }
        SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
        ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
        ServerConfig serverConfig = spi.getServerConfig();
        String host = serverConfig.getWebServiceHost();
        int port = serverConfig.getWebServicePort();
        String hostAndPort = host + (port > 0 ? ":" + port : "");
        HttpListenerRef listenerRef = null;
        try {
            String ctx = httpSpec.getWebContext();
            String pattern = httpSpec.getUrlPattern();
            listenerRef = new HttpListenerRef(ctx, pattern, new URI("http://" + hostAndPort + ctx + pattern));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create ListenerRef", e);
        }
        this.deploymentRegistry.put(listenerRef.getUUID(), topLevelDeployment);
        return listenerRef;
    }

    public void destroyListener(ListenerRef ref) {
        Boolean alreadyDeployed;
        org.jboss.wsf.spi.deployment.Deployment dep = this.deploymentRegistry.get(ref.getUUID());
        if (dep != null && (alreadyDeployed = (Boolean)dep.getProperty(PROCESSED_BY_DEPLOYMENT_FACTORY)) != null && alreadyDeployed.booleanValue()) {
            try {
                this.undeploy(dep);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            dep.removeProperty(PROCESSED_BY_DEPLOYMENT_FACTORY);
        }
        this.deploymentRegistry.remove(ref.getUUID());
    }

    public void setGenerator(WebAppGenerator generator) {
        this.generator = generator;
    }

    public void setWebMetaDataModifier(WebMetaDataModifier webMetaDataModifier) {
        this.webMetaDataModifier = webMetaDataModifier;
    }

    public void setMainDeployer(DeployerClient mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    private void deploy(org.jboss.wsf.spi.deployment.Deployment dep) {
        JBossWebMetaData jbwmd = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (jbwmd == null) {
            throw new WebServiceException("Cannot find web meta data");
        }
        try {
            this.webMetaDataModifier.modifyMetaData(dep);
            AbstractDeployment deployment = this.createSimpleDeployment(dep.getService().getContextRoot());
            MutableAttachments mutableAttachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
            mutableAttachments.addAttachment("org.jboss.ws.generated.webapp", (Object)Boolean.TRUE);
            mutableAttachments.addAttachment(ClassLoaderFactory.class, (Object)new ContextClassLoaderFactory());
            mutableAttachments.addAttachment(JBossWebMetaData.class, (Object)jbwmd);
            this.mainDeployer.deploy(new Deployment[]{deployment});
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private void undeploy(org.jboss.wsf.spi.deployment.Deployment dep) {
        try {
            AbstractDeployment deployment = this.createSimpleDeployment(dep.getService().getContextRoot());
            this.mainDeployer.undeploy(new Deployment[]{deployment});
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private AbstractDeployment createSimpleDeployment(String name) {
        AbstractDeployment unit = new AbstractDeployment(name);
        this.factory.addContext((PredeterminedManagedObjectAttachments)unit, "");
        return unit;
    }

    private static class ContextClassLoaderFactory
    implements ClassLoaderFactory {
        private ContextClassLoaderFactory() {
        }

        public ClassLoader createClassLoader(DeploymentUnit unit) throws Exception {
            return Thread.currentThread().getContextClassLoader();
        }

        public void removeClassLoader(DeploymentUnit unit) throws Exception {
        }
    }
}

